/*
 * Decompiled with CFR 0.152.
 */
package org.phansson.netbeans.net.nbnetauthenticator;

import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.keyring.Keyring;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class NetAuthenticatorPanel
extends JPanel {
    private final String realmName;
    private final String displayMsg;
    private final Preferences prefs;
    private final String prefsKey;
    private final String keyringKey;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPasswordField jPasswordFieldPwd;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JTextField jTextFieldUsername;

    public NetAuthenticatorPanel(String realmName, String displayMsg, String requestingScheme) {
        this.realmName = realmName;
        this.displayMsg = displayMsg + (requestingScheme != null ? "\nAuth scheme : " + requestingScheme : "");
        this.initComponents();
        this.prefs = NbPreferences.forModule(NetAuthenticatorPanel.class).node("authentication");
        this.keyringKey = "authentication." + realmName;
        this.prefsKey = realmName + ".username";
        String username = this.prefs.get(this.prefsKey, null);
        if (username != null) {
            this.jTextFieldUsername.setText(username);
            char[] pwd = Keyring.read((String)this.keyringKey);
            if (pwd != null) {
                this.jPasswordFieldPwd.setText(new String(pwd));
            }
        }
        this.setUsernameTooltip(requestingScheme);
    }

    private void setUsernameTooltip(String requestingScheme) {
        if (requestingScheme != null && requestingScheme.equalsIgnoreCase("ntlm")) {
            this.jTextFieldUsername.setToolTipText("<html>You may optionally prepend the username with the name of your domain followed by a backslash.<br>Example: <code>LONDON\\john</code>");
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldUsername = new JTextField();
        this.jLabel2 = new JLabel();
        this.jPasswordFieldPwd = new JPasswordField();
        this.jScrollPane1 = new JScrollPane();
        this.jScrollPane1.getViewport().setOpaque(false);
        this.jTextArea1 = new JTextArea();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(NetAuthenticatorPanel.class, (String)"NetAuthenticatorPanel.jLabel1.text"));
        this.jTextFieldUsername.setText(NbBundle.getMessage(NetAuthenticatorPanel.class, (String)"NetAuthenticatorPanel.jTextFieldUsername.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(NetAuthenticatorPanel.class, (String)"NetAuthenticatorPanel.jLabel2.text"));
        this.jPasswordFieldPwd.setText(NbBundle.getMessage(NetAuthenticatorPanel.class, (String)"NetAuthenticatorPanel.jPasswordFieldPwd.text"));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText(this.displayMsg);
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setBorder(null);
        this.jTextArea1.setEnabled(false);
        this.jTextArea1.setOpaque(false);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldUsername, -2, 232, -2).addComponent(this.jPasswordFieldPwd, -2, 232, -2)).addGap(45, 45, 45)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextFieldUsername, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jPasswordFieldPwd, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    public String getUsername() {
        String username = this.jTextFieldUsername.getText();
        this.prefs.put(this.prefsKey, username);
        return username;
    }

    public char[] getPassword() {
        Keyring.save((String)this.keyringKey, (char[])this.jPasswordFieldPwd.getPassword(), (String)("Password for " + this.realmName));
        return this.jPasswordFieldPwd.getPassword();
    }
}

