/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.forms;

import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.manager.forms.EntityInfoForm;
import com.paterva.maltego.imgfactoryapi.VirtualIcon;
import com.paterva.maltego.typing.TypeNameValidator;
import com.paterva.maltego.util.ui.dialog.DataEditController;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.openide.WizardDescriptor;
import org.openide.util.ImageUtilities;

public class EntityInfoFormController
extends DataEditController<EntityInfoForm, MaltegoEntitySpec> {
    private static final String PROP_FULLNAME = "maltego.registeredto.fullname";
    private static final String PROP_NAMESPACE = "maltego.registeredto.namespace";

    public EntityInfoFormController() {
        super("entitySpec");
        this.setName("Basic Information");
        this.setDescription("Enter the details for your new entity below.");
        this.setImage(ImageUtilities.loadImage((String)"com/paterva/maltego/entity/manager/resources/AddEntity.png".replace(".png", "48.png")));
    }

    protected String getFirstError(EntityInfoForm component) {
        String baseEntity;
        EntityRegistry registry;
        String name = component.getDisplayName();
        if (name.trim().length() == 0) {
            return "Display name is required";
        }
        String id = component.getID();
        if ((id = id.trim()).length() == 0) {
            return "Unique type name is required";
        }
        String error = TypeNameValidator.checkName((String)id);
        if (error != null) {
            return error;
        }
        if (!this.isEditMode() && (registry = (EntityRegistry)this.getDescriptor().getProperty("entityRegistry")).contains(id)) {
            return "The type '" + id + "' is already registered";
        }
        if (component.hasBaseEntity() && ((baseEntity = component.getBaseEntity()) == null || baseEntity.trim().isEmpty())) {
            return "Base entity not specified";
        }
        if (component.getLargeIconResource() == null) {
            return "At least a large icon is required";
        }
        return null;
    }

    protected EntityInfoForm createComponent() {
        final EntityInfoForm f = new EntityInfoForm();
        f.addChangeListener(this.changeListener());
        f.addDisplayNameFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                String id;
                if (!EntityInfoFormController.this.isEditMode() && (id = f.getID()).trim().length() == 0) {
                    f.setID(EntityInfoFormController.this.createID(f.getDisplayName()));
                }
            }
        });
        return f;
    }

    private String createID(String displayName) {
        String prefix = System.getProperty(PROP_NAMESPACE, null);
        prefix = prefix != null ? prefix.toLowerCase() : System.getProperty(PROP_FULLNAME, "yourorganization").toLowerCase();
        return (prefix + "." + displayName).replaceAll(" ", "");
    }

    protected boolean isEditMode() {
        return this.getDescriptor().getProperty("editMode") == Boolean.TRUE;
    }

    protected void setData(EntityInfoForm component, MaltegoEntitySpec data) {
        if (this.isEditMode()) {
            component.setIDEnabled(false);
            component.setLargeIconResource(VirtualIcon.parse((String)data.getLargeIconResource()).orElse(null));
            component.setSmallIconResource(VirtualIcon.parse((String)data.getSmallIconResource()).orElse(null));
        } else {
            component.setIDEnabled(true);
        }
        component.setDisplayName(data.getDisplayName());
        component.setDescription(data.getDescription());
        component.setID(data.getTypeName());
        WizardDescriptor settings = this.getDescriptor();
        List<String> nonRecentCategories = Arrays.stream((String[])settings.getProperty("categories")).filter(cat -> !cat.equals("RecentlyUsed")).collect(Collectors.toList());
        component.setCategories(nonRecentCategories);
        component.setSelectedCategory(data.getDefaultCategory());
        component.setEntitySpecs(this.getEntitySpecNames());
        component.setBaseEntity(this.getBaseEntity(data));
    }

    private List<String> getEntitySpecNames() {
        EntityRegistry registry = (EntityRegistry)this.getDescriptor().getProperty("entityRegistry");
        Collection specs = registry.getAllVisible();
        ArrayList<String> specNames = new ArrayList<String>();
        for (MaltegoEntitySpec spec : specs) {
            specNames.add(spec.getTypeName());
        }
        Collections.sort(specNames);
        return specNames;
    }

    private String getBaseEntity(MaltegoEntitySpec data) {
        ArrayList baseEntitySpecs = new ArrayList(data.getBaseEntitySpecs());
        baseEntitySpecs.remove("maltego.Unknown");
        String baseEntity = null;
        if (!baseEntitySpecs.isEmpty()) {
            baseEntity = (String)baseEntitySpecs.get(0);
        }
        return baseEntity;
    }

    protected void updateData(EntityInfoForm component, MaltegoEntitySpec data) {
        data.setDisplayName(component.getDisplayName());
        data.setDescription(component.getDescription());
        data.setDefaultCategory(component.getSelectedCategory());
        VirtualIcon largeIcon = component.getLargeIconResource();
        data.setLargeIconResource(largeIcon == null ? null : largeIcon.toString());
        VirtualIcon smallIcon = component.getSmallIconResource();
        data.setSmallIconResource(smallIcon == null ? null : smallIcon.toString());
        if (!this.isEditMode()) {
            data.setTypeName(component.getID().trim());
        }
        String baseEntity = "maltego.Unknown";
        if (component.hasBaseEntity()) {
            baseEntity = component.getBaseEntity();
        }
        data.setBaseEntitySpecs(Arrays.asList(baseEntity));
    }
}

