/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.impl;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.actions.ZoomToSelectionAction;
import com.paterva.maltego.ui.graph.view2d.ZoomAndFlasher;
import com.paterva.maltego.util.output.MessageLinkAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class SelectTransformEntitiesListener
extends MessageLinkAdapter {
    private static final Logger LOG = Logger.getLogger(SelectTransformEntitiesListener.class.getName());
    private Collection<EntityID> _transformEntities;
    private GraphID _graphID;

    public SelectTransformEntitiesListener(GraphID graphID, Collection<EntityID> entityIDs) {
        this._graphID = graphID;
        this._transformEntities = entityIDs;
        LOG.log(Level.FINE, "Link made Graph: {0} Entities: {1}", new Object[]{graphID, entityIDs});
        GraphLifeCycleManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GraphID closedGraphID;
                if ("graphClosed".equals(evt.getPropertyName()) && (closedGraphID = (GraphID)evt.getNewValue()).equals((Object)SelectTransformEntitiesListener.this._graphID)) {
                    SelectTransformEntitiesListener.this._transformEntities = Collections.EMPTY_LIST;
                    SelectTransformEntitiesListener.this._graphID = null;
                    GraphLifeCycleManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
        });
    }

    public Collection<EntityID> getEntityIDs() {
        return Collections.unmodifiableCollection(this._transformEntities);
    }

    public void linkAction() {
        try {
            boolean found = false;
            for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
                GraphCookie cookie = (GraphCookie)tc.getLookup().lookup(GraphCookie.class);
                if (cookie == null || this._graphID == null || !this._graphID.equals((Object)cookie.getGraphID())) continue;
                if (!tc.isShowing()) {
                    tc.requestActive();
                }
                GraphID graphID = cookie.getGraphID();
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
                Set existingEntityIDs = structureReader.getExistingEntities(this._transformEntities);
                LOG.log(Level.FINE, "Link clicked Graph: {0} Entities: {1}", new Object[]{graphID, this._transformEntities});
                GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
                selection.setSelectedModelEntities((Collection)existingEntityIDs);
                if (existingEntityIDs.size() == 1) {
                    EntityID entityID = (EntityID)existingEntityIDs.iterator().next();
                    try {
                        ZoomAndFlasher.instance().zoomAndFlash(graphID, entityID);
                    }
                    catch (GraphStoreException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else {
                    this.zoomToSelection(tc);
                }
                found = true;
            }
            if (!found) {
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)"The applicable graph is not open or entities deleted.");
                msg.setTitle("Entities Missing");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void zoomToSelection(TopComponent tc) {
        GraphViewCookie cookie = (GraphViewCookie)tc.getLookup().lookup(GraphViewCookie.class);
        if (cookie != null) {
            ((ZoomToSelectionAction)SystemAction.get(ZoomToSelectionAction.class)).zoomToSelection(cookie);
        }
    }
}

