/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.iconloader.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;
import sun.swing.DefaultLookup;

public class DarculaModTabbedPaneUI
extends BasicTabbedPaneUI {
    private TabbedPaneMouseMotionListener _tabbedBarMouseMotionListener;
    private TabbedPaneMouseListener _tabbedBarMouseListener;
    private int _mouseOverTab = -1;

    public static ComponentUI createUI(JComponent component) {
        return new DarculaModTabbedPaneUI();
    }

    @Override
    public void installUI(JComponent component) {
        super.installUI(component);
        this._tabbedBarMouseListener = new TabbedPaneMouseListener();
        this._tabbedBarMouseMotionListener = new TabbedPaneMouseMotionListener();
        this.tabPane.addMouseListener(this._tabbedBarMouseListener);
        this.tabPane.addMouseMotionListener(this._tabbedBarMouseMotionListener);
    }

    @Override
    public void uninstallUI(JComponent component) {
        this.tabPane.removeMouseListener(this._tabbedBarMouseListener);
        this.tabPane.removeMouseMotionListener(this._tabbedBarMouseMotionListener);
        super.uninstallUI(component);
    }

    @Override
    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        Color oldColor = g.getColor();
        g.setColor(this.tabPane.getBackground());
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        g.fillRect(0, 0, width, height);
        g.setColor(oldColor);
        super.paintTabArea(g, tabPlacement, selectedIndex);
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int tabPlacement, int tabIndex, int x, int y, int width, int height, boolean isSelected) {
        Color oldColor = graphics.getColor();
        Color background = this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex) ? (isSelected || this._mouseOverTab == tabIndex ? (DarculaModTabbedPaneUI.isCloseButtonTabbedPane(this.tabPane) ? UIManager.getLookAndFeelDefaults().getColor("7-white") : UIManager.getLookAndFeelDefaults().getColor("TabbedPane.tabSelected")) : UIManager.getLookAndFeelDefaults().getColor("TabbedPane.tabBackground")) : UIManager.getLookAndFeelDefaults().getColor("TabbedPane.tabBackground");
        graphics.setColor(background);
        graphics.fillRect(x, y, width, height);
        graphics.setColor(oldColor);
    }

    @Override
    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        Rectangle tabRect = this.rects[tabIndex];
        int nudge = DefaultLookup.getInt(this.tabPane, this, "TabbedPane.labelShift", 1);
        switch (tabPlacement) {
            case 3: {
                return -nudge;
            }
            case 2: 
            case 4: {
                return tabRect.height % 2;
            }
        }
        return nudge;
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        GraphicsUtil.setupTextAntialiasing(g, null);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            int x = textRect.x;
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                Color fg = UIManager.getColor("TabbedPane.darculaMod.foreground");
                if (isSelected || this._mouseOverTab == tabIndex) {
                    Color selectedFG = UIManager.getColor("TabbedPane.selectedForeground");
                    if (selectedFG != null) {
                        fg = selectedFG;
                    }
                } else {
                    FontMetrics fm = g.getFontMetrics();
                    int width = fm.stringWidth(title);
                    g.setFont(font.deriveFont(0));
                    fm = g.getFontMetrics();
                    x = (x += (width - fm.stringWidth(title)) / 2) > textRect.x ? x : textRect.x;
                }
                g.setColor(fg);
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, x, textRect.y + metrics.getAscent());
            } else {
                FontMetrics fm = g.getFontMetrics();
                int width = fm.stringWidth(title);
                g.setFont(font.deriveFont(0));
                fm = g.getFontMetrics();
                x = (x += (width - fm.stringWidth(title)) / 2) > textRect.x ? x : textRect.x;
                g.setColor(UIManager.getColor("darcula.inactiveForeground"));
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, x, textRect.y + metrics.getAscent());
            }
        }
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int tabPlacement, int tabIndex, int x, int y, int width, int height, boolean isSelected) {
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new MyTabbedPaneLayout();
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected void paintContentBorderTopEdge(Graphics graphics, int tabPlacement, int selectedIndex, int x, int y, int width, int height) {
    }

    @Override
    protected void paintContentBorderRightEdge(Graphics graphics, int tabPlacement, int selectedIndex, int x, int y, int width, int height) {
    }

    @Override
    protected void paintContentBorderLeftEdge(Graphics graphics, int tabPlacement, int selectedIndex, int x, int y, int width, int height) {
    }

    @Override
    protected void paintContentBorderBottomEdge(Graphics graphics, int tabPlacement, int selectedIndex, int x, int y, int width, int height) {
    }

    protected boolean isTabVisible(int index) {
        return index < this.rects.length && this.rects[index] != null;
    }

    protected Rectangle getTabBoundsNoCheckLayout(int index) {
        Rectangle result = new Rectangle();
        this.getTabBounds(index, result);
        return result;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Rectangle allTabBounds = null;
        for (int i = 0; i < this.tabPane.getTabCount(); ++i) {
            if (!this.isTabVisible(i)) continue;
            Rectangle tabBounds = this.getTabBoundsNoCheckLayout(i);
            if (allTabBounds == null) {
                allTabBounds = tabBounds;
                continue;
            }
            allTabBounds.add(tabBounds);
        }
        if (allTabBounds != null && allTabBounds.contains(g.getClipBounds())) {
            this.paintTabArea(g, this.tabPane.getTabPlacement(), this.tabPane.getSelectedIndex());
        } else {
            super.paint(g, c);
        }
    }

    private void mouseMovedCustom(MouseEvent mouseEvent) {
        boolean found = false;
        for (int i = 0; !found && i < this.tabPane.getTabCount(); ++i) {
            Rectangle tabBounds;
            if (!this.isTabVisible(i) || !(tabBounds = this.getTabBoundsNoCheckLayout(i)).contains(mouseEvent.getPoint())) continue;
            found = true;
            if (this._mouseOverTab == i) continue;
            if (this._mouseOverTab >= 0 && this.isTabVisible(this._mouseOverTab) && this.tabPane.getSelectedIndex() != this._mouseOverTab) {
                this.tabPane.repaint(this.getTabBoundsNoCheckLayout(this._mouseOverTab));
            }
            if (this.tabPane.getSelectedIndex() != i) {
                this.tabPane.repaint(tabBounds);
            }
            this._mouseOverTab = i;
        }
        if (!found && this._mouseOverTab >= 0) {
            if (this._mouseOverTab < this.tabPane.getTabCount() && this.isTabVisible(this._mouseOverTab) && this.tabPane.getSelectedIndex() != this._mouseOverTab) {
                this.tabPane.repaint(this.getTabBoundsNoCheckLayout(this._mouseOverTab));
            }
            this._mouseOverTab = -1;
        }
    }

    private static boolean isCloseButtonTabbedPane(JComponent c) {
        return c.getClass().getName().startsWith("org.netbeans.core.windows.view.ui.CloseButtonTabbedPane");
    }

    private class TabbedPaneMouseListener
    extends MouseAdapter {
        private TabbedPaneMouseListener() {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Object meSource = mouseEvent.getSource();
            if (meSource != null && meSource instanceof JComponent && DarculaModTabbedPaneUI.isCloseButtonTabbedPane((JComponent)meSource)) {
                DarculaModTabbedPaneUI.this.mouseMovedCustom(mouseEvent);
            } else if (DarculaModTabbedPaneUI.this._mouseOverTab >= 0) {
                if (DarculaModTabbedPaneUI.this._mouseOverTab < DarculaModTabbedPaneUI.this.tabPane.getTabCount() && DarculaModTabbedPaneUI.this.isTabVisible(DarculaModTabbedPaneUI.this._mouseOverTab) && DarculaModTabbedPaneUI.this.tabPane.getSelectedIndex() != DarculaModTabbedPaneUI.this._mouseOverTab) {
                    DarculaModTabbedPaneUI.this.tabPane.repaint(DarculaModTabbedPaneUI.this.getTabBoundsNoCheckLayout(DarculaModTabbedPaneUI.this._mouseOverTab));
                }
                DarculaModTabbedPaneUI.this._mouseOverTab = -1;
            }
        }
    }

    private class TabbedPaneMouseMotionListener
    extends MouseMotionAdapter {
        private TabbedPaneMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            DarculaModTabbedPaneUI.this.mouseMovedCustom(mouseEvent);
        }
    }

    protected class MyTabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        protected MyTabbedPaneLayout() {
            super(DarculaModTabbedPaneUI.this);
        }

        @Override
        protected void calculateTabRects(int tabPlacement, int tabCount) {
            Rectangle rect;
            int i;
            int returnAt;
            int y;
            int x;
            FontMetrics metrics = DarculaModTabbedPaneUI.this.getFontMetrics();
            Dimension size = DarculaModTabbedPaneUI.this.tabPane.getSize();
            Insets insets = DarculaModTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = UIManager.getLookAndFeelDefaults().getInsets("TabbedPane.darculaMod.tabGapInsets");
            Insets tabAreaInsets = DarculaModTabbedPaneUI.this.getTabAreaInsets(tabPlacement);
            int fontHeight = metrics.getHeight();
            int selectedIndex = DarculaModTabbedPaneUI.this.tabPane.getSelectedIndex();
            boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
            boolean leftToRight = DarculaModTabbedPaneUI.this.tabPane.getComponentOrientation().isLeftToRight();
            switch (tabPlacement) {
                case 2: {
                    DarculaModTabbedPaneUI.this.maxTabWidth = DarculaModTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                    break;
                }
                case 4: {
                    DarculaModTabbedPaneUI.this.maxTabWidth = DarculaModTabbedPaneUI.this.calculateMaxTabWidth(tabPlacement);
                    x = size.width - insets.right - tabAreaInsets.right - DarculaModTabbedPaneUI.this.maxTabWidth;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                    break;
                }
                case 3: {
                    DarculaModTabbedPaneUI.this.maxTabHeight = DarculaModTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = insets.left + tabAreaInsets.left;
                    y = size.height - insets.bottom - tabAreaInsets.bottom - DarculaModTabbedPaneUI.this.maxTabHeight;
                    returnAt = size.width - (insets.right + tabAreaInsets.right);
                    break;
                }
                default: {
                    DarculaModTabbedPaneUI.this.maxTabHeight = DarculaModTabbedPaneUI.this.calculateMaxTabHeight(tabPlacement);
                    x = 0;
                    y = insets.top + tabAreaInsets.top;
                    returnAt = size.width - (insets.right + tabAreaInsets.right);
                }
            }
            int tabRunOverlay = DarculaModTabbedPaneUI.this.getTabRunOverlay(tabPlacement);
            DarculaModTabbedPaneUI.this.runCount = 0;
            DarculaModTabbedPaneUI.this.selectedRun = -1;
            if (tabCount == 0) {
                return;
            }
            for (i = 0; i < tabCount; ++i) {
                rect = DarculaModTabbedPaneUI.this.rects[i];
                if (!verticalTabRuns) {
                    if (i > 0) {
                        rect.x = ((DarculaModTabbedPaneUI)DarculaModTabbedPaneUI.this).rects[i - 1].x + insets2.left + ((DarculaModTabbedPaneUI)DarculaModTabbedPaneUI.this).rects[i - 1].width;
                    } else {
                        ((DarculaModTabbedPaneUI)DarculaModTabbedPaneUI.this).tabRuns[0] = 0;
                        DarculaModTabbedPaneUI.this.runCount = 1;
                        DarculaModTabbedPaneUI.this.maxTabWidth = 0;
                        rect.x = x;
                    }
                    rect.width = DarculaModTabbedPaneUI.this.calculateTabWidth(tabPlacement, i, metrics);
                    DarculaModTabbedPaneUI.this.maxTabWidth = Math.max(DarculaModTabbedPaneUI.this.maxTabWidth, rect.width);
                    if (rect.x != 2 + insets.left && rect.x + rect.width > returnAt) {
                        if (DarculaModTabbedPaneUI.this.runCount > DarculaModTabbedPaneUI.this.tabRuns.length - 1) {
                            DarculaModTabbedPaneUI.this.expandTabRunsArray();
                        }
                        ((DarculaModTabbedPaneUI)DarculaModTabbedPaneUI.this).tabRuns[((DarculaModTabbedPaneUI)DarculaModTabbedPaneUI.this).runCount] = i;
                        DarculaModTabbedPaneUI.this.runCount++;
                        rect.x = x;
                    }
                    rect.y = y;
                    rect.height = DarculaModTabbedPaneUI.this.maxTabHeight;
                } else {
                    if (i > 0) {
                        rect.y = ((DarculaModTabbedPaneUI)DarculaModTabbedPaneUI.this).rects[i - 1].y + ((DarculaModTabbedPaneUI)DarculaModTabbedPaneUI.this).rects[i - 1].height;
                    } else {
                        ((DarculaModTabbedPaneUI)DarculaModTabbedPaneUI.this).tabRuns[0] = 0;
                        DarculaModTabbedPaneUI.this.runCount = 1;
                        DarculaModTabbedPaneUI.this.maxTabHeight = 0;
                        rect.y = y;
                    }
                    rect.height = DarculaModTabbedPaneUI.this.calculateTabHeight(tabPlacement, i, fontHeight);
                    DarculaModTabbedPaneUI.this.maxTabHeight = Math.max(DarculaModTabbedPaneUI.this.maxTabHeight, rect.height);
                    if (rect.y != 2 + insets.top && rect.y + rect.height > returnAt) {
                        if (DarculaModTabbedPaneUI.this.runCount > DarculaModTabbedPaneUI.this.tabRuns.length - 1) {
                            DarculaModTabbedPaneUI.this.expandTabRunsArray();
                        }
                        ((DarculaModTabbedPaneUI)DarculaModTabbedPaneUI.this).tabRuns[((DarculaModTabbedPaneUI)DarculaModTabbedPaneUI.this).runCount] = i;
                        DarculaModTabbedPaneUI.this.runCount++;
                        rect.y = y;
                    }
                    rect.x = x;
                    rect.width = DarculaModTabbedPaneUI.this.maxTabWidth;
                }
                if (i != selectedIndex) continue;
                DarculaModTabbedPaneUI.this.selectedRun = DarculaModTabbedPaneUI.this.runCount - 1;
            }
            if (DarculaModTabbedPaneUI.this.runCount > 1) {
                this.normalizeTabRuns(tabPlacement, tabCount, verticalTabRuns ? y : x, returnAt);
                DarculaModTabbedPaneUI.this.selectedRun = DarculaModTabbedPaneUI.this.getRunForTab(tabCount, selectedIndex);
                if (DarculaModTabbedPaneUI.this.shouldRotateTabRuns(tabPlacement)) {
                    this.rotateTabRuns(tabPlacement, DarculaModTabbedPaneUI.this.selectedRun);
                }
            }
            for (i = DarculaModTabbedPaneUI.this.runCount - 1; i >= 0; --i) {
                int j;
                int end;
                int start = DarculaModTabbedPaneUI.this.tabRuns[i];
                int next = DarculaModTabbedPaneUI.this.tabRuns[i == DarculaModTabbedPaneUI.this.runCount - 1 ? 0 : i + 1];
                int n = end = next != 0 ? next - 1 : tabCount - 1;
                if (!verticalTabRuns) {
                    for (j = start; j <= end; ++j) {
                        rect = DarculaModTabbedPaneUI.this.rects[j];
                        rect.y = y;
                        rect.x += DarculaModTabbedPaneUI.this.getTabRunIndent(tabPlacement, i);
                    }
                    if (DarculaModTabbedPaneUI.this.shouldPadTabRun(tabPlacement, i)) {
                        this.padTabRun(tabPlacement, start, end, returnAt);
                    }
                    if (tabPlacement == 3) {
                        y -= DarculaModTabbedPaneUI.this.maxTabHeight - tabRunOverlay;
                        continue;
                    }
                    y += DarculaModTabbedPaneUI.this.maxTabHeight - tabRunOverlay;
                    continue;
                }
                for (j = start; j <= end; ++j) {
                    rect = DarculaModTabbedPaneUI.this.rects[j];
                    rect.x = x;
                    rect.y += DarculaModTabbedPaneUI.this.getTabRunIndent(tabPlacement, i);
                }
                if (DarculaModTabbedPaneUI.this.shouldPadTabRun(tabPlacement, i)) {
                    this.padTabRun(tabPlacement, start, end, returnAt);
                }
                if (tabPlacement == 4) {
                    x -= DarculaModTabbedPaneUI.this.maxTabWidth - tabRunOverlay;
                    continue;
                }
                x += DarculaModTabbedPaneUI.this.maxTabWidth - tabRunOverlay;
            }
            if (!leftToRight && !verticalTabRuns) {
                int rightMargin = size.width - (insets.right + tabAreaInsets.right);
                for (i = 0; i < tabCount; ++i) {
                    ((DarculaModTabbedPaneUI)DarculaModTabbedPaneUI.this).rects[i].x = rightMargin - ((DarculaModTabbedPaneUI)DarculaModTabbedPaneUI.this).rects[i].x - ((DarculaModTabbedPaneUI)DarculaModTabbedPaneUI.this).rects[i].width;
                }
            }
        }
    }
}

