/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.importexport.wizard.im;

import com.paterva.maltego.importexport.Config;
import com.paterva.maltego.importexport.ConfigImporter;
import com.paterva.maltego.importexport.DiscoverService;
import com.paterva.maltego.importexport.nodes.AllConfigsNode;
import com.paterva.maltego.importexport.wizard.im.FailurePanel;
import com.paterva.maltego.importexport.wizard.im.SuccessPanel;
import com.paterva.maltego.util.ui.dialog.PassFailProgressController;
import com.paterva.maltego.util.ui.dialog.WizardNavigationSupport;
import java.util.Map;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.WizardDescriptor;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;

class ImportProgressController2
extends PassFailProgressController<String, SuccessPanel, FailurePanel>
implements WizardNavigationSupport {
    public ImportProgressController2() {
        this.setName("Import");
    }

    public boolean canBack() {
        return false;
    }

    protected SuccessPanel createPassComponent() {
        return new SuccessPanel();
    }

    protected FailurePanel createFailComponent() {
        return new FailurePanel();
    }

    protected void pass(WizardDescriptor descriptor, SuccessPanel component, String result) {
        component.setResult(result);
    }

    protected void fail(FailurePanel component, Exception e) {
        component.setError(e);
    }

    protected String doProcessing(WizardDescriptor descriptor, ProgressHandle handle) throws Exception {
        DiscoverService service;
        this.setDescription("Import progress");
        Object icon = descriptor.getProperty("progress_icon");
        if (icon != null) {
            this.setImage(ImageUtilities.loadImage((String)((String)icon).replace(".png", "48.png")));
        }
        AllConfigsNode allConfigsNode = (AllConfigsNode)((Object)this.getDescriptor().getProperty("allConfigs"));
        Map allConfigs = (Map)this.getDescriptor().getProperty("configsMap");
        Node[] nodes = allConfigsNode.getChildren().getNodes();
        String displayResults = "";
        handle.switchToDeterminate(nodes.length);
        int num = 0;
        for (Node node : nodes) {
            handle.progress("Importing " + node.getDisplayName(), num++);
            Config config = (Config)node.getLookup().lookup(Config.class);
            ConfigImporter importer = (ConfigImporter)allConfigs.get(config);
            int result = importer.applyConfig(config);
            if (result <= 0) continue;
            displayResults = displayResults + "\t" + result + "\t" + node.getName() + "\n";
        }
        displayResults = displayResults.isEmpty() ? "Nothing was imported." : "The following items were imported:\n\n" + displayResults;
        Boolean discover = (Boolean)descriptor.getProperty("shouldDiscover");
        if (discover != null && discover.booleanValue() && (service = DiscoverService.getDefault()) != null) {
            handle.switchToIndeterminate();
            handle.progress("Discovering...");
            service.discover();
        }
        return displayResults;
    }
}

