/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d.layout;

import com.paterva.maltego.util.StringUtilities;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import yguard.A.A.B;
import yguard.A.A.E;
import yguard.A.A.H;
import yguard.A.A.Z;
import yguard.A.A.a;
import yguard.A.G.DA;
import yguard.A.G.HA;
import yguard.A.G.I;
import yguard.A.G.P;
import yguard.A.G.RA;
import yguard.A.G.T;
import yguard.A.G.Y;
import yguard.A.G.b;
import yguard.A.G.m;
import yguard.A.G.s;
import yguard.A.I.K;
import yguard.A.I.M;
import yguard.A.J.BA;
import yguard.A.J.GA;
import yguard.A.J.SA;
import yguard.A.J.X;
import yguard.A.J.gB;
import yguard.A.J.q;

public class MaltegoLabelLayouter
extends DA {
    private static final Logger LOG = Logger.getLogger(MaltegoLabelLayouter.class.getName());
    private int _collisionChecksNode;
    private int _collisionChecksLabel;
    private int _collisionChecksEdge;
    private long _time;
    private Map<HA, T> _newLabelLocations;

    public boolean canLayout(RA lg) {
        return true;
    }

    public void doLayout(RA lg) {
        try {
            this.doLayoutCore(lg);
            this._collisionChecksNode = 0;
            this._collisionChecksLabel = 0;
            this._collisionChecksEdge = 0;
            this._time = System.currentTimeMillis();
            this._newLabelLocations = new HashMap<HA, T>();
            E nodes = lg.\u00a4();
            LOG.log(Level.FINE, "Node count: {0}", nodes.size());
            while (nodes.ok()) {
                yguard.A.A.Y node = nodes.B();
                this.layoutLabel(lg, node, 4);
                nodes.next();
            }
            Z edges = lg.u();
            LOG.log(Level.FINE, "Edge count: {0}", edges.size());
            while (edges.ok()) {
                H edge = edges.D();
                this.layoutLabel(lg, edge);
                edges.next();
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Notes label layout speed = {0}ms", System.currentTimeMillis() - this._time);
                LOG.log(Level.FINE, "Notes label layout collission checks:");
                LOG.log(Level.FINE, "   node = {0}", this._collisionChecksNode);
                LOG.log(Level.FINE, "   label = {0}", this._collisionChecksLabel);
                LOG.log(Level.FINE, "   edge = {0}", this._collisionChecksEdge);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void layoutLabel(RA lg, yguard.A.A.Y node, int index) {
        X originalLabel = this.getOriginalLabel((B)lg, node, index);
        if (originalLabel != null) {
            m labelLayout;
            T bestCandidate;
            m[] labelLayouts;
            boolean visible = originalLabel.isVisible();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "node1 = {0}", this.getOriginalNode((B)lg, node));
                LOG.log(Level.FINE, "   originalLabel = {0} ({1})", new Object[]{originalLabel, visible ? "visible" : "not visible"});
            }
            if (visible && (labelLayouts = lg.V(node)).length > index && (bestCandidate = this.getBestCandidate(lg, node, labelLayout = labelLayouts[index])) != null && !bestCandidate.\u00cc().equals(labelLayout.getModelParameter())) {
                bestCandidate.\u00d0();
                this._newLabelLocations.put((HA)labelLayout, bestCandidate);
            }
        }
    }

    private void layoutLabel(RA lg, H edge) {
        X originalLabel;
        I[] labelLayouts = lg.M(edge);
        if (labelLayouts != null && labelLayouts.length > 0 && (originalLabel = this.getOriginalLabel((B)lg, edge)) != null && originalLabel.isVisible() && !StringUtilities.isNullOrEmpty((String)originalLabel.getText())) {
            I labelLayout;
            T bestCandidate;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "edge1 = \"{0}\"", this.getOriginalEdge((B)lg, edge));
                LOG.log(Level.FINE, "   originalLabel = {0}", originalLabel);
            }
            if ((bestCandidate = this.getBestCandidate(lg, edge, labelLayout = lg.M(edge)[0])) != null && !bestCandidate.\u00cc().equals(labelLayout.getModelParameter())) {
                bestCandidate.\u00d0();
                this._newLabelLocations.put((HA)labelLayout, bestCandidate);
            }
        }
    }

    private T getBestCandidate(RA lg, yguard.A.A.Y node, m labelLayout) {
        b labelModel = labelLayout.getLabelModel();
        a labelCandidates = labelModel.A(labelLayout, lg.G((Object)node));
        Object defaultParameter = labelLayout.getLabelModel().A();
        return this.getBestCandidate(lg, labelCandidates, (HA)labelLayout, defaultParameter, node);
    }

    private T getBestCandidate(RA lg, H edge, I labelLayout) {
        yguard.A.G.X labelModel = labelLayout.getLabelModel();
        P edgeLayout = lg.J((Object)edge);
        s sourceNodeLayout = lg.G((Object)edge.X());
        s targetNodeLayout = lg.G((Object)edge.V());
        a labelCandidates = labelModel.A(labelLayout, edgeLayout, sourceNodeLayout, targetNodeLayout);
        Object defaultParameter = labelLayout.getLabelModel().A();
        return this.getBestCandidate(lg, labelCandidates, (HA)labelLayout, defaultParameter, edge);
    }

    private T getBestCandidate(RA lg, a labelCandidates, HA labelLayout, Object defaultParameter, Object ignore) {
        T labelCandidate;
        double totalIntersectionArea;
        double minIntersectionArea = Double.MAX_VALUE;
        T bestCandidate = null;
        Object currentModelParameter = labelLayout.getModelParameter();
        T current = null;
        for (Object obj : labelCandidates) {
            T labelCandidate2;
            Object modelParameter;
            if (!(obj instanceof T) || !(modelParameter = (labelCandidate2 = (T)obj).\u00cc()).equals(currentModelParameter)) continue;
            current = labelCandidate2;
            minIntersectionArea = totalIntersectionArea = this.getTotalIntersectionArea(labelCandidate2, lg, ignore, minIntersectionArea);
            bestCandidate = labelCandidate2;
            if (!(minIntersectionArea < 1.0)) break;
            LOG.fine("   Current position is best");
            return bestCandidate;
        }
        if (current != null) {
            labelCandidates.remove(current);
        }
        T defaultCandidate = null;
        for (Object obj : labelCandidates) {
            Object modelParameter;
            if (!(obj instanceof T) || !defaultParameter.equals(modelParameter = (labelCandidate = (T)obj).\u00cc())) continue;
            defaultCandidate = labelCandidate;
            double totalIntersectionArea2 = this.getTotalIntersectionArea(labelCandidate, lg, ignore, minIntersectionArea);
            if (bestCandidate != null && !(totalIntersectionArea2 < minIntersectionArea)) continue;
            minIntersectionArea = totalIntersectionArea2;
            bestCandidate = labelCandidate;
            if (!(minIntersectionArea < 1.0)) continue;
            LOG.fine("   Default position is best");
            return bestCandidate;
        }
        if (defaultCandidate != null) {
            labelCandidates.remove(defaultCandidate);
        }
        for (Object obj : labelCandidates) {
            if (!(obj instanceof T)) continue;
            labelCandidate = (T)obj;
            totalIntersectionArea = this.getTotalIntersectionArea(labelCandidate, lg, ignore, minIntersectionArea);
            if (bestCandidate != null && !(totalIntersectionArea < minIntersectionArea)) continue;
            minIntersectionArea = totalIntersectionArea;
            bestCandidate = labelCandidate;
            if (!(minIntersectionArea < 1.0)) continue;
            LOG.log(Level.FINE, "   Best candidate: {0}", bestCandidate);
            return bestCandidate;
        }
        return bestCandidate;
    }

    private double getTotalIntersectionArea(T labelCandidate, RA lg, Object ignore, double stopIfOver) {
        LOG.log(Level.FINE, "   labelCandidate = {0}", labelCandidate);
        K labelBoundingBox = labelCandidate.A();
        double totalIntersectionArea = 0.0;
        totalIntersectionArea += this.getNodesIntersectionArea(lg, ignore, labelBoundingBox, stopIfOver - totalIntersectionArea);
        if (totalIntersectionArea < stopIfOver && (totalIntersectionArea += this.getEdgeLabelIntersectionArea(lg, ignore, labelBoundingBox, stopIfOver - totalIntersectionArea)) < stopIfOver && (totalIntersectionArea += this.getEdgeIntersectionArea(lg, ignore, labelBoundingBox, stopIfOver - totalIntersectionArea)) < stopIfOver && (totalIntersectionArea += this.getNodeLabelIntersectionArea(lg, ignore, labelBoundingBox, 4, stopIfOver - totalIntersectionArea)) < stopIfOver) {
            totalIntersectionArea += this.getNodeLabelIntersectionArea(lg, ignore, labelBoundingBox, 0, stopIfOver - totalIntersectionArea);
        }
        LOG.log(Level.FINE, "   stopIfOver = {0}", stopIfOver);
        LOG.log(Level.FINE, "   totalIntersectionArea = {0}", totalIntersectionArea);
        return totalIntersectionArea;
    }

    private double getNodesIntersectionArea(RA lg, Object ignore, K rect, double stopIfOver) {
        double totalIntersectionArea = 0.0;
        E nodes = lg.\u00a4();
        while (nodes.ok()) {
            yguard.A.A.Y node = nodes.B();
            if (!node.equals(ignore)) {
                s nodeLayout = lg.G((Object)node);
                K nodeRect = new K(nodeLayout.getX(), nodeLayout.getY(), nodeLayout.getWidth(), nodeLayout.getHeight());
                double intersectionArea = this.getIntersectionArea(rect, nodeRect);
                totalIntersectionArea += intersectionArea;
                ++this._collisionChecksNode;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "      node2 = {0}", this.getOriginalNode((B)lg, node));
                    LOG.log(Level.FINE, "         {0} = {1} intersect {2}", new Object[]{intersectionArea, rect, nodeRect});
                }
            }
            if (totalIntersectionArea >= stopIfOver) break;
            nodes.next();
        }
        return totalIntersectionArea;
    }

    private double getNodeLabelIntersectionArea(RA lg, Object ignore, K rect, int labelIndex, double stopIfOver) {
        double totalIntersectionArea = 0.0;
        E nodes = lg.\u00a4();
        while (nodes.ok()) {
            m[] labelLayouts;
            X originalLabel;
            yguard.A.A.Y node = nodes.B();
            if (!node.equals(ignore) && (originalLabel = this.getOriginalLabel((B)lg, node, labelIndex)) != null && originalLabel.isVisible() && (labelLayouts = lg.V(node)).length > labelIndex) {
                m labelLayout = labelLayouts[labelIndex];
                T labelCandidate = this._newLabelLocations.get(labelLayout);
                K otherRect = labelCandidate != null ? labelCandidate.A() : labelLayout.getBox();
                double intersectionArea = this.getIntersectionArea(rect, otherRect);
                totalIntersectionArea += intersectionArea;
                ++this._collisionChecksLabel;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "      node2 = {0}", this.getOriginalNode((B)lg, node));
                    LOG.log(Level.FINE, "         {0} = {1} intersect {2} {3}", new Object[]{intersectionArea, rect, otherRect, labelLayout});
                }
            }
            if (totalIntersectionArea >= stopIfOver) break;
            nodes.next();
        }
        return totalIntersectionArea;
    }

    private double getEdgeIntersectionArea(RA lg, Object ignore, K rect, double stopIfOver) {
        double totalIntersectionArea = 0.0;
        Rectangle2D.Double jRect = new Rectangle2D.Double(rect.\u00fa, rect.\u00fc, rect.\u00f9, rect.\u00f8);
        Z edges = lg.u();
        while (edges.ok()) {
            H edge = edges.D();
            if (!edge.equals(ignore)) {
                M sourcePointAbs = lg.S(edge);
                M targetPointAbs = lg.O(edge);
                Line2D.Double line = new Line2D.Double(sourcePointAbs.A, sourcePointAbs.D, targetPointAbs.A, targetPointAbs.D);
                boolean intersects = line.intersects(jRect);
                ++this._collisionChecksEdge;
                if (intersects) {
                    totalIntersectionArea += 10.0;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "      edge2 = {0}", this.getOriginalEdge((B)lg, edge));
                        LOG.fine("         Collision");
                    }
                }
            }
            if (totalIntersectionArea >= stopIfOver) break;
            edges.next();
        }
        return totalIntersectionArea;
    }

    private double getEdgeLabelIntersectionArea(RA lg, Object ignore, K rect, double stopIfOver) {
        double totalIntersectionArea = 0.0;
        Z edges = lg.u();
        while (edges.ok()) {
            I[] labelLayouts;
            X originalLabel;
            H edge = edges.D();
            if (!edge.equals(ignore) && (originalLabel = this.getOriginalLabel((B)lg, edge)) != null && originalLabel.isVisible() && (labelLayouts = lg.M(edge)).length > 0) {
                I labelLayout = labelLayouts[0];
                T labelCandidate = this._newLabelLocations.get(labelLayout);
                K otherRect = labelCandidate != null ? labelCandidate.A() : labelLayout.getBox();
                double intersectionArea = this.getIntersectionArea(rect, otherRect);
                totalIntersectionArea += intersectionArea;
                ++this._collisionChecksLabel;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "      edge2 = {0}", this.getOriginalEdge((B)lg, edge));
                    LOG.log(Level.FINE, "         {0} = {1} intersect {2} {3}", new Object[]{intersectionArea, rect, otherRect, labelLayout});
                }
            }
            if (totalIntersectionArea >= stopIfOver) break;
            edges.next();
        }
        return totalIntersectionArea;
    }

    private X getOriginalLabel(B graph, yguard.A.A.Y node, int index) {
        SA graph2D;
        BA realizer;
        gB label = null;
        while (graph instanceof Y && node != null) {
            Y copiedGraph = (Y)graph;
            node = (yguard.A.A.Y)copiedGraph.Y(node);
            graph = copiedGraph.\u00d8();
        }
        if (graph instanceof SA && node != null && (realizer = (graph2D = (SA)graph).f(node)) != null && realizer.labelCount() > index) {
            label = realizer.getLabel(index);
        }
        return label;
    }

    private X getOriginalLabel(B graph, H edge) {
        SA graph2D;
        q realizer;
        GA label = null;
        while (graph instanceof Y && edge != null) {
            Y copiedGraph = (Y)graph;
            edge = (H)copiedGraph.V(edge);
            graph = copiedGraph.\u00d8();
        }
        if (graph instanceof SA && edge != null && (realizer = (graph2D = (SA)graph).X(edge)) != null && realizer.labelCount() > 0) {
            label = realizer.getLabel();
        }
        return label;
    }

    private yguard.A.A.Y getOriginalNode(B graph, yguard.A.A.Y node) {
        while (graph instanceof Y && node != null) {
            Y copiedGraph = (Y)graph;
            node = (yguard.A.A.Y)copiedGraph.Y(node);
            graph = copiedGraph.\u00d8();
        }
        return node;
    }

    private H getOriginalEdge(B graph, H edge) {
        while (graph instanceof Y && edge != null) {
            Y copiedGraph = (Y)graph;
            edge = (H)copiedGraph.V(edge);
            graph = copiedGraph.\u00d8();
        }
        return edge;
    }

    private double getIntersectionArea(K rect1, K rect2) {
        if (K.A((K)rect1, (K)rect2)) {
            return this.getArea(this.getIntersection(rect1, rect2));
        }
        return 0.0;
    }

    private double getArea(K rect) {
        return rect.\u00f9 * rect.\u00f8;
    }

    private K getIntersection(K rect1, K rect2) {
        double x1 = Math.max(rect1.\u00fa, rect2.\u00fa);
        double y1 = Math.max(rect1.\u00fc, rect2.\u00fc);
        double x2 = Math.min(rect1.\u00fa + rect1.\u00f9, rect2.\u00fa + rect2.\u00f9);
        double y2 = Math.min(rect1.\u00fc + rect1.\u00f8, rect2.\u00fc + rect2.\u00f8);
        return new K(x1, y1, x2 - x1, y2 - y1);
    }
}

