/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.imex;

import com.paterva.maltego.core.DisplayInformation;
import com.paterva.maltego.core.DisplayInformationCollection;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GenericEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.OverlayDescriptor;
import com.paterva.maltego.core.OverlayDescriptorSet;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.typing.types.InternalFile;
import com.paterva.maltego.typing.types.TimeSpan;
import com.paterva.maltego.ui.graph.imex.IOHelper;
import com.paterva.maltego.ui.graph.view2d.PinUtils;
import com.paterva.maltego.util.FastURL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class MaltegoEntityIOStax {
    private static final Logger LOG = Logger.getLogger(MaltegoEntityIOStax.class.getName());

    public static void write(XMLStreamWriter writer, MaltegoEntity entity, GraphID graphID) throws XMLStreamException {
        AttachmentEntities attEntities = MaltegoEntityIOStax.translateAttachments(entity);
        writer.writeStartElement("mtg", "MaltegoEntity", "http://maltego.paterva.com/xml/mtgx");
        writer.writeAttribute("id", ((EntityID)entity.getID()).toString());
        writer.writeAttribute("type", entity.getTypeName());
        MaltegoEntityIOStax.writeProperties(writer, entity, attEntities.imgIndex, graphID);
        MaltegoEntityIOStax.writeProperties2(writer, entity);
        MaltegoEntityIOStax.writeDisplayInformation(writer, entity.getDisplayInformation());
        MaltegoEntityIOStax.writeWeight(writer, entity.getWeight());
        MaltegoEntityIOStax.writeNotes(writer, entity.getNotes(), entity.isShowNotes());
        MaltegoEntityIOStax.writeBookmarks(writer, entity.getBookmark());
        MaltegoEntityIOStax.writeContainedEntities(writer, entity, attEntities.entities, graphID);
        writer.writeEndElement();
    }

    private static void writeWeight(XMLStreamWriter writer, int weight) throws XMLStreamException {
        if (weight != 0) {
            writer.writeStartElement("mtg", "Weight", "http://maltego.paterva.com/xml/mtgx");
            writer.writeCharacters(String.valueOf(weight));
            writer.writeEndElement();
        }
    }

    private static void writeDisplayInformation(XMLStreamWriter writer, DisplayInformationCollection display) throws XMLStreamException {
        if (display != null && !display.isEmpty()) {
            writer.writeStartElement("mtg", "DisplayInformation", "http://maltego.paterva.com/xml/mtgx");
            for (DisplayInformation di : display) {
                writer.writeStartElement("mtg", "DisplayElement", "http://maltego.paterva.com/xml/mtgx");
                writer.writeAttribute("name", di.getName());
                writer.writeCData(di.getValue());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private static void writeProperties(XMLStreamWriter writer, MaltegoEntity entity, Integer imgIndex, GraphID graphID) throws XMLStreamException {
        writer.writeStartElement("mtg", "Properties", "http://maltego.paterva.com/xml/mtgx");
        MaltegoEntityIOStax.writePropertyName(writer, "value", entity.getValueProperty());
        Optional dispExprOpt = entity.getDisplayValueExpression();
        if (dispExprOpt.isPresent()) {
            writer.writeAttribute("displayValue", (String)dispExprOpt.get());
        }
        if (imgIndex == null) {
            Optional imgExprOpt = entity.getNonBlankImageExpression();
            if (imgExprOpt.isPresent()) {
                writer.writeAttribute("image", (String)imgExprOpt.get());
            }
        } else {
            writer.writeAttribute("image", "MaltegoEntityList#" + imgIndex);
        }
        MaltegoEntityIOStax.writePinnedProperty(writer, entity, graphID);
        for (PropertyDescriptor pd : entity.getProperties()) {
            if (MaltegoEntityIOStax.isProperties2Property(pd) || Attachments.class.equals((Object)pd.getType())) continue;
            IOHelper.writeProperty(writer, (MaltegoPart<? extends Guid>)entity, pd);
        }
        writer.writeEndElement();
    }

    private static boolean isProperties2Property(PropertyDescriptor pd) {
        return DateTime.class.equals((Object)pd.getType()) || TimeSpan.class.equals((Object)pd.getType()) || InternalFile.class.equals((Object)pd.getType());
    }

    private static void writeProperties2(XMLStreamWriter writer, MaltegoEntity entity) throws XMLStreamException {
        ArrayList<PropertyDescriptor> pds = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor pd : entity.getProperties()) {
            if (!MaltegoEntityIOStax.isProperties2Property(pd) || Attachments.class.equals((Object)pd.getType())) continue;
            pds.add(pd);
        }
        if (!pds.isEmpty()) {
            writer.writeStartElement("mtg", "Properties2", "http://maltego.paterva.com/xml/mtgx");
            for (PropertyDescriptor pd : pds) {
                IOHelper.writeProperty(writer, (MaltegoPart<? extends Guid>)entity, pd);
            }
            writer.writeEndElement();
        }
    }

    private static void writePropertyName(XMLStreamWriter writer, String name, PropertyDescriptor property) throws XMLStreamException {
        if (property != null) {
            writer.writeAttribute(name, property.getName());
        }
    }

    private static void writePinnedProperty(XMLStreamWriter writer, MaltegoEntity entity, GraphID graphID) throws XMLStreamException {
        try {
            boolean isPinned;
            if (graphID != null && (isPinned = PinUtils.isPinned(graphID, (EntityID)entity.getID()))) {
                PropertyDescriptor pd = new PropertyDescriptor(Boolean.TYPE, "pinned#", "Pinned");
                writer.writeStartElement("mtg", "Property", "http://maltego.paterva.com/xml/mtgx");
                writer.writeAttribute("displayName", pd.getDisplayName());
                writer.writeAttribute("hidden", Boolean.toString(pd.isHidden()));
                writer.writeAttribute("name", pd.getName());
                writer.writeAttribute("nullable", Boolean.toString(pd.isNullable()));
                writer.writeAttribute("readonly", Boolean.toString(pd.isReadonly()));
                TypeDescriptor td = TypeRegistry.getDefault().getType(pd.getType());
                writer.writeAttribute("type", td.getTypeName());
                writer.writeStartElement("mtg", "Value", "http://maltego.paterva.com/xml/mtgx");
                String text = td.convert((Object)true);
                writer.writeCharacters(text != null ? text : "");
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Failed to check pinned state for entity {0}: {1}", new Object[]{entity.getID(), ex.getMessage()});
        }
    }

    private static void writeNotes(XMLStreamWriter writer, String notes, boolean showNotes) throws XMLStreamException {
        if (notes != null && !notes.isEmpty()) {
            writer.writeStartElement("mtg", "Notes", "http://maltego.paterva.com/xml/mtgx");
            if (showNotes) {
                writer.writeAttribute("show", Boolean.toString(showNotes));
            }
            writer.writeCData(notes);
            writer.writeEndElement();
        }
    }

    private static void writeBookmarks(XMLStreamWriter writer, int bookmark) throws XMLStreamException {
        if (bookmark >= 0) {
            writer.writeStartElement("mtg", "Bookmarks", "http://maltego.paterva.com/xml/mtgx");
            writer.writeCharacters(Integer.toString(bookmark));
            writer.writeEndElement();
        }
    }

    private static void writeContainedEntities(XMLStreamWriter writer, MaltegoEntity entity, List<MaltegoEntity> entities, GraphID graphID) throws XMLStreamException {
        if (!entities.isEmpty()) {
            writer.writeStartElement("mtg", "MaltegoEntityList", "http://maltego.paterva.com/xml/mtgx");
            for (MaltegoEntity e2 : entities) {
                MaltegoEntityIOStax.write(writer, e2, graphID);
            }
            writer.writeEndElement();
        }
    }

    private static AttachmentEntities translateAttachments(MaltegoEntity entity) {
        PropertyDescriptor imgProperty = entity.getNonBlankImageExpression().map(imgExpr -> entity.getProperties().get(imgExpr)).orElse(null);
        Attachment imgAtt = null;
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        for (PropertyDescriptor attPd : entity.getProperties()) {
            Attachments atts;
            if (!Attachments.class.equals((Object)attPd.getType()) || (atts = (Attachments)entity.getValue(attPd)) == null) continue;
            for (Attachment att : atts) {
                attachments.add(att);
            }
            if (imgProperty == null || !imgProperty.equals(attPd)) continue;
            imgAtt = atts.getPrimaryImage();
        }
        AttachmentEntities attEntities = new AttachmentEntities();
        attEntities.entities = new ArrayList<MaltegoEntity>();
        int entityNum = 0;
        for (Attachment att : attachments) {
            GenericEntity attEntity = new GenericEntity(EntityID.create(), "maltego.File");
            PropertyDescriptor sourcePd = new PropertyDescriptor(FastURL.class, "source", "Source");
            attEntity.setValue(sourcePd, (Object)att.getSource());
            PropertyDescriptor filePd = new PropertyDescriptor(InternalFile.class, "file", "File");
            attEntity.setValue(filePd, (Object)new InternalFile(att.getId()));
            attEntity.setImageExpression(filePd.getName());
            attEntities.entities.add((MaltegoEntity)attEntity);
            if (att.equals((Object)imgAtt)) {
                attEntities.imgIndex = entityNum;
            }
            ++entityNum;
        }
        return attEntities;
    }

    static void writeOverlays(XMLStreamWriter writer, MaltegoEntity entity) throws XMLStreamException {
        OverlayDescriptorSet overlays = entity.getOverlaySet();
        if (overlays == null || overlays.isEmpty()) {
            return;
        }
        writer.writeStartElement("mtg", "Overlays", "http://maltego.paterva.com/xml/mtgx");
        for (OverlayDescriptor overlay : overlays) {
            writer.writeStartElement("mtg", "Overlay", "http://maltego.paterva.com/xml/mtgx");
            writer.writeAttribute("propertyName", overlay.getPropertyName());
            writer.writeAttribute("position", overlay.getPosition().code);
            writer.writeAttribute("type", overlay.getType().type);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private static class AttachmentEntities {
        public List<MaltegoEntity> entities;
        public Integer imgIndex;

        private AttachmentEntities() {
        }
    }
}

