/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.propertygrid.editors;

import com.paterva.maltego.typing.editing.controls.SimpleColorButton;
import com.paterva.maltego.typing.editing.propertygrid.editors.InplacePropertyEditor;
import com.paterva.maltego.typing.editing.propertygrid.editors.InplacePropertyEditorSupport;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import org.openide.explorer.propertysheet.InplaceEditor;

class ColorPropertyEditor
extends InplacePropertyEditorSupport {
    public ColorPropertyEditor() {
        super(Color.class, null);
    }

    @Override
    public boolean isPaintable() {
        return this.getValue() != null;
    }

    @Override
    public String getAsText() {
        return "<Default>";
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
        int margin = 3;
        Color color = (Color)this.getValue();
        if (color != null) {
            gfx.setColor(color);
            gfx.fillRect(3, 3, box.width - 6, box.height - 6);
        }
    }

    @Override
    public InplaceEditor createEditor() {
        return new ColorInplaceEditor();
    }

    private static class ColorInplaceEditor
    extends InplacePropertyEditor<SimpleColorButton> {
        public ColorInplaceEditor() {
            super(new SimpleColorButton());
        }

        public Object getValue() {
            return ((SimpleColorButton)this.getEditorControl()).getSelectedColor();
        }

        public void setValue(Object object) {
            ((SimpleColorButton)this.getEditorControl()).setSelectedColor((Color)object);
        }

        @Override
        public void reset(Object value) {
            this.setValue(value);
        }
    }
}

