/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.controls;

import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.editing.UnsupportedEditorException;
import com.paterva.maltego.typing.editing.form.ControlAdapter;
import com.paterva.maltego.typing.editing.form.adapters.DefaultAdapterFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class ObjectEditor
extends JComponent {
    private DisplayDescriptor _descriptor;
    private ControlAdapter _adapter;
    private Component _component;
    private EventListenerList _listeners;
    private ActionListener _actionListener;
    private ChangeListener _changeListener;

    public ObjectEditor() {
        this(String.class);
    }

    public ObjectEditor(Class type) {
        this(new DisplayDescriptor(type, "value"));
    }

    public ObjectEditor(DisplayDescriptor dd) {
        this.setLayout(new BorderLayout());
        this._actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectEditor.this.fireActionPerformed(e);
            }
        };
        this._changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ObjectEditor.this.fireChange(e);
            }
        };
        try {
            this.setDescriptor(dd);
        }
        catch (UnsupportedEditorException ex) {
            try {
                this.setDescriptor(new DisplayDescriptor(String.class, "value"));
            }
            catch (UnsupportedEditorException unsupportedEditorException) {
                // empty catch block
            }
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listeners().add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners().remove(ActionListener.class, listener);
    }

    protected void fireActionPerformed(ActionEvent event) {
        if (this._listeners != null) {
            ActionListener[] listeners;
            for (ActionListener l : listeners = (ActionListener[])this._listeners.getListeners(ActionListener.class)) {
                l.actionPerformed(event);
            }
        }
    }

    protected void fireChange(ChangeEvent event) {
        if (this._listeners != null) {
            ChangeListener[] listeners;
            for (ChangeListener l : listeners = (ChangeListener[])this._listeners.getListeners(ChangeListener.class)) {
                l.stateChanged(event);
            }
        }
    }

    private EventListenerList listeners() {
        if (this._listeners == null) {
            this._listeners = new EventListenerList();
        }
        return this._listeners;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners().add(ChangeListener.class, listener);
    }

    public void removeChangeistener(ChangeListener listener) {
        this.listeners().remove(ChangeListener.class, listener);
    }

    public Object getValue() {
        return this.getAdapter().getValue(this._component);
    }

    public void setValue(Object value) {
        this.getAdapter().setValue(this._component, value);
    }

    public Class getDataType() {
        return this._descriptor.getType();
    }

    public void setDataType(Class dataType) throws UnsupportedEditorException {
        this.setDescriptor(new DisplayDescriptor(dataType, "value"));
    }

    public DisplayDescriptor getDescriptor() {
        return this._descriptor;
    }

    public void setDescriptor(DisplayDescriptor descriptor) throws UnsupportedEditorException {
        this._descriptor = descriptor;
        this.setAdapter(DefaultAdapterFactory.instance().create(descriptor));
        this._component = this.getAdapter().createComponent();
        this.removeAll();
        this._component.setEnabled(this.isEnabled());
        this.add(this._component);
        this.revalidate();
        this.repaint();
    }

    private void setAdapter(ControlAdapter adapter) {
        if (this._adapter != adapter) {
            if (this._adapter != null) {
                this._adapter.removeActionListener(this._actionListener);
                this._adapter.removeChangeListener(this._changeListener);
            }
            this._adapter = adapter;
            this._adapter.addActionListener(this._actionListener);
            this._adapter.addChangeListener(this._changeListener);
        }
    }

    private ControlAdapter getAdapter() {
        return this._adapter;
    }

    public boolean isEmpty() {
        return this.getAdapter().isEmpty(this._component);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this._component != null) {
            this._component.setEnabled(enabled);
        }
    }
}

