/*
 * Decompiled with CFR 0.152.
 */
package com.pinkmatter.pandora.lucene.serialize;

import com.pinkmatter.pandora.PandoraException;
import com.pinkmatter.pandora.PandoraFilter;
import com.pinkmatter.pandora.lucene.serialize.AbstractTypeConverter;
import com.pinkmatter.pandora.lucene.serialize.SortHelper;
import com.pinkmatter.types.Blob;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;

class BlobConverter
extends AbstractTypeConverter<Blob> {
    private static final String PLACEHOLDER = "hasblob";

    public BlobConverter() {
        super("blob", Blob.class);
    }

    @Override
    protected void writeImpl(Blob value, String field, Document to) throws PandoraException {
        String fieldName = this.getIndexField(field);
        StoredField storeField = new StoredField(fieldName, value.get());
        to.add((IndexableField)storeField);
        StringField indexField = new StringField(fieldName, PLACEHOLDER, Field.Store.NO);
        to.add((IndexableField)indexField);
        to.add(SortHelper.createStringDocValueField(fieldName, PLACEHOLDER));
    }

    @Override
    protected Blob readImpl(IndexableField field) throws PandoraException {
        return new Blob(field.binaryValue().bytes);
    }

    @Override
    protected Query createFilterImpl(PandoraFilter.Simple parameters) {
        throw new UnsupportedOperationException("A blob field does not support filtering.");
    }

    @Override
    protected SortField[] getSortFieldsImpl(String property, boolean reverse, boolean emptyFirst) {
        throw new UnsupportedOperationException("A blob field does not support sorting.");
    }
}

