/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.types;

import java.util.Objects;

public class Overlay {
    private String propertyName;
    private Position position;
    private Type type;

    public Overlay(String propertyName, String position, String type) {
        this.setPosition(Position.valueOfCode(position));
        this.setPropertyName(propertyName);
        this.setType(Type.valueOfType(type));
    }

    public int hashCode() {
        int hash = 3;
        hash = 79 * hash + Objects.hashCode(this.propertyName);
        hash = 79 * hash + Objects.hashCode((Object)this.position);
        hash = 79 * hash + Objects.hashCode((Object)this.type);
        return hash;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Overlay)) {
            return false;
        }
        Overlay other = (Overlay)object;
        return Objects.equals(this.propertyName, other.propertyName) && Objects.equals((Object)this.position, (Object)other.position) && Objects.equals((Object)this.type, (Object)other.type);
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public static enum Type {
        TEXT("text"),
        IMAGE("image"),
        COLOUR("colour");

        public final String type;

        private Type(String type) {
            this.type = type;
        }

        public static Type valueOfType(String value) {
            if ("color".equalsIgnoreCase(value)) {
                return COLOUR;
            }
            for (Type type : Type.values()) {
                if (!type.type.equalsIgnoreCase(value)) continue;
                return type;
            }
            return null;
        }
    }

    public static enum Position {
        NORTH_WEST("NW", 0, 0),
        NORTH("N", 0, 1),
        NORTH_EAST("NE", 0, 2),
        WEST("W", 1, 0),
        CENTER("C", 1, 1),
        EAST("E", 1, 2),
        SOUTH_WEST("SW", 2, 0),
        SOUTH("S", 2, 1),
        SOUTH_EAST("SE", 2, 2);

        public final String code;
        public final int row;
        public final int column;

        private Position(String code, int row, int column) {
            this.code = code;
            this.row = row;
            this.column = column;
        }

        public static Position valueOfCode(String code) {
            for (Position position : Position.values()) {
                if (!position.code.equalsIgnoreCase(code)) continue;
                return position;
            }
            return null;
        }
    }
}

