/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.serializer;

import com.paterva.maltego.typing.Group;
import com.paterva.maltego.typing.GroupDefinitions;
import com.paterva.maltego.typing.SuperGroup;
import com.paterva.maltego.typing.serializer.FieldGroupStub;
import com.paterva.maltego.typing.serializer.FieldGroupsStub;
import com.paterva.maltego.typing.serializer.MainGroupStub;
import com.paterva.maltego.typing.serializer.SubGroupStub;
import java.util.List;

class GroupsTranslator {
    GroupsTranslator() {
    }

    public GroupDefinitions translate(FieldGroupsStub groups) {
        List<SubGroupStub> subGroups;
        if (groups == null) {
            return null;
        }
        GroupDefinitions groupings = new GroupDefinitions();
        List<MainGroupStub> mainGroups = groups.getMainGroups();
        if (mainGroups != null) {
            for (MainGroupStub main : mainGroups) {
                groupings.getTopLevelSuperGroups().add(this.translate(main));
            }
        }
        if ((subGroups = groups.getSubGroups()) != null) {
            for (SubGroupStub sub : subGroups) {
                groupings.getTopLevelGroups().add(this.translate(sub));
            }
        }
        return groupings;
    }

    private Group translate(SubGroupStub stub) {
        Group group = new Group(stub.getName(), stub.getDisplayName(), stub.getDescription());
        return group;
    }

    private SuperGroup translate(MainGroupStub stub) {
        SuperGroup group = new SuperGroup(stub.getName(), stub.getDisplayName(), stub.getDescription());
        for (SubGroupStub sub : stub.getSubGroups()) {
            group.getSubGroups().add(this.translate(sub));
        }
        return group;
    }

    public FieldGroupsStub translate(GroupDefinitions groups) {
        if (groups == null) {
            return null;
        }
        FieldGroupsStub stub = new FieldGroupsStub();
        if (groups.getTopLevelGroups() != null) {
            for (Group group : groups.getTopLevelGroups()) {
                stub.getSubGroups().add(this.translate(group));
            }
        }
        if (groups.getTopLevelSuperGroups() != null) {
            for (Group group : groups.getTopLevelSuperGroups()) {
                stub.getMainGroups().add(this.translate((SuperGroup)group));
            }
        }
        return stub;
    }

    private SubGroupStub translate(Group group) {
        SubGroupStub stub = new SubGroupStub();
        this.update(stub, group);
        return stub;
    }

    private void update(FieldGroupStub stub, Group group) {
        stub.setName(group.getName());
        if (!group.getName().equals(group.getDisplayName())) {
            stub.setDisplayName(group.getDisplayName());
        }
        if (!group.getDisplayName().equals(group.getDescription())) {
            stub.setDescription(group.getDescription());
        }
    }

    private MainGroupStub translate(SuperGroup group) {
        MainGroupStub stub = new MainGroupStub();
        this.update(stub, group);
        if (group.getSubGroups() != null) {
            for (Group g : group.getSubGroups()) {
                stub.getSubGroups().add(this.translate(g));
            }
        }
        return stub;
    }
}

