/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.welcome.update;

import com.paterva.maltego.util.StringUtilities;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class UpdateOptionProcessor
extends OptionProcessor {
    public static final String PROP_UPDATES_URL = "maltego.updates.url";
    private static final Option UPDATES_URL = Option.requiredArgument((char)'u', (String)"updates");
    private static final String ORIGINAL_URL = "originalUrl";
    private static final String URL = "url";

    public static void restoreUrl() {
        String url;
        String originalUrl;
        Preferences ucPrefs = UpdateOptionProcessor.getUpdateCenterPreferences();
        if (ucPrefs != null && !StringUtilities.isNullOrEmpty((String)(originalUrl = ucPrefs.get(ORIGINAL_URL, ""))) && !originalUrl.equals(url = ucPrefs.get(URL, ""))) {
            ucPrefs.put(URL, originalUrl);
            Logger logger = UpdateOptionProcessor.getLogger();
            logger.log(Level.INFO, "Update Center URL restored...");
            logger.log(Level.INFO, "   before={0}", url);
            logger.log(Level.INFO, "   after={0}", originalUrl);
        }
    }

    protected Set<Option> getOptions() {
        return Collections.singleton(UPDATES_URL);
    }

    protected void process(Env env, Map<Option, String[]> optionValues) throws CommandException {
        String urlStr;
        if (optionValues.containsKey(UPDATES_URL) && !StringUtilities.isNullOrEmpty((String)(urlStr = optionValues.get(UPDATES_URL)[0]))) {
            Preferences ucPrefs = UpdateOptionProcessor.getUpdateCenterPreferences();
            if (ucPrefs != null) {
                ucPrefs.put(URL, urlStr);
                UpdateOptionProcessor.getLogger().log(Level.INFO, "Update Center URL={0}", urlStr);
            } else {
                UpdateOptionProcessor.getLogger().warning("Update Center URL cannot be set on first run of Maltego. Please try again.");
            }
        }
    }

    private static Preferences getUpdateCenterPreferences() {
        Preferences autoUpdateNode = NbPreferences.root().node("/org/netbeans/modules/autoupdate");
        if (autoUpdateNode != null) {
            try {
                for (String name : autoUpdateNode.childrenNames()) {
                    if (!name.contains("maltego")) continue;
                    return autoUpdateNode.node(name);
                }
            }
            catch (BackingStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    private static Logger getLogger() {
        return Logger.getLogger(UpdateOptionProcessor.class.getName());
    }
}

