/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.find.files.actions;

import com.paterva.maltego.archive.mtz.GraphFileType;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.find.files.FindInFilesResult;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.mtgx.imex.MtgxSerializer;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.merge.InteractiveGraphMerger;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.util.SimilarStrings;
import com.paterva.maltego.util.ui.PasswordUtil;
import com.paterva.maltego.util.ui.WindowUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import org.openide.windows.TopComponent;

public class MergeWithActiveGraphAction
extends NodeAction {
    public String getName() {
        return "Merge with Open Graph";
    }

    protected boolean enable(Node[] nodes) {
        TopComponent topmost = GraphEditorRegistry.getDefault().getTopmost();
        if (this.getTopGraphID(topmost) == null) {
            return false;
        }
        for (Node node : nodes) {
            if (node.getLookup().lookup(FindInFilesResult.class) == null) continue;
            return true;
        }
        return false;
    }

    protected void performAction(Node[] nodes) {
        TopComponent topmost = GraphEditorRegistry.getDefault().getTopmost();
        GraphID topGraphID = this.getTopGraphID(topmost);
        if (topGraphID == null) {
            return;
        }
        DataObject dataObject = (DataObject)topmost.getLookup().lookup(DataObject.class);
        String msg = "Are you sure you want to merge the selected graph(s) with graph \"" + dataObject.getName() + "\"";
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg);
        nd.setMessageType(3);
        nd.setTitle("Merge with Open Graph");
        if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
            for (Node node : nodes) {
                GraphID graphID;
                FindInFilesResult result = (FindInFilesResult)node.getLookup().lookup(FindInFilesResult.class);
                if (result == null || (graphID = this.loadGraph(result)) == null) continue;
                Set entityIDs = GraphStoreHelper.getEntityIDs((GraphID)graphID);
                String entityDescription = GraphTransactionHelper.getDescriptionForEntityIDs((GraphID)graphID, (Collection)entityIDs, (boolean)true);
                String description = "%s " + entityDescription;
                SimilarStrings descriptions = new SimilarStrings(description, "Merge from find", "Delete/unmerge");
                InteractiveGraphMerger merger = new InteractiveGraphMerger(topGraphID, graphID, descriptions);
                merger.promptMergeGraphs();
                merger.mergeGraphs();
                merger.selectSourceNodes();
            }
        }
    }

    private GraphID getTopGraphID(TopComponent topmost) {
        GraphCookie cookie;
        if (topmost != null && (cookie = (GraphCookie)topmost.getLookup().lookup(GraphCookie.class)) != null) {
            return cookie.getGraphID();
        }
        return null;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GraphID loadGraph(FindInFilesResult result) {
        block10: {
            try {
                WindowUtil.showWaitCursor();
                File file = new File(result.getFolderPath(), result.getGraphName());
                if (!file.isFile()) {
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)("The file was not found:\n" + file.getAbsolutePath()), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                    break block10;
                }
                boolean canOpen = true;
                String password = "";
                try {
                    ZipFile zipFile = new ZipFile(file);
                    if (zipFile.isEncrypted()) {
                        password = PasswordUtil.promptForPassword((ZipFile)zipFile);
                        canOpen = password != null;
                    }
                }
                catch (ZipException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (canOpen) {
                    MtgxSerializer serializer = new MtgxSerializer();
                    GraphID graphID = GraphID.create();
                    serializer.loadGraph(graphID, file, password, GraphFileType.forFile((File)file));
                    GraphID graphID2 = graphID;
                    return graphID2;
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                WindowUtil.hideWaitCursor();
            }
        }
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }
}

