/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.tx.inputs.global;

import com.paterva.maltego.tx.inputs.global.GlobalTransformInputDescriptor;
import com.paterva.maltego.tx.inputs.global.GlobalTransformInputGroup;
import com.paterva.maltego.typing.DisplayDescriptor;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class GlobalTransformInputs {
    private final List<GlobalTransformInputGroup> _groups;

    public GlobalTransformInputs(List<GlobalTransformInputGroup> groups) {
        this._groups = Collections.unmodifiableList(groups);
    }

    public List<GlobalTransformInputGroup> getGroups() {
        return this._groups;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this._groups);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalTransformInputs other = (GlobalTransformInputs)obj;
        return Objects.equals(this._groups, other._groups);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        for (GlobalTransformInputGroup group : this._groups) {
            sb.append("=====\nName: ");
            sb.append(group.getDisplayName());
            sb.append("\nInputs: ");
            for (GlobalTransformInputDescriptor input : group.getInputs()) {
                DisplayDescriptor dd = input.getInput();
                sb.append(dd.getDisplayName());
                sb.append(" (").append(dd.getTypeDescriptor().getTypeName()).append(")").append(", ");
            }
            sb.append("\n");
        }
        return sb.toString().replace(", \n", "\n");
    }
}

