/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactory.icons;

import com.paterva.maltego.imgfactory.icons.IconLayerRegistry;
import com.paterva.maltego.imgfactory.icons.LayerIconSerializer;
import com.paterva.maltego.imgfactory.icons.LayerIconStub;
import com.paterva.maltego.imgfactoryapi.IconCatalog;
import com.paterva.maltego.imgfactoryapi.IconUtils;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.imgfactoryapi.WrappedRegistryIcon;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class DefaultIconLayerRegistry
extends IconLayerRegistry {
    private static final Logger LOG = Logger.getLogger(DefaultIconLayerRegistry.class.getName());
    private Map<String, Map<String, String>> _icons;
    private IconCatalog _catalog;
    private final PropertyChangeSupport _support = new PropertyChangeSupport((Object)this);
    private final FileObject _configRoot;
    private final boolean _readonly;

    public DefaultIconLayerRegistry() {
        this(FileUtil.getConfigRoot(), false);
    }

    public DefaultIconLayerRegistry(FileObject configRoot, boolean readonly) {
        Args.notNull((Object)configRoot, (String)"configRoot");
        this._configRoot = configRoot;
        this._readonly = readonly;
        this.init();
    }

    public List<RegistryIcon> getIcons() {
        return this._catalog.getIcons();
    }

    public List<RegistryIcon> getIcons(String category) {
        Args.notNullOrBlank((String)category, (String)"category");
        return this._catalog.getIcons(category);
    }

    public boolean contains(RegistryIcon icon) {
        Args.notNull((Object)icon, (String)"icon");
        return this._catalog.contains(icon);
    }

    public Set<String> getCategories() {
        return this._catalog.getCategories();
    }

    public Set<String> getIconNames(String category) {
        Args.notNullOrBlank((String)category, (String)"category");
        return this._catalog.getIconNames(category);
    }

    private Map<String, String> getCategoryIconsMap(String iconCategory) {
        Args.notNullOrBlank((String)iconCategory, (String)"iconCategory");
        Map<String, String> categoryIcons = this._icons.get(iconCategory);
        if (categoryIcons == null && !StringUtilities.isNullOrEmpty((String)iconCategory)) {
            categoryIcons = new HashMap<String, String>();
            this._icons.put(iconCategory, categoryIcons);
        }
        return categoryIcons;
    }

    private synchronized void init() {
        this._icons = new HashMap<String, Map<String, String>>();
        this._catalog = new IconCatalog();
        FileObject iconsFileObject = this._configRoot.getFileObject("Maltego/Icons");
        if (iconsFileObject != null) {
            for (FileObject categoryFileObject : iconsFileObject.getChildren()) {
                if (!categoryFileObject.isFolder()) continue;
                String category = categoryFileObject.getNameExt();
                Map<String, String> categoryIconsMap = this.getCategoryIconsMap(category);
                for (FileObject iconFileObject : categoryFileObject.getChildren()) {
                    try {
                        String name = iconFileObject.getNameExt();
                        String[] splitName = DefaultIconLayerRegistry.splitName(name);
                        if (splitName == null) continue;
                        String iconName = splitName[0];
                        String size = splitName[1];
                        String extension = splitName[2];
                        if (!extension.toLowerCase().equals("xml")) {
                            categoryIconsMap.put(iconName + size, iconFileObject.getPath());
                            if (!size.isEmpty()) continue;
                            this._catalog.addOrReplaceIcon(category, iconName);
                            continue;
                        }
                        LayerIconSerializer serializer = new LayerIconSerializer();
                        LayerIconStub stub = serializer.read(iconFileObject);
                        this._catalog.addOrReplaceIcon(category, iconName, stub.getAliases(), stub.getHubItems());
                    }
                    catch (Exception ex) {
                        NormalException.logStackTrace((Throwable)ex);
                    }
                }
            }
            if (!this._readonly) {
                this.createMissingIcons();
            }
        }
    }

    @Override
    public synchronized FileObject getFileObject(RegistryIcon registryIcon, IconSize size) {
        Args.notNull((Object)registryIcon, (String)"registryIcon");
        Args.notNull((Object)size, (String)"size");
        String layerPath = this.getLayerPath(registryIcon, size);
        if (layerPath != null) {
            return this._configRoot.getFileObject(layerPath);
        }
        return null;
    }

    private String getLayerPath(RegistryIcon registryIcon, IconSize size) {
        String category = registryIcon.getCategory();
        String iconName = registryIcon.getName();
        String name = iconName + size.getPostfix();
        Map<String, String> categoryIconsMap = this.getCategoryIconsMap(category);
        return categoryIconsMap.get(name);
    }

    public synchronized Optional<Image> loadImage(RegistryIcon registryIcon, IconSize size) {
        Args.notNull((Object)registryIcon, (String)"registryIcon");
        Args.notNull((Object)size, (String)"size");
        FileObject fileObject = this.getFileObject(registryIcon, size);
        return this.loadImage(fileObject, size.getSize()).map(img -> img);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<BufferedImage> loadImage(FileObject fileObject, int size) {
        if (fileObject == null) return Optional.empty();
        try (InputStream is = fileObject.getInputStream();){
            if (is == null) return Optional.empty();
            BufferedImage img = ImageIO.read(is);
            if (img != null && ImageUtils.isSVGFile((FileObject)fileObject)) {
                img = ImageUtils.smartSize((BufferedImage)img, (double)size);
            }
            Optional<BufferedImage> optional = Optional.of(img);
            return optional;
        }
        catch (IOException ex) {
            NormalException.logStackTrace((Throwable)ex);
        }
        return Optional.empty();
    }

    public RegistryIcon addFromImages(String category, String iconName, Map<IconSize, Image> iconImages) throws IOException {
        Args.notNullOrBlank((String)category, (String)"category");
        Args.notNullOrBlank((String)iconName, (String)"iconName");
        Args.notNull(iconImages, (String)"iconImages");
        for (Map.Entry<IconSize, Image> entry : iconImages.entrySet()) {
            IconSize size = entry.getKey();
            Image image = entry.getValue();
            this.add(category, iconName + size.getPostfix(), image);
        }
        RegistryIcon icon = this._catalog.addOrReplaceIcon(category, iconName);
        if (!this._readonly) {
            this.createMissingIcons(icon);
        }
        this._support.firePropertyChange("addedIcon", null, icon);
        return icon;
    }

    private synchronized void add(String category, String nameAndSize, Image image) throws IOException {
        Args.notNullOrBlank((String)category, (String)"category");
        Args.notNullOrBlank((String)nameAndSize, (String)"nameAndSize");
        if (image == null) {
            return;
        }
        String categoryPath = "Maltego/Icons/" + category;
        FileObject categoryFO = this._configRoot.getFileObject(categoryPath);
        if (categoryFO == null) {
            categoryFO = FileUtil.createFolder((FileObject)this._configRoot, (String)categoryPath);
        }
        String ext = "png";
        FileObject iconFO = FileUtil.createData((FileObject)categoryFO, (String)(nameAndSize + "." + ext));
        int retries = 10;
        while (retries != 0) {
            try {
                ImageUtils.write((Image)image, (String)ext, (FileObject)iconFO);
                retries = 0;
            }
            catch (IOException ex) {
                if (retries == 0) {
                    throw ex;
                }
                --retries;
                System.out.println("Could not write file, retrying: " + iconFO.getPath());
                this.sleep();
            }
        }
        Map<String, String> categoryIconsMap = this.getCategoryIconsMap(category);
        categoryIconsMap.put(nameAndSize, iconFO.getPath());
    }

    public RegistryIcon addFromFiles(String category, String iconName, Map<IconSize, FileObject> iconFiles) throws IOException {
        Args.notNullOrBlank((String)category, (String)"category");
        Args.notNullOrBlank((String)iconName, (String)"iconName");
        Args.notNull(iconFiles, (String)"iconFiles");
        for (Map.Entry<IconSize, FileObject> entry : iconFiles.entrySet()) {
            IconSize size = entry.getKey();
            FileObject imageFile = entry.getValue();
            this.add(category, iconName + size.getPostfix(), imageFile);
        }
        RegistryIcon icon = this._catalog.addOrReplaceIcon(category, iconName);
        if (!this._readonly) {
            this.createMissingIcons(icon);
        }
        this._support.firePropertyChange("addedIcon", null, icon);
        return icon;
    }

    private synchronized void add(String category, String nameAndSize, FileObject sourceFO) throws IOException {
        Args.notNullOrBlank((String)category, (String)"category");
        Args.notNullOrBlank((String)nameAndSize, (String)"nameAndSize");
        if (sourceFO == null) {
            return;
        }
        Map<String, String> categoryIconsMap = this.getCategoryIconsMap(category);
        String categoryPath = "Maltego/Icons/" + category;
        FileObject categoryFO = this._configRoot.getFileObject(categoryPath);
        if (categoryFO == null) {
            categoryFO = FileUtil.createFolder((FileObject)this._configRoot, (String)categoryPath);
        }
        FileObject iconFO = FileUtil.copyFile((FileObject)sourceFO, (FileObject)categoryFO, (String)nameAndSize);
        categoryIconsMap.put(nameAndSize, iconFO.getPath());
    }

    public synchronized void removeIcon(RegistryIcon icon) throws IOException {
        Args.notNull((Object)icon, (String)"icon");
        String iconCategory = icon.getCategory();
        String iconName = icon.getName();
        Map<String, String> categoryIconsMap = this.getCategoryIconsMap(iconCategory);
        if (categoryIconsMap != null) {
            FileObject fileObject;
            String[] names;
            for (String name : names = this.getSizeNames(iconName)) {
                FileObject iconFileObject;
                String layerPath = categoryIconsMap.get(name);
                if (layerPath != null && (iconFileObject = this._configRoot.getFileObject(layerPath)) != null) {
                    iconFileObject.delete();
                }
                categoryIconsMap.remove(name);
            }
            String categoryPath = "Maltego/Icons/" + iconCategory;
            FileObject categoryFO = this._configRoot.getFileObject(categoryPath);
            if (categoryFO != null && (fileObject = categoryFO.getFileObject(iconName, "xml")) != null) {
                fileObject.delete();
            }
            this._catalog.removeIcon(icon);
            this._support.firePropertyChange("removedIcon", icon, null);
        }
    }

    public synchronized void removeCategory(String category) throws IOException {
        Set<String> iconNames;
        Args.notNullOrBlank((String)category, (String)"category");
        Map<String, String> categoryIconsMap = this.getCategoryIconsMap(category);
        String categoryPath = "Maltego/Icons/" + category;
        FileObject categoryFO = this._configRoot.getFileObject(categoryPath);
        if (categoryFO != null) {
            categoryFO.delete();
        }
        if ((iconNames = this.getIconNames(category)) != null) {
            for (String iconName : iconNames) {
                for (IconSize iconSize : IconSize.values()) {
                    categoryIconsMap.remove(iconName + iconSize.getPostfix());
                }
            }
        }
        this._catalog.removeCategory(category);
        this._support.firePropertyChange("removedCategory", category, null);
    }

    public synchronized RegistryIcon rename(RegistryIcon icon, String newName) throws IOException {
        Args.notNull((Object)icon, (String)"icon");
        Args.notNullOrBlank((String)newName, (String)"newName");
        String category = icon.getCategory();
        String oldName = icon.getName();
        Map<String, String> categoryIconsMap = this.getCategoryIconsMap(category);
        for (IconSize size : IconSize.values()) {
            FileObject oldFO = this.getFileObject(icon, size);
            String newNameAndSize = newName + size.getPostfix();
            FileObject newFO = FileUtil.moveFile((FileObject)oldFO, (FileObject)oldFO.getParent(), (String)newNameAndSize);
            categoryIconsMap.remove(oldName + size.getPostfix());
            categoryIconsMap.put(newNameAndSize, newFO.getPath());
        }
        Optional<FileObject> oldMetadataFileOpt = this.getMetadataFileObject(icon, false);
        RegistryIcon newIcon = this._catalog.rename(icon, newName);
        if (oldMetadataFileOpt.isPresent()) {
            FileObject oldMetadataFile = oldMetadataFileOpt.get();
            FileUtil.moveFile((FileObject)oldMetadataFile, (FileObject)oldMetadataFile.getParent(), (String)newIcon.getName());
        }
        this._support.firePropertyChange("renamedIcon", icon, newIcon);
        return newIcon;
    }

    public synchronized void replace(RegistryIcon icon, IconSize size, BufferedImage image) throws IOException {
        Args.notNull((Object)icon, (String)"icon");
        Args.notNull((Object)size, (String)"size");
        Args.notNull((Object)image, (String)"image");
        if (image.getWidth() != size.getSize() || image.getHeight() != size.getSize()) {
            image = ImageUtils.smartSize((BufferedImage)image, (double)size.getSize());
        }
        FileObject fileObject = this.getFileObject(icon, size);
        ImageUtils.write((Image)image, (String)"png", (FileObject)fileObject);
        this._support.firePropertyChange("replacedIconSize", null, new WrappedRegistryIcon(icon, image));
    }

    public void setAliases(RegistryIcon icon, Set<String> aliases) throws IOException {
        Args.notNull((Object)icon, (String)"icon");
        Args.notNull(aliases, (String)"aliases");
        RegistryIcon newIcon = this.storeIcon(icon, aliases, icon.getHubItems());
        this._support.firePropertyChange("aliasesChanged", new WrappedRegistryIcon(icon), new WrappedRegistryIcon(newIcon));
    }

    public void addAlias(RegistryIcon icon, String alias) throws IOException {
        Args.notNull((Object)icon, (String)"icon");
        Args.notNullOrBlank((String)alias, (String)"alias");
        LinkedHashSet<String> aliases = new LinkedHashSet<String>(icon.getAliases());
        aliases.add(alias);
        RegistryIcon newIcon = this.storeIcon(icon, aliases, icon.getHubItems());
        this._support.firePropertyChange("aliasAdded", new WrappedRegistryIcon(icon), new WrappedRegistryIcon(newIcon));
    }

    public void removeAlias(RegistryIcon icon, String alias) throws IOException {
        Args.notNull((Object)icon, (String)"icon");
        Args.notNullOrBlank((String)alias, (String)"alias");
        LinkedHashSet<String> aliases = new LinkedHashSet<String>(icon.getAliases());
        aliases.remove(alias);
        RegistryIcon newIcon = this.storeIcon(icon, aliases, icon.getHubItems());
        this._support.firePropertyChange("aliasRemoved", new WrappedRegistryIcon(icon), new WrappedRegistryIcon(newIcon));
    }

    public void setHubItems(RegistryIcon icon, Set<String> hubitems) throws IOException {
        Args.notNull((Object)icon, (String)"icon");
        Args.notNull(hubitems, (String)"hubitems");
        this.storeIcon(icon, icon.getAliases(), hubitems);
        this._support.firePropertyChange("hubItemsChanged", icon.getHubItems(), hubitems);
    }

    public void addHubItem(RegistryIcon icon, String hubitem) throws IOException {
        Args.notNull((Object)icon, (String)"icon");
        Args.notNullOrBlank((String)hubitem, (String)"hubitem");
        LinkedHashSet<String> hubitems = new LinkedHashSet<String>(icon.getHubItems());
        hubitems.add(hubitem);
        this.storeIcon(icon, hubitems, icon.getHubItems());
        this._support.firePropertyChange("hubItemAdded", null, hubitem);
    }

    public void removeHubItem(RegistryIcon icon, String hubitem) throws IOException {
        Args.notNull((Object)icon, (String)"icon");
        Args.notNullOrBlank((String)hubitem, (String)"hubitem");
        LinkedHashSet<String> hubitems = new LinkedHashSet<String>(icon.getHubItems());
        hubitems.remove(hubitem);
        this.storeIcon(icon, hubitems, icon.getHubItems());
        this._support.firePropertyChange("hubItemRemoved", hubitem, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._support.removePropertyChangeListener(listener);
    }

    private void sleep() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private RegistryIcon storeIcon(RegistryIcon icon, Set<String> aliases, Set<String> hubItems) throws IOException {
        Args.notNull((Object)icon, (String)"icon");
        Args.notNull(aliases, (String)"aliases");
        Args.notNull(hubItems, (String)"hubItems");
        FileObject fileObject = this.getMetadataFileObject(icon, true).get();
        LayerIconStub stub = new LayerIconStub();
        stub.setAliases(aliases);
        stub.setHubItems(hubItems);
        LayerIconSerializer serializer = new LayerIconSerializer();
        serializer.write(stub, fileObject);
        return this._catalog.addOrReplaceIcon(icon.getCategory(), icon.getName(), aliases, hubItems);
    }

    private Optional<FileObject> getMetadataFileObject(RegistryIcon icon, boolean createIfMissing) throws IOException {
        Args.notNull((Object)icon, (String)"icon");
        String category = icon.getCategory();
        String iconName = icon.getName();
        String categoryPath = "Maltego/Icons/" + category;
        FileObject categoryFO = this._configRoot.getFileObject(categoryPath);
        if (createIfMissing && categoryFO == null) {
            categoryFO = FileUtil.createFolder((FileObject)this._configRoot, (String)categoryPath);
        }
        FileObject fileObject = null;
        if (categoryFO != null) {
            fileObject = categoryFO.getFileObject(iconName, "xml");
            if (createIfMissing && fileObject == null) {
                fileObject = categoryFO.createData(iconName, "xml");
            }
        }
        return Optional.ofNullable(fileObject);
    }

    private void createMissingIcons() {
        for (RegistryIcon icon : this._catalog.getIcons()) {
            this.createMissingIcons(icon);
        }
    }

    private void createMissingIcons(RegistryIcon icon) {
        EnumMap<IconSize, FileObject> availableSizes = this.getAvailableSizes(icon);
        for (IconSize size : IconSize.values()) {
            if (availableSizes.get(size) != null) continue;
            this.createMissingIconForSize(availableSizes, icon, size);
        }
    }

    private EnumMap<IconSize, FileObject> getAvailableSizes(RegistryIcon icon) {
        EnumMap<IconSize, FileObject> sizes = new EnumMap<IconSize, FileObject>(IconSize.class);
        for (IconSize size : IconSize.values()) {
            FileObject fo;
            String layerPath = this.getLayerPath(icon, size);
            if (layerPath == null || (fo = this._configRoot.getFileObject(layerPath)) == null) continue;
            sizes.put(size, fo);
        }
        return sizes;
    }

    private void createMissingIconForSize(EnumMap<IconSize, FileObject> availableSizes, RegistryIcon icon, IconSize size) {
        FileObject largestImgFileObject = IconSize.getBiggestForIconType((IconSize)size, availableSizes);
        if (largestImgFileObject != null) {
            try {
                Optional<BufferedImage> resizedImg = this.loadImage(largestImgFileObject, size.getSize()).map(otherImg -> IconUtils.mustResize((BufferedImage)otherImg, (IconSize)size) ? ImageUtils.smartSize((BufferedImage)otherImg, (double)size.getSize()) : otherImg);
                if (resizedImg.isPresent()) {
                    String category = icon.getCategory();
                    String iconName = icon.getName();
                    String nameAndSize = iconName + size.getPostfix();
                    this.add(category, nameAndSize, resizedImg.get());
                    LOG.log(Level.WARNING, "Created missing icon: {0}\\{1}", new Object[]{category, nameAndSize});
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

