/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.licensing.json.serialize;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.paterva.maltego.licensing.C;
import com.paterva.maltego.licensing.E;
import com.paterva.maltego.licensing.json.serialize.JsonLicenseOrganization;
import com.paterva.maltego.licensing.json.serialize.JsonLicenseProduct;
import com.paterva.maltego.licensing.json.serialize.JsonLicenseProductPlan;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JsonLicenseResponse {
    private final String activationId;
    private final String clientFingerprint;
    private final Long validFrom;
    private final Long validTo;
    private final JsonLicenseProduct product;
    private final JsonLicenseProductPlan productPlan;
    private final String username;
    private final String firstName;
    private final String lastName;
    private final String email;
    private final JsonLicenseOrganization organization;
    private final boolean inBeta;
    private final boolean allowCloudGraphs;
    private E capability;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public JsonLicenseResponse(@JsonProperty(value="activationId", required=true) String activationId, @JsonProperty(value="clientFingerprint", required=true) String clientFingerprint, @JsonProperty(value="validFrom", required=true) Long validFrom, @JsonProperty(value="validTo", required=true) Long validTo, @JsonProperty(value="product", required=true) JsonLicenseProduct product, @JsonProperty(value="productPlan", required=true) JsonLicenseProductPlan productPlan, @JsonProperty(value="username", required=false) String username, @JsonProperty(value="firstName", required=false) String firstName, @JsonProperty(value="lastName", required=false) String lastName, @JsonProperty(value="email", required=false) String email, @JsonProperty(value="organization", required=false) JsonLicenseOrganization organization, @JsonProperty(value="inBeta", required=false) boolean inBeta, @JsonProperty(value="allowCloudGraphs", required=false) boolean allowCloudGraphs) {
        this.activationId = activationId;
        this.clientFingerprint = clientFingerprint;
        this.validFrom = validFrom;
        this.validTo = validTo;
        this.product = product;
        this.productPlan = productPlan;
        this.username = username;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.organization = organization;
        this.inBeta = inBeta;
        this.allowCloudGraphs = allowCloudGraphs;
    }

    public String getActivationId() {
        return this.activationId;
    }

    public String getClientFingerprint() {
        return this.clientFingerprint;
    }

    public Long getValidFrom() {
        return this.validFrom * 1000L;
    }

    public Long getValidTo() {
        return this.validTo * 1000L;
    }

    public JsonLicenseProduct getProduct() {
        return this.product;
    }

    public JsonLicenseProductPlan getProductPlan() {
        return this.productPlan;
    }

    public String getUsername() {
        return this.username;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public JsonLicenseOrganization getOrganization() {
        return this.organization;
    }

    public boolean isInBeta() {
        return this.inBeta;
    }

    public boolean isAllowCloudGraphs() {
        return this.allowCloudGraphs;
    }

    public C getCapabilityValidity(long time) {
        if (this.capability == null) {
            this.capability = new E(900, this.getProduct().getDisplayName(), this.getValidFrom(), this.getValidTo(), 0L, this.getProductPlan().getDisplayName());
        }
        return this.capability.K(time, this);
    }

    public boolean isValid(long time) {
        return this.getCapabilityValidity(time).G();
    }

    public boolean isGatewayMaltegoId(long time) {
        return this.getCapabilityValidity(time).J().K();
    }

    public int hashCode() {
        int hash = 5;
        hash = 17 * hash + Objects.hashCode(this.activationId);
        hash = 17 * hash + Objects.hashCode(this.clientFingerprint);
        hash = 17 * hash + Objects.hashCode(this.validFrom);
        hash = 17 * hash + Objects.hashCode(this.validTo);
        hash = 17 * hash + Objects.hashCode(this.product);
        hash = 17 * hash + Objects.hashCode(this.productPlan);
        hash = 17 * hash + Objects.hashCode(this.firstName);
        hash = 17 * hash + Objects.hashCode(this.lastName);
        hash = 17 * hash + Objects.hashCode(this.email);
        hash = 17 * hash + Objects.hashCode(this.organization);
        hash = 17 * hash + (this.inBeta ? 1 : 0);
        hash = 17 * hash + (this.allowCloudGraphs ? 1 : 0);
        return hash;
    }

    public boolean equalInfoAndCapabilities(JsonLicenseResponse other) {
        return this.equals(other);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonLicenseResponse other = (JsonLicenseResponse)obj;
        if (!Objects.equals(this.activationId, other.activationId)) {
            return false;
        }
        if (!Objects.equals(this.clientFingerprint, other.clientFingerprint)) {
            return false;
        }
        if (!Objects.equals(this.validFrom, other.validFrom)) {
            return false;
        }
        if (!Objects.equals(this.validTo, other.validTo)) {
            return false;
        }
        if (!Objects.equals(this.product, other.product)) {
            return false;
        }
        if (!Objects.equals(this.productPlan, other.productPlan)) {
            return false;
        }
        if (!Objects.equals(this.username, other.username)) {
            return false;
        }
        if (!Objects.equals(this.firstName, other.firstName)) {
            return false;
        }
        if (!Objects.equals(this.lastName, other.lastName)) {
            return false;
        }
        if (!Objects.equals(this.email, other.email)) {
            return false;
        }
        if (this.inBeta != other.inBeta) {
            return false;
        }
        if (this.allowCloudGraphs != other.allowCloudGraphs) {
            return false;
        }
        return Objects.equals(this.organization, other.organization);
    }
}

