/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import java.util.UUID;

public class TraceContextId {
    public static final String TRACE_CONTEXT_ID_KEY_HEADER = "traceparent";
    private final String versionId = "00";
    private final String traceId;
    private final String spanId;
    private final String traceFlags = "01";

    private TraceContextId() {
        this.traceId = TraceContextId.generateTraceId();
        this.spanId = TraceContextId.generateSpanId();
    }

    private TraceContextId(String traceId) {
        this.traceId = traceId;
        this.spanId = TraceContextId.generateSpanId();
    }

    public static TraceContextId create() {
        return new TraceContextId();
    }

    public static TraceContextId resetSpanId(TraceContextId toReset) {
        return new TraceContextId(toReset.traceId);
    }

    private static String generateTraceId() {
        return UUID.randomUUID().toString().replaceAll("-", "").substring(0, 32);
    }

    private static String generateSpanId() {
        return UUID.randomUUID().toString().replaceAll("-", "").substring(0, 16);
    }

    public synchronized String toString() {
        return String.format("%s-%s-%s-%s", "00", this.traceId, this.spanId, "01");
    }
}

