/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.query.part.LinkDataQuery;
import com.paterva.maltego.graph.store.query.part.LinkSectionsQuery;
import com.paterva.maltego.graph.store.query.part.PartSectionsQuery;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import java.util.Collections;
import java.util.Set;

public class PartTypeHelper {
    public static String getModelType(GraphID graphID, EntityID entityID) throws GraphStoreException {
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        return graphStore.getGraphDataStore().getDataStoreReader().getEntityType(entityID);
    }

    public static String getType(GraphID graphID, EntityID entityID) throws GraphStoreException {
        GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
        Set modelEntities = view.getModelViewMappings().getModelEntities(entityID);
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
        return dataReader.getEntityType((EntityID)modelEntities.iterator().next());
    }

    public static String getModelType(GraphID graphID, LinkID linkID) throws GraphStoreException {
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
        LinkDataQuery linkDataQuery = new LinkDataQuery();
        linkDataQuery.setAllSections(false);
        LinkSectionsQuery linkSectionsQuery = new LinkSectionsQuery();
        linkSectionsQuery.setQueryType(true);
        linkDataQuery.setSections((PartSectionsQuery)linkSectionsQuery);
        linkDataQuery.setAllProperties(false);
        linkDataQuery.setPropertyNames(Collections.emptySet());
        MaltegoLink link = dataReader.getLink(linkID, linkDataQuery);
        return link.getTypeName();
    }

    public static String getType(GraphID graphID, LinkID linkID) throws GraphStoreException {
        String type = null;
        GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
        if (view.getModelViewMappings().isModelLink(linkID)) {
            type = PartTypeHelper.getModelType(graphID, linkID);
        }
        return type;
    }
}

