/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.detailview.html;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.GraphLink;
import com.paterva.maltego.core.GraphPart;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.detailview.html.HtmlDetailViewSettings;
import com.paterva.maltego.detailview.html.HtmlObjectFactory;
import com.paterva.maltego.detailview.html.HtmlSelectListener;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.actions.NodeEditor;
import com.paterva.maltego.ui.graph.view2d.PinUtils;
import com.paterva.maltego.ui.graph.view2d.ZoomAndFlasher;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.privacymode.PrivacyMode;
import com.paterva.maltego.util.ui.privacymode.PrivacyModeSettings;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.lobobrowser.html.HtmlObject;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.HTMLLinkElementImpl;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.test.SimpleHtmlRendererContext;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;
import org.openide.util.NotImplementedException;
import org.w3c.dom.NodeList;
import org.w3c.dom.html2.HTMLElement;

class DetailViewRenderContext
extends SimpleHtmlRendererContext {
    private static final String HTML_CLASSID_ENTITY_IMAGE = "maltego.entity.image";
    public static final String HTML_CLASSID_ENTITY_PIN_OVERLAY_IMAGE = "maltego.entity.pin.overlay.image";
    public static final String HTML_CLASSID_ENTITY_COLLECTION_PIN_OVERLAY_IMAGE = "maltego.entity.collection.pin.overlay.image";
    private static final String HTML_CLASSID_LINK_IMAGE = "maltego.link.image";
    private static final String HTML_CLASSID_PHOTO_IMAGE = "maltego.photo.image";
    private GraphPart _part;
    private boolean _overLink = false;
    private boolean _overPinIcon = false;
    private final HashSet<HtmlSelectListener> htmlSelectListeners = new HashSet();

    public DetailViewRenderContext(HtmlPanel panel, UserAgentContext ctx) {
        super(panel, ctx);
    }

    public boolean isImageLoadingEnabled() {
        return !PrivacyMode.STEALTH.equals((Object)PrivacyModeSettings.getInstance().getPrivacyMode());
    }

    public void navigate(URL href, String target) {
        if (href != null) {
            String s = href.toString();
            if (s.startsWith("http://localhost:1/maltego/navigateTo/")) {
                String entity = s.substring("http://localhost:1/maltego/navigateTo/".length());
                if (entity.length() > 0) {
                    this.navigateToEntity(entity);
                }
            } else if (!FileUtilities.isRemoteFileURL((URL)href)) {
                HtmlBrowser.URLDisplayer.getDefault().showURL(href);
            }
        } else {
            super.navigate(href, target);
        }
    }

    public HtmlObject getHtmlObject(HTMLElement element) {
        if (this._part == null) {
            return null;
        }
        String classID = element.getAttribute("classid");
        String partID = element.getAttribute("data");
        GraphPart part = null;
        if (StringUtilities.isNullOrEmpty((String)partID)) {
            part = this.getSelectedPart();
        }
        if (null != classID) {
            switch (classID) {
                case "maltego.entity.image": {
                    if (part == null) {
                        part = this.getGraphEntity(partID);
                    }
                    if (part == null) {
                        IllegalArgumentException ex = new IllegalArgumentException("Entity for data: " + partID + " could not be found.");
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return HtmlObjectFactory.createEntityImage((GraphEntity)part);
                }
                case "maltego.entity.pin.overlay.image": 
                case "maltego.entity.collection.pin.overlay.image": {
                    if (part == null) {
                        part = this.getGraphEntity(partID);
                    }
                    if (part == null) {
                        IllegalArgumentException ex = new IllegalArgumentException("Entity for data: " + partID + " could not be found.");
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return HtmlObjectFactory.createEntityPinOverlayImage((GraphEntity)part, classID);
                }
                case "maltego.link.image": {
                    if (part == null) {
                        part = this.getGraphLink(partID);
                    }
                    if (part == null) {
                        IllegalArgumentException ex = new IllegalArgumentException("Link for data: " + partID + " could not be found.");
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    return HtmlObjectFactory.createLinkImage((GraphLink)part);
                }
                case "maltego.photo.image": {
                    if (part == null) {
                        part = this.getGraphEntity(partID);
                    }
                    if (part == null) {
                        part = this.getGraphLink(partID);
                    }
                    int attId = Integer.parseInt(element.getAttribute("attid"));
                    if (part == null) {
                        IllegalArgumentException ex = new IllegalArgumentException("Entity or link for data: " + partID + " could not be found.");
                        Exceptions.printStackTrace((Throwable)ex);
                        break;
                    }
                    return HtmlObjectFactory.createPhotoImage(attId, part);
                }
                default: {
                    NotImplementedException ex = new NotImplementedException("classID: " + classID + " not implemented.");
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return null;
    }

    public void setSelectedPart(GraphPart part) {
        this._part = part;
    }

    public GraphPart getSelectedPart() {
        return this._part;
    }

    private GraphEntity getGraphEntity(String entityGUID) {
        EntityID entityID = EntityID.parse((String)entityGUID);
        return new GraphEntity(this._part.getGraphID(), entityID);
    }

    private GraphLink getGraphLink(String linkGUID) {
        LinkID linkID = LinkID.parse((String)linkGUID);
        return new GraphLink(this._part.getGraphID(), linkID);
    }

    private void navigateToEntity(String entityIDStr) {
        GraphEntity graphEntity = this.getGraphEntity(entityIDStr);
        GraphID graphID = graphEntity.getGraphID();
        EntityID entityID = (EntityID)graphEntity.getID();
        Set<EntityID> entityIDs = Collections.singleton(entityID);
        GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
        selection.setSelectedModelEntities(entityIDs);
        for (HtmlSelectListener listener : this.htmlSelectListeners) {
            listener.htmlEntitiesSelected(entityIDs);
        }
        try {
            ZoomAndFlasher.instance().zoomAndFlash(graphID, entityID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void addHtmlSelectListener(HtmlSelectListener listener) {
        this.htmlSelectListeners.add(listener);
    }

    public void removeHtmlSelectListener(HtmlSelectListener listener) {
        this.htmlSelectListeners.remove(listener);
    }

    public void onMouseOver(HTMLElement element, MouseEvent event) {
        HTMLElementImpl elementImpl;
        String elementID;
        super.onMouseOver(element, event);
        if (!this._overLink && element instanceof HTMLLinkElementImpl) {
            this._overLink = true;
            this.getHtmlPanel().setCursor(Cursor.getPredefinedCursor(12));
        } else if (!this._overPinIcon && element instanceof HTMLElementImpl && "entityPinOverlayImage".equals(elementID = (elementImpl = (HTMLElementImpl)element).getId())) {
            this._overPinIcon = true;
            this.getHtmlPanel().setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public void onMouseOut(HTMLElement element, MouseEvent event) {
        HTMLElementImpl elementImpl;
        String elementID;
        super.onMouseOut(element, event);
        if (this._overLink && element instanceof HTMLLinkElementImpl) {
            this.getHtmlPanel().setCursor(Cursor.getDefaultCursor());
            this._overLink = false;
        } else if (this._overPinIcon && element instanceof HTMLElementImpl && "entityPinOverlayImage".equals(elementID = (elementImpl = (HTMLElementImpl)element).getId())) {
            this.getHtmlPanel().setCursor(Cursor.getDefaultCursor());
            this._overPinIcon = false;
        }
    }

    public boolean onMouseClick(HTMLElement element, MouseEvent event) {
        HTMLElementImpl elementImpl;
        String elementID;
        boolean value = super.onMouseClick(element, event);
        boolean foundCollapsible = false;
        for (String key : HtmlDetailViewSettings.KEYS) {
            HTMLElementImpl div = this.findByID(element.getChildNodes(), key);
            if (div == null) continue;
            boolean collapsed = "none".equals(div.getCurrentStyle().getPropertyValue("display"));
            HtmlDetailViewSettings.setCollapsed(key, collapsed);
            foundCollapsible = true;
            break;
        }
        if (!foundCollapsible && element != null && element instanceof HTMLElementImpl && this._part != null && ("entityPinOverlayImage".equals(elementID = (elementImpl = (HTMLElementImpl)element).getId()) || "entityCollectionPinOverlayImage".equals(elementID))) {
            GraphID graphID = this._part.getGraphID();
            if (this._part instanceof GraphEntity) {
                value = false;
                EntityID entityID = (EntityID)this._part.getID();
                GraphWrapper wrapper = MaltegoGraphManager.getWrapper((GraphID)graphID);
                boolean syncingChanged = false;
                if ("entityPinOverlayImage".equals(elementID) && PinUtils.isPinned((GraphID)graphID, (EntityID)entityID)) {
                    syncingChanged = true;
                    wrapper.setIsSyncing(true);
                }
                PinUtils.pinClicked((GraphWrapper)wrapper, (GraphID)graphID, (EntityID)entityID, (boolean)false, null);
                if (syncingChanged) {
                    wrapper.setIsSyncing(false);
                }
            }
        }
        return value;
    }

    public boolean onDoubleClick(HTMLElement element, MouseEvent event) {
        HTMLElementImpl elementImpl;
        if (element != null && element instanceof HTMLElementImpl && this._part != null && !"entityPinOverlayImage".equals((elementImpl = (HTMLElementImpl)element).getId()) && elementImpl.getAncestorWithId("table", "headingGroupId".toLowerCase()) != null) {
            GraphID graphID = this._part.getGraphID();
            if (this._part instanceof GraphEntity) {
                EntityID entityID = (EntityID)this._part.getID();
                GraphWrapper wrapper = MaltegoGraphManager.getWrapper((GraphID)graphID);
                if (!wrapper.isCollectionNode(entityID)) {
                    NodeEditor.getDefault().edit(graphID, entityID);
                }
            } else if (this._part instanceof GraphLink) {
                NodeEditor.getDefault().edit(graphID, (LinkID)this._part.getID());
            }
        }
        return false;
    }

    private HTMLElementImpl findByID(NodeList nodes, String id) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            HTMLElementImpl element;
            if (!(nodes.item(i) instanceof HTMLElement) || !id.equals((element = (HTMLElementImpl)nodes.item(i)).getId())) continue;
            return element;
        }
        return null;
    }
}

