/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.ui.open;

import com.maltego.cloud.CloudAuth;
import com.maltego.cloud.ui.open.OpenFromCloudAction;
import com.paterva.maltego.ui.graph.data.RecentCloudGraphs;
import com.paterva.maltego.util.StringUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.openide.util.NbPreferences;
import org.openide.util.actions.SystemAction;

public class OpenFromCloudSetttings
extends RecentCloudGraphs {
    private static final String PREF_OPEN_FROM_CLOUD = "maltego.openfromcloud";
    private static final String PREF_CLOUD_GRAPHS_COUNT = "maltego.openfromcloud.count";
    private final CloudAuth cloudAuth = CloudAuth.getDefault();

    public String[] getCloudGraphIds() {
        ArrayList<String> ids = new ArrayList<String>();
        if (this.cloudAuth.isCloudAuthEnabled()) {
            String id;
            Preferences prefs = this.getPreferences();
            int count = this.getCount(prefs);
            for (int i = 0; i < count && !StringUtilities.isNullOrEmpty((String)(id = this.getCloudGraphId(prefs, i))); ++i) {
                ids.add(id);
            }
        }
        return ids.toArray(new String[ids.size()]);
    }

    public String[] getCloudGraphNames() {
        String[] names = new String[]{};
        if (this.cloudAuth.isCloudAuthEnabled()) {
            Preferences prefs = this.getPreferences();
            String[] ids = this.getCloudGraphIds();
            names = new String[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                String name = prefs.get(ids[i], null);
                names[i] = name == null ? "Unnamed Graph" : name;
            }
        }
        return names;
    }

    public void addCloudGraphId(String id) {
        if (!StringUtilities.isNullOrEmpty((String)id)) {
            String[] ids;
            for (String otherId : ids = this.getCloudGraphIds()) {
                if (!id.equals(otherId)) continue;
                return;
            }
            Preferences prefs = this.getPreferences();
            this.setCloudGraphId(prefs, ids.length, id);
            this.setCount(prefs, ids.length + 1);
        }
    }

    public void clearCloudGraphIds() {
        try {
            this.getPreferences().clear();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
    }

    public void open(String cloudGraphId) {
        this.open(cloudGraphId, null, null);
    }

    public void open(String cloudGraphId, String cloudGraphVersion, Boolean editable) {
        OpenFromCloudAction action = (OpenFromCloudAction)SystemAction.get(OpenFromCloudAction.class);
        action.setCloudGraphId(cloudGraphId);
        action.setCloudGraphVersion(cloudGraphVersion);
        action.setEditable(editable);
        action.actionPerformed(null);
    }

    protected int getCount(Preferences prefs) {
        return prefs.getInt(PREF_CLOUD_GRAPHS_COUNT, 0);
    }

    protected void setCount(Preferences prefs, int count) {
        prefs.putInt(PREF_CLOUD_GRAPHS_COUNT, count);
    }

    protected String getCloudGraphId(Preferences prefs, int index) {
        return prefs.get(OpenFromCloudSetttings.getIdKey(index), null);
    }

    protected void setCloudGraphId(Preferences prefs, int index, String id) {
        prefs.put(OpenFromCloudSetttings.getIdKey(index), id);
    }

    protected void setCloudGraphName(Preferences prefs, String id, String name) {
        prefs.put(id, name);
    }

    private static String getIdKey(int index) {
        return "maltego.openfromcloud." + index;
    }

    protected Preferences getPreferences() {
        return NbPreferences.forModule(OpenFromCloudSetttings.class);
    }

    public void addCloudGraph(String id, String name) {
        if (!StringUtilities.isNullOrEmpty((String)id)) {
            String[] ids;
            for (String otherId : ids = this.getCloudGraphIds()) {
                if (!id.equals(otherId)) continue;
                return;
            }
            Preferences prefs = this.getPreferences();
            this.setCloudGraphId(prefs, ids.length, id);
            this.setCloudGraphName(prefs, id, name);
            this.setCount(prefs, ids.length + 1);
        }
    }

    public void removeCloudGraph(String idParam) {
        if (!StringUtilities.isNullOrEmpty((String)idParam)) {
            boolean found = false;
            ArrayList ids = new ArrayList();
            Collections.addAll(ids, this.getCloudGraphIds());
            ArrayList cloudGraphNames = new ArrayList();
            Collections.addAll(cloudGraphNames, this.getCloudGraphNames());
            int count = 0;
            Iterator iter = ids.iterator();
            while (iter.hasNext()) {
                if (idParam.equals(iter.next())) {
                    found = true;
                    iter.remove();
                    cloudGraphNames.remove(count);
                    break;
                }
                ++count;
            }
            if (found) {
                this.clearCloudGraphIds();
                for (int i = 0; i < ids.size(); ++i) {
                    this.addCloudGraph((String)ids.get(i), (String)cloudGraphNames.get(i));
                }
            }
        }
    }
}

