/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.parsing.CTSymArchive;
import org.netbeans.modules.java.source.parsing.CacheFolderArchive;
import org.netbeans.modules.java.source.parsing.CachingArchive;
import org.netbeans.modules.java.source.parsing.CachingPathArchive;
import org.netbeans.modules.java.source.parsing.FileObjectArchive;
import org.netbeans.modules.java.source.parsing.FolderArchive;
import org.netbeans.modules.java.source.parsing.PathArchive;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;
import org.openide.util.Pair;

public final class CachingArchiveProvider {
    private static final String NAME_RT_JAR = "rt.jar";
    private static final String NAME_INNER_RT_JAR = "rt.jar!/";
    private static final String PATH_CT_SYM = "lib/ct.sym";
    private static final String PATH_RT_JAR_IN_CT_SYM = "META-INF/sym/rt.jar/";
    private static final boolean USE_CT_SYM = !Boolean.getBoolean("CachingArchiveProvider.disableCtSym");
    private static final Pair<Archive, URI> EMPTY = Pair.of(null, null);
    private static CachingArchiveProvider instance;
    private final Map<URI, Archive> archives = new HashMap<URI, Archive>();
    private final Map<URI, URI> ctSymToJar = new HashMap<URI, URI>();

    public static synchronized CachingArchiveProvider getDefault() {
        if (instance == null) {
            instance = new CachingArchiveProvider();
        }
        return instance;
    }

    static CachingArchiveProvider newInstance() {
        return new CachingArchiveProvider();
    }

    private CachingArchiveProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    public Archive getArchive(@NonNull URL root, boolean cacheFile) {
        Archive archive;
        URI rootURI = CachingArchiveProvider.toURI(root);
        CachingArchiveProvider cachingArchiveProvider = this;
        synchronized (cachingArchiveProvider) {
            archive = this.archives.get(rootURI);
        }
        if (archive == null) {
            Pair<Archive, URI> becomesArchive = this.create((Pair<URL, URI>)Pair.of((Object)root, (Object)rootURI), cacheFile);
            archive = (Archive)becomesArchive.first();
            URI uriToCtSym = (URI)becomesArchive.second();
            if (archive != null) {
                CachingArchiveProvider cachingArchiveProvider2 = this;
                synchronized (cachingArchiveProvider2) {
                    Archive oldArchive = this.archives.put(rootURI, archive);
                    if (oldArchive != null) {
                        archive = oldArchive;
                        this.archives.put(rootURI, archive);
                    } else if (uriToCtSym != null) {
                        this.ctSymToJar.put(uriToCtSym, rootURI);
                    }
                }
            }
        }
        return archive;
    }

    public synchronized void removeArchive(@NonNull URL root) {
        URI rootURI = CachingArchiveProvider.toURI(root);
        Archive archive = this.archives.remove(rootURI);
        Iterator<Map.Entry<URI, URI>> it = this.ctSymToJar.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<URI, URI> e = it.next();
            if (!e.getValue().equals(rootURI)) continue;
            it.remove();
            break;
        }
        if (archive != null) {
            archive.clear();
        }
    }

    public synchronized void clearArchive(@NonNull URL root) {
        Archive archive = this.archives.get(CachingArchiveProvider.toURI(root));
        if (archive != null) {
            archive.clear();
        }
    }

    @NonNull
    public synchronized URL mapCtSymToJar(@NonNull URL archiveOrCtSym) {
        URI result = this.ctSymToJar.get(CachingArchiveProvider.toURI(archiveOrCtSym));
        if (result != null) {
            try {
                return result.toURL();
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return archiveOrCtSym;
    }

    @NonNull
    public synchronized URL[] ctSymRootsFor(@NonNull ClassPath cp) {
        ArrayList<URL> res = new ArrayList<URL>();
        for (ClassPath.Entry entry : cp.entries()) {
            URL root = entry.getURL();
            if (!root.getPath().endsWith(NAME_INNER_RT_JAR)) continue;
            try {
                for (Map.Entry<URI, URI> e : this.ctSymToJar.entrySet()) {
                    if (!e.getValue().equals(root.toURI())) continue;
                    res.add(e.getKey().toURL());
                }
            }
            catch (MalformedURLException | URISyntaxException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return res.toArray(new URL[res.size()]);
    }

    public boolean hasCtSym(@NonNull URL root) {
        File f;
        URL fileURL = FileUtil.getArchiveFile((URL)root);
        if (fileURL == null) {
            return false;
        }
        try {
            f = BaseUtilities.toFile((URI)fileURL.toURI());
        }
        catch (URISyntaxException ex) {
            return false;
        }
        if (f == null || !f.exists()) {
            return false;
        }
        Pair<File, String> res = this.mapJarToCtSym(f);
        return res.second() != null;
    }

    synchronized void clear() {
        this.archives.clear();
        this.ctSymToJar.clear();
    }

    @NonNull
    private Pair<Archive, URI> create(Pair<URL, URI> root, boolean cacheFile) {
        URL inner;
        String protocol = ((URL)root.first()).getProtocol();
        if ("file".equals(protocol)) {
            File f = BaseUtilities.toFile((URI)((URI)root.second()));
            if (JavaIndex.isCacheFolder(f)) {
                return Pair.of((Object)new CacheFolderArchive(f), null);
            }
            if (f.isDirectory()) {
                return Pair.of((Object)new FolderArchive(f), null);
            }
            return EMPTY;
        }
        if ("jar".equals(protocol) && ((URL)root.first()).getPath().endsWith("!/") && "file".equals(protocol = (inner = FileUtil.getArchiveFile((URL)((URL)root.first()))).getProtocol())) {
            File f = BaseUtilities.toFile((URI)URI.create(inner.toExternalForm()));
            if (f.isFile()) {
                URI uriInCtSym;
                Pair<File, String> resolved = this.mapJarToCtSym(f);
                if (resolved.second() == null) {
                    return Pair.of((Object)new CachingArchive((File)resolved.first(), (String)resolved.second(), cacheFile), null);
                }
                try {
                    uriInCtSym = CachingArchiveProvider.toURI(resolved);
                }
                catch (IllegalArgumentException e) {
                    uriInCtSym = null;
                }
                return Pair.of((Object)new CTSymArchive(f, null, (File)resolved.first(), (String)resolved.second()), (Object)uriInCtSym);
            }
            return EMPTY;
        }
        FileObject fo = URLMapper.findFileObject((URL)((URL)root.first()));
        if (fo != null) {
            Object attr = fo.getAttribute(Path.class.getName());
            if (attr instanceof Path) {
                return Pair.of((Object)(cacheFile ? new CachingPathArchive((Path)attr, (URI)root.second()) : new PathArchive((Path)attr, (URI)root.second())), null);
            }
            return Pair.of((Object)new FileObjectArchive(fo), null);
        }
        return EMPTY;
    }

    @NonNull
    private Pair<File, String> mapJarToCtSym(@NonNull File file) {
        FileObject fo;
        if (USE_CT_SYM && NAME_RT_JAR.equals(file.getName()) && (fo = FileUtil.toFileObject((File)file)) != null) {
            for (JavaPlatform jp : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
                for (FileObject jdkFolder : jp.getInstallFolders()) {
                    File ctSymFile;
                    FileObject ctSym;
                    if (!FileUtil.isParentOf((FileObject)jdkFolder, (FileObject)fo) || (ctSym = jdkFolder.getFileObject(PATH_CT_SYM)) == null || (ctSymFile = FileUtil.toFile((FileObject)ctSym)) == null) continue;
                    return Pair.of((Object)ctSymFile, (Object)PATH_RT_JAR_IN_CT_SYM);
                }
            }
        }
        return Pair.of((Object)file, null);
    }

    @NonNull
    private static URI toURI(@NonNull URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @NonNull
    private static URI toURI(@NonNull Pair<File, String> path) {
        try {
            URL root = FileUtil.getArchiveRoot((URL)BaseUtilities.toURI((File)((File)path.first())).toURL());
            return new URI(String.format("%s%s", root.toExternalForm(), PATH_RT_JAR_IN_CT_SYM));
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

