/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.dialog;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.DialogDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;

public class EditDialogDescriptor
extends WizardDescriptor {
    private WizardDescriptor.Panel[] _panels;
    private DialogDescriptor _delegate;
    private ChangeListener _panelChangeListener;
    private int _currentIndex = -1;
    private final boolean enforceDefaultButton;

    public EditDialogDescriptor(WizardDescriptor.Panel panel) {
        this("", panel);
    }

    public EditDialogDescriptor(String title, WizardDescriptor.Panel panel) {
        this(title, new WizardDescriptor.Panel[]{panel}, false);
    }

    public EditDialogDescriptor(String title, WizardDescriptor.Panel panel, boolean enforceDefaultButton) {
        this(title, new WizardDescriptor.Panel[]{panel}, enforceDefaultButton);
    }

    public EditDialogDescriptor(WizardDescriptor.Panel[] panels) {
        this("", panels, false);
    }

    public EditDialogDescriptor(String title, WizardDescriptor.Panel[] panels) {
        this(title, panels, false);
    }

    public EditDialogDescriptor(String title, WizardDescriptor.Panel[] panels, boolean enforceDefaultButton) {
        super(new WizardDescriptor.Panel[]{new DummyPanel()});
        this.enforceDefaultButton = enforceDefaultButton;
        this._panels = panels;
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (EditDialogDescriptor.this._delegate != null) {
                    if ("WizardPanel_errorMessage".equals(evt.getPropertyName())) {
                        System.out.println(EditDialogDescriptor.this._delegate);
                        System.out.println(EditDialogDescriptor.this._delegate.getNotificationLineSupport());
                        System.out.println(evt);
                        EditDialogDescriptor.this._delegate.getNotificationLineSupport().setErrorMessage(evt.getNewValue() == null ? null : evt.getNewValue().toString());
                    } else if ("WizardPanel_warningMessage".equals(evt.getPropertyName())) {
                        EditDialogDescriptor.this._delegate.getNotificationLineSupport().setWarningMessage(evt.getNewValue() == null ? null : evt.getNewValue().toString());
                    } else if ("WizardPanel_infoMessage".equals(evt.getPropertyName())) {
                        EditDialogDescriptor.this._delegate.getNotificationLineSupport().setInformationMessage(evt.getNewValue() == null ? null : evt.getNewValue().toString());
                    } else if ("valid".equals(evt.getPropertyName())) {
                        EditDialogDescriptor.this._delegate.setValid(((Boolean)evt.getNewValue()).booleanValue());
                    }
                }
            }
        });
        this._panelChangeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                WizardDescriptor.Panel current = EditDialogDescriptor.this.getPanel(EditDialogDescriptor.this._currentIndex);
                if (current != null) {
                    EditDialogDescriptor.this._delegate.setValid(current.isValid());
                }
            }
        };
        this.setTitle(title);
    }

    public boolean enforceDefaultButton() {
        return this.enforceDefaultButton;
    }

    DialogDescriptor createDialogDescriptor() {
        Component ctrl = this.createComponent();
        this._delegate = new DialogDescriptor((Object)ctrl, this.getTitle(), true, 2, OK_OPTION, null);
        this._delegate.createNotificationLineSupport();
        return this._delegate;
    }

    protected Component createComponent() {
        if (this._panels.length == 0) {
            return new JPanel();
        }
        if (this._panels.length == 1) {
            Component c = this._panels[0].getComponent();
            this.panelShowing(0);
            return c;
        }
        TabbedPane tabs = new TabbedPane(1, 0);
        for (WizardDescriptor.Panel panel : this._panels) {
            Component component = panel.getComponent();
            String name = component.getName();
            tabs.addTab(name, component);
        }
        tabs.setSelectedIndex(0);
        tabs.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        return tabs;
    }

    private boolean canMove(int from, int to) {
        if (from == to) {
            return false;
        }
        WizardDescriptor.Panel current = this.getPanel(from);
        if (current == null) {
            return true;
        }
        return this.validate(current);
    }

    private WizardDescriptor.Panel getPanel(int index) {
        if (index >= 0 && index < this._panels.length) {
            return this._panels[index];
        }
        return null;
    }

    private boolean validate(WizardDescriptor.Panel current) {
        if (!current.isValid()) {
            return false;
        }
        if (current instanceof WizardDescriptor.ValidatingPanel) {
            WizardDescriptor.ValidatingPanel validatingPanel = (WizardDescriptor.ValidatingPanel)current;
            try {
                validatingPanel.validate();
            }
            catch (WizardValidationException ex) {
                this._delegate.getNotificationLineSupport().setErrorMessage(ex.getLocalizedMessage());
                return false;
            }
        }
        return true;
    }

    private void panelShowing(int index) {
        WizardDescriptor.Panel panel = this.getPanel(index);
        if (panel != null) {
            this._currentIndex = index;
            this.readSettings(panel);
            panel.addChangeListener(this._panelChangeListener);
        }
    }

    private void panelClosed(int index) {
        WizardDescriptor.Panel panel = this.getPanel(index);
        if (panel != null) {
            panel.removeChangeListener(this._panelChangeListener);
            this.storeSettings(panel);
        }
    }

    private void readSettings(WizardDescriptor.Panel panel) {
        panel.readSettings((Object)this);
    }

    private void storeSettings(WizardDescriptor.Panel panel) {
        panel.storeSettings((Object)this);
    }

    boolean tryClose() {
        WizardDescriptor.Panel current = this.getPanel(this._currentIndex);
        if (current != null) {
            if (!this.validate(current)) {
                return false;
            }
            this.storeSettings(current);
        }
        return true;
    }

    private final class TabbedPane
    extends JTabbedPane {
        public TabbedPane() {
        }

        public TabbedPane(int tabPlacement) {
            super(tabPlacement);
        }

        public TabbedPane(int tabPlacement, int tabLayoutPolicy) {
            super(tabPlacement, tabLayoutPolicy);
        }

        @Override
        public void setSelectedIndex(int to) {
            int from = this.getSelectedIndex();
            if (EditDialogDescriptor.this.canMove(from, to)) {
                EditDialogDescriptor.this.panelClosed(from);
                EditDialogDescriptor.this.panelShowing(to);
                super.setSelectedIndex(to);
            }
        }
    }

    private static class DummyPanel
    implements WizardDescriptor.Panel {
        private DummyPanel() {
        }

        public Component getComponent() {
            return new JLabel();
        }

        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public void readSettings(Object arg0) {
        }

        public void storeSettings(Object arg0) {
        }

        public boolean isValid() {
            return true;
        }

        public void addChangeListener(ChangeListener arg0) {
        }

        public void removeChangeListener(ChangeListener arg0) {
        }
    }
}

