/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import java.util.Stack;
import org.openide.explorer.view.CheckableNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public abstract class RecursiveCheckableNode
extends AbstractNode
implements CheckableNode {
    public static final String PROP_SELECTED = "checked";
    private Boolean _selected = Boolean.TRUE;

    public RecursiveCheckableNode(Children children, Lookup lookup) {
        super(children, lookup);
    }

    public RecursiveCheckableNode(Children children) {
        super(children);
    }

    public boolean isCheckable() {
        return true;
    }

    public boolean isCheckEnabled() {
        return true;
    }

    public Boolean isSelected() {
        return this._selected;
    }

    public void setSelected(Boolean selected) {
        if (!this._selected.equals(selected)) {
            this.setSelectedNonRecursive(selected);
            this.recursiveCheckUp(selected);
            this.recursiveCheckDown(selected);
        }
    }

    public void setSelectedNonRecursive(Boolean selected) {
        if (!this._selected.equals(selected)) {
            this._selected = selected;
            this.fireIconChange();
        }
    }

    private void recursiveCheckUp(Boolean selected) {
        Node parent = this.getParentNode();
        while (parent != null) {
            if (parent instanceof RecursiveCheckableNode) {
                RecursiveCheckableNode rn = (RecursiveCheckableNode)parent;
                rn.updateChildChanged();
                parent = parent.getParentNode();
                continue;
            }
            parent = null;
        }
    }

    private void recursiveCheckDown(Boolean selected) {
        Stack nodes = new Stack();
        nodes.addAll(this.getChildren().snapshot());
        while (!nodes.empty()) {
            RecursiveCheckableNode rn;
            Node node = (Node)nodes.pop();
            if (!(node instanceof RecursiveCheckableNode) || !(rn = (RecursiveCheckableNode)node).isCheckEnabled()) continue;
            rn.setSelectedNonRecursive(selected);
            nodes.addAll(rn.getChildren().snapshot());
        }
    }

    private void updateChildChanged() {
        for (Node node : this.getChildren().getNodes()) {
            CheckableNode checkableNode;
            if (!(node instanceof CheckableNode) || !(checkableNode = (CheckableNode)node).isSelected().booleanValue()) continue;
            this.setSelectedNonRecursive(Boolean.TRUE);
            return;
        }
        if (this.unselectWhenNoSelectedChildren()) {
            this.setSelectedNonRecursive(Boolean.FALSE);
        }
    }

    protected boolean unselectWhenNoSelectedChildren() {
        return true;
    }
}

