/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.view;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphUserData;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultGraphStoreViewRegistry
extends GraphStoreViewRegistry {
    private static final Logger LOG = Logger.getLogger(DefaultGraphStoreViewRegistry.class.getName());

    @Override
    public void register(String viewName, GraphID graphID, GraphStoreView view) {
        LOG.log(Level.FINE, "Registering: {0}->{1}", new Object[]{viewName, graphID});
        GraphUserData gud = GraphUserData.forGraph((GraphID)graphID);
        String key = GraphStoreViewRegistry.class.getName();
        HashMap<String, GraphStoreView> viewsByName = (HashMap<String, GraphStoreView>)gud.get((Object)key);
        if (viewsByName != null) {
            if (viewsByName.containsKey(viewName)) {
                throw new IllegalArgumentException("View '" + viewName + "' already exists for graph " + graphID);
            }
        } else {
            viewsByName = new HashMap<String, GraphStoreView>();
            gud.put((Object)key, viewsByName);
        }
        viewsByName.put(viewName, view);
    }

    @Override
    public GraphStoreView getDefaultView(GraphID graphID) {
        return this.getView("Main", graphID);
    }

    @Override
    public GraphStoreView getView(String viewName, GraphID graphID) {
        String key;
        GraphUserData gud = GraphUserData.forGraph((GraphID)graphID);
        Map viewsByName = (Map)gud.get((Object)(key = GraphStoreViewRegistry.class.getName()));
        if (viewsByName == null || !viewsByName.containsKey(viewName)) {
            throw new IllegalArgumentException("View '" + viewName + "' does not exist for graph " + graphID + ". Found view '" + viewsByName + "'.");
        }
        return (GraphStoreView)viewsByName.get(viewName);
    }
}

