/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v3.api;

import com.maltego.tx3.java.api.discovery.DisplayField;
import com.maltego.tx3.java.api.discovery.V3EntityOverlay;
import com.maltego.tx3.java.api.execution.Entity;
import com.maltego.tx3.java.api.execution.Graph;
import com.maltego.tx3.java.api.execution.Link;
import com.maltego.tx3.java.api.execution.Property;
import com.paterva.maltego.core.DisplayInformation;
import com.paterva.maltego.core.DisplayInformationCollection;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.OverlayDescriptor;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkFactory;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.protocol.v2api.V2EntitySpecTranslator;
import com.paterva.maltego.transform.protocol.v3.api.remote.V3ValueConverter;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.PropertyValueFormat;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.typing.types.DateRange;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.util.Args;
import com.paterva.maltego.util.ImageUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openide.util.Exceptions;

public class V3ProtocolTranslator {
    private static final String ICON_PROPERTY_NAME = "reserved-entity-icon-overlay-url";
    private static final Set<Property.PropertyType> NO_JSON_NATIVE_PROPERTY_TYPES = EnumSet.of(Property.PropertyType.DATE, new Property.PropertyType[]{Property.PropertyType.DATE_TIME, Property.PropertyType.DATE_RANGE, Property.PropertyType.TIME_SPAN, Property.PropertyType.COLOR, Property.PropertyType.URL});

    public static Graph translate(List<MaltegoEntity> entities, Map<MaltegoLink, LinkEntityIDs> links, EntityRegistry registry) {
        Args.notNull(entities, (String)"entities");
        Args.notNull(links, (String)"links");
        List<Entity> v3Entities = V3ProtocolTranslator.translate(entities, registry);
        List<Link> v3Links = V3ProtocolTranslator.translate(links);
        return new Graph(v3Entities, v3Links);
    }

    public static List<Link> translate(Map<MaltegoLink, LinkEntityIDs> maltegoLinks) {
        Args.notNull(maltegoLinks, (String)"maltegoLinks");
        ArrayList<Link> links = new ArrayList<Link>();
        for (Map.Entry<MaltegoLink, LinkEntityIDs> entry : maltegoLinks.entrySet()) {
            MaltegoLink maltegoLink = entry.getKey();
            LinkEntityIDs linkEntityId = entry.getValue();
            List<Property> linkProperties = V3ProtocolTranslator.translateProperties((MaltegoPart)maltegoLink);
            links.add(new Link(((LinkID)maltegoLink.getID()).toString(), linkEntityId.getSourceID().toString(), linkEntityId.getTargetID().toString(), linkProperties));
        }
        return links;
    }

    public static List<Entity> translate(List<MaltegoEntity> entities, EntityRegistry registry) {
        Args.notNull(entities, (String)"entities");
        return entities.stream().map(e -> V3ProtocolTranslator.translate(e, registry)).collect(Collectors.toList());
    }

    public static Entity translate(MaltegoEntity maltegoEntity, EntityRegistry registry) {
        Args.notNull((Object)maltegoEntity, (String)"maltegoEntity");
        List<Property> properties = V3ProtocolTranslator.translateProperties((MaltegoPart)maltegoEntity);
        ArrayList<DisplayField> displayInformations = new ArrayList<DisplayField>();
        for (Object di : maltegoEntity.getOrCreateDisplayInformation()) {
            displayInformations.add(new DisplayField(di.getName(), di.getValue(), "text/html"));
        }
        ArrayList<V3EntityOverlay> overlays = new ArrayList<V3EntityOverlay>();
        if (maltegoEntity.getOverlaySet() != null) {
            for (OverlayDescriptor overlay : maltegoEntity.getOverlaySet()) {
                String name = overlay.getPropertyName();
                V3EntityOverlay.OverlayPosition position = V3EntityOverlay.OverlayPosition.valueOf((String)overlay.getPosition().code);
                V3EntityOverlay.OverlayType type = V3EntityOverlay.OverlayType.fromType((String)overlay.getType().type);
                overlays.add(new V3EntityOverlay(name, position, type));
            }
        }
        PropertyDescriptor valueProp = InheritanceHelper.getValueProperty((SpecRegistry)registry, (TypedPropertyBag)maltegoEntity, (boolean)true);
        String valuePropertyName = null;
        if (valueProp != null) {
            valuePropertyName = valueProp.getName();
        }
        List baseEntities = InheritanceHelper.getInheritanceList((SpecRegistry)registry, (String)maltegoEntity.getTypeName()).stream().filter(baseEntity -> !baseEntity.equals("maltego.Unknown") && !baseEntity.equals(maltegoEntity.getTypeName())).collect(Collectors.toList());
        return new Entity(((EntityID)maltegoEntity.getID()).toString(), valuePropertyName, maltegoEntity.getNonBlankImageExpression().orElse(""), Integer.valueOf(maltegoEntity.getWeight()), properties, displayInformations, maltegoEntity.getTypeName(), Entity.Bookmark.fromCode((Integer)maltegoEntity.getBookmark()), baseEntities, overlays, maltegoEntity.getNotes());
    }

    public static List<MaltegoEntity> translate(List<Entity> entities, EntityFactory factory, EntityRegistry registry) throws TypeInstantiationException {
        Args.notNull(entities, (String)"entities");
        Args.notNull((Object)factory, (String)"factory");
        Args.notNull((Object)registry, (String)"registry");
        ArrayList<MaltegoEntity> maltegoEntities = new ArrayList<MaltegoEntity>();
        for (Entity e : entities) {
            maltegoEntities.add(V3ProtocolTranslator.translate(e, factory, registry));
        }
        return maltegoEntities;
    }

    public static MaltegoEntity translate(Entity entity, EntityFactory factory, EntityRegistry registry) throws TypeInstantiationException {
        Args.notNull((Object)entity, (String)"entity");
        Args.notNull((Object)factory, (String)"factory");
        Args.notNull((Object)registry, (String)"registry");
        MaltegoEntity maltegoEntity = factory.createInstance(V2EntitySpecTranslator.getDefault().getV3TypeName(entity.getType()), false, EntityID.parse((String)entity.getId()), true);
        return V3ProtocolTranslator.translate(entity, maltegoEntity);
    }

    public static MaltegoEntity translate(Entity entity, MaltegoEntity maltegoEntity) {
        if (entity.getProperties() != null) {
            V3ProtocolTranslator.setProperties(entity.getProperties(), (MaltegoPart)maltegoEntity);
        }
        if (entity.getBookmark() != null) {
            maltegoEntity.setBookmark(entity.getBookmark().getCode());
        }
        if (entity.getDisplayInformation() != null) {
            DisplayInformationCollection displayInformations = new DisplayInformationCollection();
            for (DisplayField field : entity.getDisplayInformation()) {
                displayInformations.add(field.getName(), field.getValue());
            }
            if (maltegoEntity.getDisplayInformation() != null) {
                for (DisplayInformation info : maltegoEntity.getDisplayInformation()) {
                    if (displayInformations.contains((Object)info)) continue;
                    displayInformations.add(info);
                }
            }
            maltegoEntity.setDisplayInformation(displayInformations);
        }
        if (entity.getOverlays() != null) {
            for (V3EntityOverlay overlay : entity.getOverlays()) {
                maltegoEntity.addOverlay(new OverlayDescriptor(overlay.getPropertyName(), overlay.getPosition().name(), overlay.getType().name()));
            }
        }
        if (maltegoEntity.getProperties().stream().anyMatch(p -> p.getName().equals(ICON_PROPERTY_NAME))) {
            maltegoEntity.setImageExpression(ICON_PROPERTY_NAME);
        } else {
            V3ProtocolTranslator.tryParsingImageProp(maltegoEntity);
        }
        if (entity.getWeight() != null && entity.getWeight() >= 0) {
            maltegoEntity.setWeight(entity.getWeight());
        }
        if (entity.getNote() != null) {
            maltegoEntity.setNotes(entity.getNote());
            maltegoEntity.setShowNotes(Boolean.valueOf(true));
        }
        return maltegoEntity;
    }

    public static List<MaltegoLink> translate(List<Link> links, LinkFactory factory, TransformDefinition transform, DateTime transformRunDate) {
        Args.notNull(links, (String)"links");
        Args.notNull((Object)factory, (String)"factory");
        Args.notNull((Object)transform, (String)"transform");
        ArrayList<MaltegoLink> maltegoLinks = new ArrayList<MaltegoLink>();
        for (Link link : links) {
            maltegoLinks.add(V3ProtocolTranslator.translate(link, factory, transform, transformRunDate));
        }
        return maltegoLinks;
    }

    public static MaltegoLink translate(Link link, LinkFactory factory, TransformDefinition transform, DateTime transformRunDate) {
        Args.notNull((Object)link, (String)"link");
        Args.notNull((Object)factory, (String)"factory");
        Args.notNull((Object)transform, (String)"transform");
        MaltegoLink maltegoLink = factory.createInstance(MaltegoLinkSpec.getTransformSpec(), LinkID.parse((String)link.getId()), true);
        PropertyDescriptorCollection properties = maltegoLink.getProperties();
        maltegoLink.setValue(properties.get("maltego.link.transform.name"), (Object)transform.getName());
        maltegoLink.setValue(properties.get("maltego.link.transform.display-name"), (Object)transform.getDisplayName());
        maltegoLink.setValue(properties.get("maltego.link.transform.version"), (Object)transform.getVersion());
        maltegoLink.setValue(properties.get("maltego.link.transform.run-date"), (Object)transformRunDate);
        V3ProtocolTranslator.setProperties(link.getProperties(), (MaltegoPart)maltegoLink);
        PropertyDescriptor pd = maltegoLink.getProperties().get("maltego.link.is_reversed");
        if (pd != null) {
            maltegoLink.setReversed(Boolean.valueOf((Boolean)maltegoLink.getValue(pd)));
        }
        return maltegoLink;
    }

    public static String v3PropertyName(Entity from, String property, String defaultValue, EntityRegistry registry) {
        Args.notNull((Object)from, (String)"from");
        Args.notNull((Object)property, (String)"property");
        Args.notNull((Object)defaultValue, (String)"defaultValue");
        Args.notNull((Object)registry, (String)"registry");
        String type = V2EntitySpecTranslator.getDefault().getV3TypeName(from.getType());
        String result = null;
        List inheritedTypes = InheritanceHelper.getInheritanceList((SpecRegistry)registry, (String)type);
        Iterator iterator = inheritedTypes.iterator();
        if (iterator.hasNext()) {
            String inheritedType;
            result = inheritedType = (String)iterator.next();
        }
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    private static List<Property> translateProperties(MaltegoPart maltegoPart) {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (PropertyDescriptor pd : maltegoPart.getProperties()) {
            DisplayDescriptor dd;
            Object value = maltegoPart.getValue(pd);
            if (pd instanceof DisplayDescriptor && ((dd = (DisplayDescriptor)pd).getDefaultValue() == null && value == null || dd.getDefaultValue() != null && dd.getDefaultValue().equals(value))) continue;
            try {
                Property property = V3ProtocolTranslator.propertyFromPropertyDescriptor(pd, value);
                if (property == null) continue;
                properties.add(property);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return properties;
    }

    public static void setProperties(List<Property> properties, MaltegoPart maltegoPart) {
        Set propertyNames = properties.stream().map(p -> p.getName()).collect(Collectors.toSet());
        for (Property property : properties) {
            PropertyDescriptor pd = maltegoPart.getProperties().get(property.getName());
            if (pd == null) {
                pd = V3ProtocolTranslator.propertyDescriptorFromProperty(property);
                maltegoPart.addProperty(pd);
            }
            Class toClazz = pd.getType();
            Object propertyValue = property.getValue();
            if (toClazz.isArray() && NO_JSON_NATIVE_PROPERTY_TYPES.contains(property.getType())) {
                propertyValue = Converter.removeNullStringsFromArray((Object)propertyValue);
                propertyValue = Converter.changeArrayType((Object)propertyValue, String.class);
                propertyValue = Converter.convert((Object)propertyValue, (Class)toClazz);
            } else if (toClazz.isArray()) {
                if (toClazz.getComponentType() == String.class) {
                    propertyValue = Converter.removeNullStringsFromArray((Object)propertyValue);
                }
                propertyValue = Converter.changeArrayType((Object)propertyValue, toClazz.getComponentType());
            } else if (propertyValue != null && !propertyValue.getClass().equals(toClazz)) {
                propertyValue = Converter.convert((Object)propertyValue, (Class)toClazz);
            }
            try {
                if (pd instanceof DisplayDescriptor) {
                    List linkedProperties;
                    Set linkedPropertyNames;
                    DisplayDescriptor dd = (DisplayDescriptor)pd;
                    dd.setPropertyValueFormat(PropertyValueFormat.JSON);
                    if (dd.getEvaluator() != null && propertyValue instanceof String && (linkedPropertyNames = (linkedProperties = dd.getEvaluator().getLinkedProperties((String)propertyValue)).stream().map(lp -> lp.getName()).collect(Collectors.toSet())).retainAll(propertyNames) && linkedPropertyNames.isEmpty()) {
                        propertyValue = "";
                    }
                }
                maltegoPart.setValue(pd, propertyValue);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static PropertyDescriptor propertyDescriptorFromProperty(Property property) {
        Class<?> clazz = V3ProtocolTranslator.getClassTo(property);
        return new PropertyDescriptor(clazz, property.getName(), property.getDisplayName());
    }

    private static Class<?> getClassTo(Property property) {
        Property.PropertyType type = property.getType();
        boolean isArray = property.getValue().getClass().isArray();
        return V3ProtocolTranslator.getClassTo(type, isArray, property.getValue());
    }

    private static Class<?> getClassTo(Property.PropertyType propertyType, boolean isArray, Object value) {
        switch (propertyType) {
            case STRING: {
                return isArray ? String[].class : String.class;
            }
            case DOUBLE: {
                return isArray ? double[].class : Double.TYPE;
            }
            case BOOLEAN: {
                return isArray ? boolean[].class : Boolean.TYPE;
            }
            case INT: {
                if (!isArray) {
                    if (value instanceof Long) {
                        return Long.TYPE;
                    }
                    if (value instanceof BigInteger) {
                        return BigInteger.class;
                    }
                } else if (value != null && isArray && ((Object[])value).length > 0) {
                    if (((Object[])value)[0] instanceof Long) {
                        return long[].class;
                    }
                    if (((Object[])value)[0] instanceof BigInteger) {
                        return BigInteger[].class;
                    }
                }
                return isArray ? int[].class : Integer.TYPE;
            }
            case DATE: {
                return isArray ? Date[].class : Date.class;
            }
            case DATE_RANGE: {
                return isArray ? DateRange[].class : DateRange.class;
            }
            case DATE_TIME: {
                return isArray ? DateTime[].class : DateTime.class;
            }
        }
        throw new RuntimeException("Unsupported property type: " + propertyType.name());
    }

    private static Property propertyFromPropertyDescriptor(PropertyDescriptor pd, Object value) throws Exception {
        if (value == null) {
            return null;
        }
        Class type = pd.getType();
        Property.PropertyType propertyType = V3ProtocolTranslator.getV3PropertyTypeFromClass(type);
        if (NO_JSON_NATIVE_PROPERTY_TYPES.contains(propertyType) || propertyType == null) {
            if (propertyType == null) {
                propertyType = Property.PropertyType.STRING;
            }
            if (value instanceof Object[]) {
                ArrayList<String> values = new ArrayList<String>();
                for (Object obj : (Object[])value) {
                    values.add(V3ValueConverter.write(obj, type.getComponentType()));
                }
                value = values;
            } else {
                value = V3ValueConverter.write(value, type);
            }
        }
        return new Property((Object)value, pd.getName(), pd.getDisplayName(), propertyType);
    }

    private static Property.PropertyType getV3PropertyTypeFromClass(Class type) {
        if (type.isArray()) {
            type = type.getComponentType();
        }
        if (String.class.isAssignableFrom(type)) {
            return Property.PropertyType.STRING;
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
            return Property.PropertyType.DOUBLE;
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
            return Property.PropertyType.DOUBLE;
        }
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
            return Property.PropertyType.BOOLEAN;
        }
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type) || BigInteger.class.isAssignableFrom(type)) {
            return Property.PropertyType.INT;
        }
        if (Date.class.isAssignableFrom(type)) {
            return Property.PropertyType.DATE;
        }
        if (DateRange.class.isAssignableFrom(type)) {
            return Property.PropertyType.DATE_RANGE;
        }
        if (DateTime.class.isAssignableFrom(type)) {
            return Property.PropertyType.DATE_TIME;
        }
        return null;
    }

    private static void tryParsingImageProp(MaltegoEntity entity) {
        if (entity.getImageExpression().isPresent()) {
            return;
        }
        PropertyDescriptorCollection props = entity.getProperties();
        for (PropertyDescriptor prop : props) {
            String valueString;
            Object value;
            if (!"base64".equals(prop.getName()) || !((value = entity.getValue(prop)) instanceof String) || !ImageUtils.isPossibleBase64Image((String)(valueString = (String)value)) || ImageUtils.getSizeInBytesEstimate((String)valueString, (boolean)true) >= 0x100000 || !ImageUtils.canDisplayBase64Image((String)valueString)) continue;
            entity.setImageExpression(prop.getName());
            break;
        }
    }
}

