/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.serializer;

import com.paterva.maltego.typing.Evaluator;
import com.paterva.maltego.typing.PhoneNumberEvaluator;

public class EvaluatorFactory {
    private static Evaluator.Replacement _replacement;
    private static PhoneNumberEvaluator _phoneNumberEval;

    public static Evaluator create(String name) {
        if ("maltego.replace".equals(name)) {
            return EvaluatorFactory.getReplacementEvaluator();
        }
        if ("maltego.phonenumber".equals(name)) {
            return EvaluatorFactory.getPhoneNumberEvaluator();
        }
        return null;
    }

    public static Evaluator createForDefaultValue(String defaultValue) {
        if (Evaluator.Replacement.isSuitableFor(defaultValue)) {
            return EvaluatorFactory.getReplacementEvaluator();
        }
        return null;
    }

    private static synchronized Evaluator getReplacementEvaluator() {
        if (_replacement == null) {
            _replacement = new Evaluator.Replacement();
        }
        return _replacement;
    }

    private static synchronized Evaluator getPhoneNumberEvaluator() {
        if (_phoneNumberEval == null) {
            _phoneNumberEval = new PhoneNumberEvaluator();
        }
        return _phoneNumberEval;
    }
}

