/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.detailview.inspect;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.detailview.inspect.InspectBackPanel;
import com.paterva.maltego.graph.selection.GraphSelection;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Inspector {
    private static final Logger LOG = Logger.getLogger(Inspector.class.getName());
    private final GraphID _graphID;
    private EntityID _inspectedEntityID;
    private LinkID _inspectedLinkID;
    private Collection<EntityID> _previousEntitySelections;
    private Collection<LinkID> _previousLinkSelections;
    private InspectBackPanel _backButton;

    public Inspector(GraphID graphID) {
        this._graphID = graphID;
    }

    public void inspect(EntityID entityID) {
        LOG.log(Level.FINE, "Inspecting {0}", entityID);
        this._inspectedEntityID = entityID;
        final GraphSelection selection = GraphSelection.forGraph((GraphID)this._graphID);
        this._previousEntitySelections = selection.getSelectedModelEntities();
        selection.setSelectedModelEntities(Collections.singleton(entityID));
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GraphSelection selectionNew = GraphSelection.forGraph((GraphID)Inspector.this._graphID);
                Set selectedModelEntities = selectionNew.getSelectedModelEntities();
                if (selectedModelEntities.size() != 1 || !selectedModelEntities.contains(Inspector.this._inspectedEntityID)) {
                    Inspector.this._inspectedEntityID = null;
                    Inspector.this._previousEntitySelections = null;
                    selection.removePropertyChangeListener((PropertyChangeListener)this);
                    Inspector.this.getBackButton().updateVisible();
                }
            }
        };
        selection.addPropertyChangeListener(listener);
    }

    public void inspect(LinkID linkID) {
        LOG.log(Level.FINE, "Inspecting {0}", linkID);
        this._inspectedLinkID = linkID;
        final GraphSelection selection = GraphSelection.forGraph((GraphID)this._graphID);
        this._previousLinkSelections = selection.getSelectedModelLinks();
        selection.setSelectedModelLinks(Collections.singleton(linkID));
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GraphSelection selectionNew = GraphSelection.forGraph((GraphID)Inspector.this._graphID);
                Set selectedModelLinks = selectionNew.getSelectedModelLinks();
                if (selectedModelLinks.size() != 1 || !selectedModelLinks.contains(Inspector.this._inspectedLinkID)) {
                    Inspector.this._inspectedLinkID = null;
                    Inspector.this._previousLinkSelections = null;
                    selection.removePropertyChangeListener((PropertyChangeListener)this);
                    Inspector.this.getBackButton().updateVisible();
                }
            }
        };
        selection.addPropertyChangeListener(listener);
    }

    public Guid getInspectedID() {
        return this._inspectedEntityID != null ? this._inspectedEntityID : this._inspectedLinkID;
    }

    public void back() {
        if (this._previousEntitySelections != null) {
            LOG.log(Level.FINE, "Restoring entity selection ({0})", this._previousEntitySelections);
            Collection<EntityID> selection = this._previousEntitySelections;
            this._previousEntitySelections = null;
            GraphSelection.forGraph((GraphID)this._graphID).setSelectedModelEntities(selection);
        } else if (this._previousLinkSelections != null) {
            LOG.log(Level.FINE, "Restoring link selection ({0})", this._previousLinkSelections);
            Collection<LinkID> selection = this._previousLinkSelections;
            this._previousLinkSelections = null;
            GraphSelection.forGraph((GraphID)this._graphID).setSelectedModelLinks(selection);
        }
    }

    public boolean canBack() {
        boolean canBackEntity = this._previousEntitySelections != null && this._previousEntitySelections.size() > 1;
        boolean canBackLink = this._previousLinkSelections != null && this._previousLinkSelections.size() > 1;
        boolean canBack = canBackEntity || canBackLink;
        LOG.log(Level.FINE, "Can back: {0}", canBack);
        return canBack;
    }

    public InspectBackPanel getBackButton() {
        if (this._backButton == null) {
            this._backButton = new InspectBackPanel(this);
        }
        return this._backButton;
    }
}

