/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.store.views.impl;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.store.data.GraphDataMods;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.views.impl.CollectStrategy;
import com.paterva.maltego.graph.store.views.impl.ModelSnapshotData;
import com.paterva.maltego.graph.store.views.impl.structures.EntityLinks;
import com.paterva.maltego.graph.store.views.impl.structures.ViewEntity;
import com.paterva.maltego.graph.store.views.impl.structures.ViewLink;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

class CollectionSnapshotWrapper
implements CollectStrategy {
    private final CollectStrategy _collectionRule;
    private Map<EntityID, EntityLinks> _newEntitySnapshot;
    private Map<LinkID, LinkEntityIDs> _newLinkSnapshot;
    private Map<EntityID, Boolean> _modelEntitiesToCollectPinnedStatus;
    private Map<EntityID, MaltegoEntity> _modelEntitiesToCollectEntitySkeletons;
    private Map<EntityID, String> _modelEntityTypeCache;
    private int _minEntityCountForCollection;
    private ModelSnapshotData _newMsd;

    CollectionSnapshotWrapper(CollectStrategy rule) {
        this._collectionRule = rule;
    }

    private void createNewShapshot(ModelSnapshotData msd, Map<EntityID, EntityLinks> entities, Map<LinkID, LinkEntityIDs> links) throws GraphStoreException {
        Map<EntityID, ViewEntity> collectionViewEntities = msd.getCollectedViewEntities();
        Map<LinkID, ViewLink> collectedViewLinks = msd.getCollectedViewLinks();
        this._newEntitySnapshot = new HashMap<EntityID, EntityLinks>(entities.size() + collectionViewEntities.size());
        this._newLinkSnapshot = new HashMap<LinkID, LinkEntityIDs>(links);
        this._modelEntitiesToCollectPinnedStatus = new HashMap<EntityID, Boolean>(entities.size() + collectionViewEntities.size());
        this._modelEntitiesToCollectEntitySkeletons = new HashMap<EntityID, MaltegoEntity>(entities.size() + collectionViewEntities.size());
        this._modelEntityTypeCache = new HashMap<EntityID, String>(entities.size() + collectionViewEntities.size());
        this._minEntityCountForCollection = msd.getMinEntityCountForCollection(null);
        for (Map.Entry<EntityID, EntityLinks> entry : entities.entrySet()) {
            EntityID modelEntity = entry.getKey();
            EntityLinks entLinks = entry.getValue();
            Set<LinkID> viewIncomingLinks = entLinks.getViewIncomingLinks();
            Set<LinkID> viewOutgoingLinks = entLinks.getViewOutgoingLinks();
            EntityLinks newEntLinks = new EntityLinks(new HashSet<LinkID>(viewIncomingLinks), new HashSet<LinkID>(viewOutgoingLinks), new HashSet<LinkID>(viewIncomingLinks), new HashSet<LinkID>(viewOutgoingLinks));
            this._newEntitySnapshot.put(modelEntity, newEntLinks);
            this._modelEntitiesToCollectPinnedStatus.put(modelEntity, msd.isEntityPinned(modelEntity));
            this._modelEntitiesToCollectEntitySkeletons.put(modelEntity, msd.getEntitySkeleton(modelEntity));
            this._modelEntityTypeCache.put(modelEntity, msd.getEntityType(modelEntity));
        }
        for (Map.Entry<EntityID, Object> entry : collectionViewEntities.entrySet()) {
            EntityID collectionEntity = entry.getKey();
            ViewEntity viewEntity = (ViewEntity)entry.getValue();
            EntityLinks entLinks = viewEntity.getAllLinks();
            Set<LinkID> viewIncomingLinks = entLinks.getViewIncomingLinks();
            Set<LinkID> viewOutgoingLinks = entLinks.getViewOutgoingLinks();
            EntityLinks newEntLinks = new EntityLinks(viewIncomingLinks, viewOutgoingLinks, viewIncomingLinks, viewOutgoingLinks);
            this._newEntitySnapshot.put(collectionEntity, newEntLinks);
            this._modelEntitiesToCollectPinnedStatus.put(collectionEntity, true);
            this._modelEntitiesToCollectEntitySkeletons.put(collectionEntity, null);
            this._modelEntityTypeCache.put(collectionEntity, viewEntity.getType());
        }
        for (Map.Entry<EntityID, Object> entry : collectedViewLinks.entrySet()) {
            LinkID collectionLink = (LinkID)entry.getKey();
            ViewLink viewLink = (ViewLink)entry.getValue();
            this._newLinkSnapshot.put(collectionLink, viewLink.getEntities());
        }
        this._newMsd = new ModelSnapshotData(this._modelEntitiesToCollectPinnedStatus, this._modelEntitiesToCollectEntitySkeletons, this._modelEntityTypeCache, this._minEntityCountForCollection, collectionViewEntities.keySet(), collectedViewLinks.keySet(), msd.isRecollectingEntireGraph(), ModelSnapshotData.deepCopySnapshotEntities(this._newEntitySnapshot), ModelSnapshotData.deepCopySnapshotLinks(this._newLinkSnapshot));
    }

    private void updateEntitiesAndLinks(Map<EntityID, EntityLinks> entities, Map<LinkID, LinkEntityIDs> links) {
        Iterator<EntityID> entIterator = entities.keySet().iterator();
        while (entIterator.hasNext()) {
            EntityID key = entIterator.next();
            EntityLinks entLinksNew = this._newEntitySnapshot.get(key);
            if (entLinksNew == null) {
                entIterator.remove();
                continue;
            }
            EntityLinks entLinksToModify = entities.get(key);
            entLinksToModify.clearView();
            entLinksToModify.getViewIncomingLinks().addAll(entLinksNew.getViewIncomingLinks());
            entLinksToModify.getViewOutgoingLinks().addAll(entLinksNew.getViewOutgoingLinks());
        }
        Iterator<LinkID> linkIterator = links.keySet().iterator();
        while (linkIterator.hasNext()) {
            LinkID key = linkIterator.next();
            LinkEntityIDs newLinkIds = this._newLinkSnapshot.get(key);
            if (newLinkIds != null) continue;
            linkIterator.remove();
        }
    }

    private Map<LinkID, ViewLink> deepCopyViewLinks(Map<LinkID, ViewLink> links) {
        HashMap<LinkID, ViewLink> map = new HashMap<LinkID, ViewLink>(links.size());
        for (Map.Entry<LinkID, ViewLink> entry : links.entrySet()) {
            LinkID key = entry.getKey();
            ViewLink value = entry.getValue();
            map.put(key, new ViewLink(value));
        }
        return map;
    }

    private Map<EntityID, ViewEntity> deepCopyViewEntities(Map<EntityID, ViewEntity> entities) {
        HashMap<EntityID, ViewEntity> map = new HashMap<EntityID, ViewEntity>(entities.size());
        for (Map.Entry<EntityID, ViewEntity> entry : entities.entrySet()) {
            EntityID key = entry.getKey();
            ViewEntity value = entry.getValue();
            map.put(key, new ViewEntity(value));
        }
        return map;
    }

    private void updateMsd(ModelSnapshotData msd) {
        LinkedList<EntityID> toRemove;
        HashSet<Object> toAdd;
        Set<EntityID> collection;
        Map<EntityID, ViewEntity> newCVE = this._newMsd.getCollectedViewEntities();
        Map<LinkID, ViewLink> newCVL = this._newMsd.getCollectedViewLinks();
        Map<EntityID, ViewEntity> cve = this.deepCopyViewEntities(msd.getCollectedViewEntities());
        Map<LinkID, ViewLink> cvl = this.deepCopyViewLinks(msd.getCollectedViewLinks());
        for (Map.Entry<EntityID, ViewEntity> entry : newCVE.entrySet()) {
            ViewLink innerViewLink;
            EntityID ent = entry.getKey();
            ViewEntity viewEnt = entry.getValue();
            if (viewEnt == null) {
                if (cve.containsKey(ent)) continue;
                throw new IllegalStateException("Wrapped rule tried to reuse a Collection EntityID " + ent + " that was already reused by a previous rule");
            }
            collection = viewEnt.getCollection();
            toAdd = new HashSet<Object>();
            toRemove = new LinkedList<EntityID>();
            for (EntityID entityID : collection) {
                ViewEntity innerViewEnt = cve.get(entityID);
                if (innerViewEnt == null) continue;
                toRemove.add(entityID);
                toAdd.addAll(innerViewEnt.getCollection());
            }
            collection.removeAll(toRemove);
            collection.addAll(toAdd);
            msd.removeCollectedViewEntities(toRemove);
            msd.removeCollectedViewEntity(ent);
            msd.addToCollectedViewEntities(ent, viewEnt);
            EntityLinks linksToModify = viewEnt.getAllLinks();
            Set<LinkID> set = linksToModify.getModelIncomingLinks();
            Set<LinkID> modelOutgoingLinksToModify = linksToModify.getModelOutgoingLinks();
            HashSet<LinkID> incomingLinksToAdd = new HashSet<LinkID>();
            LinkedList<LinkID> incomingLinksToRemove = new LinkedList<LinkID>();
            HashSet<LinkID> outgoingLinksToAdd = new HashSet<LinkID>();
            LinkedList<LinkID> outgoingLinksToRemove = new LinkedList<LinkID>();
            for (LinkID modelIncomingLink : set) {
                innerViewLink = cvl.get(modelIncomingLink);
                if (innerViewLink == null) continue;
                incomingLinksToRemove.add(modelIncomingLink);
                incomingLinksToAdd.addAll(innerViewLink.getCollection());
            }
            for (LinkID modelOutgoingLink : modelOutgoingLinksToModify) {
                innerViewLink = cvl.get(modelOutgoingLink);
                if (innerViewLink == null) continue;
                outgoingLinksToRemove.add(modelOutgoingLink);
                outgoingLinksToAdd.addAll(innerViewLink.getCollection());
            }
            set.removeAll(incomingLinksToRemove);
            set.addAll(incomingLinksToAdd);
            modelOutgoingLinksToModify.removeAll(outgoingLinksToRemove);
            modelOutgoingLinksToModify.addAll(outgoingLinksToAdd);
        }
        for (Map.Entry<Object, Object> entry : newCVL.entrySet()) {
            LinkID link = (LinkID)entry.getKey();
            ViewLink viewLink = (ViewLink)entry.getValue();
            if (viewLink == null) {
                if (cvl.containsKey(link)) continue;
                throw new IllegalStateException("Wrapped rule tried to reuse a Collection LinkID " + link + " that was already reused by a previous rule");
            }
            collection = viewLink.getCollection();
            toAdd = new HashSet();
            toRemove = new LinkedList();
            for (LinkID linkID : collection) {
                ViewLink innerViewLink = cvl.get(linkID);
                if (innerViewLink == null) continue;
                toRemove.add((EntityID)linkID);
                toAdd.addAll(innerViewLink.getCollection());
            }
            collection.removeAll(toRemove);
            collection.addAll(toAdd);
            msd.removeCollectedViewLinks(toRemove);
            msd.removeCollectedViewLink(link);
            msd.addToCollectedViewLinks(link, viewLink);
        }
    }

    @Override
    public void collect(ModelSnapshotData msd, Map<EntityID, EntityLinks> entities, Map<LinkID, LinkEntityIDs> links) throws GraphStoreException {
        this.createNewShapshot(msd, entities, links);
        this._collectionRule.collect(this._newMsd, this._newEntitySnapshot, this._newLinkSnapshot);
        this.updateEntitiesAndLinks(entities, links);
        this.updateMsd(msd);
    }

    @Override
    public Set<EntityID> determineTouchedViewEntities(GraphStructureMods imsm, GraphDataMods imdm) throws GraphStoreException {
        return this._collectionRule.determineTouchedViewEntities(imsm, imdm);
    }
}

