/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.ctxmenu;

import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.ui.button.ButtonPainter;
import com.paterva.maltego.util.ui.ctxmenu.WindowPopupManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

final class ContextActionButton
extends JButton {
    private static final int ICON_SIZE = IconSize.TINY.getSize();
    public static final int BUTTON_WIDTH = ICON_SIZE + 4;
    public static final int BUTTON_HEIGHT = ICON_SIZE + 2 + 4;
    private ImageIcon _icon;
    private ImageIcon _disabledIcon;
    private final boolean _isPopup;
    private JMenu _menu;
    private final Action _action;

    public ContextActionButton(Action action) {
        this._action = action;
        this.setText("");
        Dimension dim = new Dimension(BUTTON_WIDTH, BUTTON_HEIGHT);
        this.setMinimumSize(dim);
        this.setMaximumSize(dim);
        this.setPreferredSize(dim);
        this.setOpaque(false);
        this.setToolTipText(this.getName());
        this.setRolloverEnabled(true);
        this.setFocusPainted(false);
        this.setBorderPainted(false);
        this._menu = this.getMenu();
        this._isPopup = this._menu != null;
        this.addMouseListener(new PopupMouseListener());
    }

    @Override
    public String getName() {
        return this._action != null ? ((SystemAction)this._action).getName().replace("&", "") : "";
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        int x = 0;
        int y = 0;
        int width = this.getWidth();
        int height = this.getHeight();
        if (!this._isPopup) {
            height -= 3;
        }
        g2d.setClip(0, 0, width, height);
        boolean isPressed = this.getModel().isPressed();
        boolean isSelected = this.getModel().isSelected();
        boolean isRollover = this.getModel().isRollover();
        boolean isEnabled = this._action.isEnabled();
        boolean isFlat = true;
        if (isEnabled) {
            if (isPressed) {
                ButtonPainter.paintBigPressedBackground(g2d, x, y, width, height);
            } else if (isSelected) {
                ButtonPainter.paintBigSelectedBackground(g2d, x, y, width, height, false);
            } else if (isRollover) {
                ButtonPainter.paintBigRolloverBackground(g2d, x, y, width, height, false, isEnabled);
            } else if (!isFlat) {
                ButtonPainter.paintNormalBackground(g2d, x, y, width, height);
            }
        }
        g2d.setClip(0, 0, this.getWidth(), this.getHeight());
        ImageIcon icon = this.getIcon(isEnabled);
        if (icon != null) {
            icon.paintIcon(this, g2d, 2, 1);
        }
        if (this._isPopup) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(UIManager.getLookAndFeelDefaults().getColor("ctx-menu-actions-popup-indicator-color"));
            int xCenter = BUTTON_WIDTH / 2;
            int[] xPoints = new int[]{xCenter - 3, xCenter + 3, xCenter};
            int[] yPoints = new int[]{BUTTON_HEIGHT - 4, BUTTON_HEIGHT - 4, BUTTON_HEIGHT};
            g2d.fillPolygon(xPoints, yPoints, xPoints.length);
        }
        g2d.dispose();
    }

    @Override
    public Icon getIcon() {
        return this._action != null ? this.getIcon(this._action.isEnabled()) : null;
    }

    public ImageIcon getIcon(boolean enabled) {
        return enabled ? this.getIconNormal() : this.getIconDisabled();
    }

    public ImageIcon getIconDisabled() {
        ImageIcon icon;
        if (this._disabledIcon == null && (icon = this.getIconNormal()) != null) {
            ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
            BufferedImage srcImg = ImageUtils.createBufferedImage((Image)icon.getImage());
            BufferedImage dstImg = op.createCompatibleDestImage(srcImg, null);
            op.filter(srcImg, dstImg);
            this._disabledIcon = new ImageIcon(dstImg);
        }
        return this._disabledIcon;
    }

    public ImageIcon getIconNormal() {
        if (this._icon == null) {
            this._icon = this.getImageIcon();
        }
        return this._icon;
    }

    private ImageIcon getImageIcon() {
        SystemAction sysAction;
        Object obj;
        ImageIcon imgIcon = null;
        if (this._action instanceof SystemAction && (obj = (sysAction = (SystemAction)this._action).getValue("iconBase")) instanceof String) {
            String iconPath = (String)obj;
            if (ICON_SIZE != IconSize.TINY.getSize()) {
                iconPath = FileUtilities.insertBeforeSuffix((String)iconPath, (String)Integer.toString(ICON_SIZE));
            }
            imgIcon = ImageUtilities.loadImageIcon((String)iconPath, (boolean)true);
        }
        return imgIcon;
    }

    private JMenu getMenu() {
        Presenter.Popup popupAction;
        JMenuItem menuItem;
        if (this._menu == null && this._action instanceof Presenter.Popup && (menuItem = (popupAction = (Presenter.Popup)this._action).getPopupPresenter()) instanceof JMenu) {
            this._menu = (JMenu)menuItem;
        }
        return this._menu;
    }

    private void log(String str) {
        if (this.getName().contains("Change")) {
            System.out.println(str);
        }
    }

    private void onClicked(MouseEvent e) {
        if (this._isPopup) {
            Component[] components = this.getMenu().getMenuComponents();
            if (components.length > 0) {
                this._menu = null;
                JPopupMenu popup = new JPopupMenu();
                for (Component component : components) {
                    popup.add(component);
                }
                popup.show(this, e.getX(), e.getY());
                popup.addPopupMenuListener(new PopupCloseListener());
            }
        } else if (this._action.isEnabled()) {
            WindowPopupManager.getInstance().close();
            this._action.actionPerformed(null);
        }
    }

    private class PopupCloseListener
    implements PopupMenuListener {
        private boolean _cancelled = false;

        private PopupCloseListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (!this._cancelled) {
                WindowPopupManager.getInstance().close();
            }
            ((JPopupMenu)e.getSource()).removePopupMenuListener(this);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this._cancelled = true;
        }
    }

    private class PopupMouseListener
    extends MouseAdapter {
        private PopupMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ContextActionButton.this.onClicked(e);
        }
    }
}

