/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.tabular.transforms.run.v2;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.graph.store.GraphFactory;
import com.paterva.maltego.graph.table.MappingRegistry;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.tabular.transforms.run.v2.AbstractTabularTransformRunnerV2;
import com.paterva.maltego.tabular.transforms.run.v2.graph.TabularTransformSearchGraphBuilderV2;
import com.paterva.maltego.transform.descriptor.TransformDescriptor;
import com.paterva.maltego.transforms.tabular.data.TabularTransformSource;
import com.paterva.maltego.util.Args;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.netbeans.api.progress.ProgressHandle;

public class TabularTransformSearchRunnerV2
extends AbstractTabularTransformRunnerV2 {
    private final TabularTransformSource transformSource;

    public TabularTransformSearchRunnerV2(GraphID graphID, EntityFactory factory, EntityRegistry registry, TransformDescriptor transform, TabularTransformSource searchTransformSource) {
        super(graphID, factory, registry, transform);
        Args.notNull((Object)graphID, (String)"graphID");
        Args.notNull((Object)factory, (String)"factory");
        Args.notNull((Object)registry, (String)"registry");
        Args.notNull((Object)transform, (String)"transform");
        Args.notNull((Object)searchTransformSource, (String)"searchTransformSource");
        this.transformSource = searchTransformSource;
    }

    @Override
    protected Set<MaltegoEntity> runTransform(MaltegoEntity inputEntity, ProgressHandle handle) throws Exception {
        Args.notNull((Object)inputEntity, (String)"inputEntity");
        Args.notNull((Object)handle, (String)"handle");
        TabularGraph mappings = MappingRegistry.getDefault().get(this.transformSource.getTabularGraphName());
        List<File> files = this.getFiles(this.transformSource);
        GraphID newGraphID = GraphFactory.getDefault().createInvisibleInMemoryGraph();
        TabularTransformSearchGraphBuilderV2 builder = new TabularTransformSearchGraphBuilderV2(newGraphID, mappings, files, handle, inputEntity);
        builder.build();
        return GraphStoreHelper.getMaltegoEntities((GraphID)newGraphID);
    }
}

