// Code generated by go generate; DO NOT EDIT.
package launchdarkly

import "errors"

type Permission int

const (
    Invalid Permission = iota
    Admin Permission = iota
    Writer Permission = iota
    Reader Permission = iota
    Inlinepolicy Permission = iota
    Customroles Permission = iota
)

var (
    PermissionStrings = map[Permission]string{
        Admin: "admin",
        Writer: "writer",
        Reader: "reader",
        Inlinepolicy: "inlinepolicy",
        Customroles: "customroles",
    }

    StringToPermission = map[string]Permission{
        "admin": Admin,
        "writer": Writer,
        "reader": Reader,
        "inlinepolicy": Inlinepolicy,
        "customroles": Customroles,
    }

    PermissionIDs = map[Permission]int{
        Admin: 1,
        Writer: 2,
        Reader: 3,
        Inlinepolicy: 4,
        Customroles: 5,
    }

    IdToPermission = map[int]Permission{
        1: Admin,
        2: Writer,
        3: Reader,
        4: Inlinepolicy,
        5: Customroles,
    }
)

// ToString converts a Permission enum to its string representation
func (p Permission) ToString() (string, error) {
    if str, ok := PermissionStrings[p]; ok {
        return str, nil
    }
    return "", errors.New("invalid permission")
}

// ToID converts a Permission enum to its ID
func (p Permission) ToID() (int, error) {
    if id, ok := PermissionIDs[p]; ok {
        return id, nil
    }
    return 0, errors.New("invalid permission")
}

// PermissionFromString converts a string representation to its Permission enum
func PermissionFromString(s string) (Permission, error) {
    if p, ok := StringToPermission[s]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission string")
}

// PermissionFromID converts an ID to its Permission enum
func PermissionFromID(id int) (Permission, error) {
    if p, ok := IdToPermission[id]; ok {
        return p, nil
    }
    return 0, errors.New("invalid permission ID")
}
