// Code generated by re2go, DO NOT EDIT.
//go:generate re2go -c $INPUT -o $OUTPUT -i --api simple
package main

import "errors"

var (
	eSyntax   = errors.New("syntax error")
	eOverflow = errors.New("overflow error")
)

const (
	yycinit = iota
	yycbin
	yycdec
	yychex
	yycoct
)


const u32Limit uint64 = 1<<32

func parse_u32(yyinput string) (uint32, error) {
	var yycursor, yymarker int
	result := uint64(0)
	yycond := yycinit

	add := func(base uint64, offset byte) {
		result = result * base + uint64(yyinput[yycursor-1] - offset)
		if result >= u32Limit {
			result = u32Limit
		}
	}

	
{
	var yych byte
	switch (yycond) {
	case yycinit:
		goto yyc_init
	case yycbin:
		goto yyc_bin
	case yycdec:
		goto yyc_dec
	case yychex:
		goto yyc_hex
	case yycoct:
		goto yyc_oct
	default:
		panic("internal lexer error")
	}
/* *********************************** */
yyc_init:
	yych = yyinput[yycursor]
	switch (yych) {
	case '0':
		goto yy2
	case '1','2','3','4','5','6','7','8','9':
		goto yy4
	default:
		goto yy1
	}
yy1:
	yycursor += 1
	{ return 0, eSyntax }
yy2:
	yycursor += 1
	yymarker = yycursor
	yych = yyinput[yycursor]
	switch (yych) {
	case 'B':
		fallthrough
	case 'b':
		goto yy5
	case 'X':
		fallthrough
	case 'x':
		goto yy7
	default:
		goto yy3
	}
yy3:
	yycond = yycoct
	goto yyc_oct
yy4:
	yycursor += 1
	yycursor -= 1
	yycond = yycdec
	goto yyc_dec
yy5:
	yycursor += 1
	yych = yyinput[yycursor]
	switch (yych) {
	case '0','1':
		goto yy8
	default:
		goto yy6
	}
yy6:
	yycursor = yymarker
	goto yy3
yy7:
	yycursor += 1
	yych = yyinput[yycursor]
	switch (yych) {
	case '0','1','2','3','4','5','6','7','8','9':
		fallthrough
	case 'A','B','C','D','E','F':
		fallthrough
	case 'a','b','c','d','e','f':
		goto yy9
	default:
		goto yy6
	}
yy8:
	yycursor += 1
	yycursor -= 1
	yycond = yycbin
	goto yyc_bin
yy9:
	yycursor += 1
	yycursor -= 1
	yycond = yychex
	goto yyc_hex
/* *********************************** */
yyc_bin:
	yych = yyinput[yycursor]
	switch (yych) {
	case 0x00:
		goto yy11
	case '0','1':
		goto yy13
	default:
		goto yy12
	}
yy11:
	yycursor += 1
	{
			if result < u32Limit {
				return uint32(result), nil
			} else {
				return 0, eOverflow
			}
		}
yy12:
	yycursor += 1
	{ return 0, eSyntax }
yy13:
	yycursor += 1
	{ add(2, '0');     goto yyc_bin }
/* *********************************** */
yyc_dec:
	yych = yyinput[yycursor]
	switch (yych) {
	case 0x00:
		goto yy15
	case '0','1','2','3','4','5','6','7','8','9':
		goto yy17
	default:
		goto yy16
	}
yy15:
	yycursor += 1
	{
			if result < u32Limit {
				return uint32(result), nil
			} else {
				return 0, eOverflow
			}
		}
yy16:
	yycursor += 1
	{ return 0, eSyntax }
yy17:
	yycursor += 1
	{ add(10, '0');    goto yyc_dec }
/* *********************************** */
yyc_hex:
	yych = yyinput[yycursor]
	switch (yych) {
	case 0x00:
		goto yy19
	case '0','1','2','3','4','5','6','7','8','9':
		goto yy21
	case 'A','B','C','D','E','F':
		goto yy22
	case 'a','b','c','d','e','f':
		goto yy23
	default:
		goto yy20
	}
yy19:
	yycursor += 1
	{
			if result < u32Limit {
				return uint32(result), nil
			} else {
				return 0, eOverflow
			}
		}
yy20:
	yycursor += 1
	{ return 0, eSyntax }
yy21:
	yycursor += 1
	{ add(16, '0');    goto yyc_hex }
yy22:
	yycursor += 1
	{ add(16, 'A'-10); goto yyc_hex }
yy23:
	yycursor += 1
	{ add(16, 'a'-10); goto yyc_hex }
/* *********************************** */
yyc_oct:
	yych = yyinput[yycursor]
	switch (yych) {
	case 0x00:
		goto yy25
	case '0','1','2','3','4','5','6','7':
		goto yy27
	default:
		goto yy26
	}
yy25:
	yycursor += 1
	{
			if result < u32Limit {
				return uint32(result), nil
			} else {
				return 0, eOverflow
			}
		}
yy26:
	yycursor += 1
	{ return 0, eSyntax }
yy27:
	yycursor += 1
	{ add(8, '0');     goto yyc_oct }
}

}

func main() {
	test := func(num uint32, str string, err error) {
		if n, e := parse_u32(str); !(n == num && e == err) {
			panic("error")
		}
	}
	test(1234567890, "1234567890\000", nil)
	test(13, "0b1101\000", nil)
	test(0x7fe, "0x007Fe\000", nil)
	test(0644, "0644\000", nil)
	test(0, "9999999999\000", eOverflow)
	test(0, "123??\000", eSyntax)
}
