# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ProxyDto(_serialization.Model):
    """Base data transfer object implementation for proxy resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.system_data = None
        self.type = None


class DefaultDto(ProxyDto):
    """Base data transfer object implementation for default resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar location: Location of the azure resource.
    :vartype location: str
    :ivar tags: Tags on the azure resource.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword location: Location of the azure resource.
        :paramtype location: str
        :keyword tags: Tags on the azure resource.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags


class Account(DefaultDto):  # pylint: disable=too-many-instance-attributes
    """An account data transfer object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar location: Location of the azure resource.
    :vartype location: str
    :ivar tags: Tags on the azure resource.
    :vartype tags: dict[str, str]
    :ivar identity: Identity Info on the Account. Required.
    :vartype identity: ~azure.mgmt.datashare.models.Identity
    :ivar created_at: Time at which the account was created.
    :vartype created_at: ~datetime.datetime
    :ivar provisioning_state: Provisioning state of the Account. Known values are: "Succeeded",
     "Creating", "Deleting", "Moving", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :ivar user_email: Email of the user who created the resource.
    :vartype user_email: str
    :ivar user_name: Name of the user who created the resource.
    :vartype user_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "identity": {"required": True},
        "created_at": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "user_email": {"readonly": True},
        "user_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "Identity"},
        "created_at": {"key": "properties.createdAt", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "user_email": {"key": "properties.userEmail", "type": "str"},
        "user_name": {"key": "properties.userName", "type": "str"},
    }

    def __init__(
        self,
        *,
        identity: "_models.Identity",
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: Location of the azure resource.
        :paramtype location: str
        :keyword tags: Tags on the azure resource.
        :paramtype tags: dict[str, str]
        :keyword identity: Identity Info on the Account. Required.
        :paramtype identity: ~azure.mgmt.datashare.models.Identity
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.identity = identity
        self.created_at = None
        self.provisioning_state = None
        self.user_email = None
        self.user_name = None


class AccountList(_serialization.Model):
    """List response for get Accounts.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: The Url of next result page.
    :vartype next_link: str
    :ivar value: Collection of items of type DataTransferObjects. Required.
    :vartype value: list[~azure.mgmt.datashare.models.Account]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Account]"},
    }

    def __init__(self, *, value: List["_models.Account"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The Url of next result page.
        :paramtype next_link: str
        :keyword value: Collection of items of type DataTransferObjects. Required.
        :paramtype value: list[~azure.mgmt.datashare.models.Account]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class AccountUpdateParameters(_serialization.Model):
    """Update parameters for accounts.

    :ivar tags: Tags on the azure resource.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Tags on the azure resource.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class DataSet(ProxyDto):
    """A DataSet data transfer object.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ADLSGen1FileDataSet, ADLSGen1FolderDataSet, ADLSGen2FileDataSet, ADLSGen2FileSystemDataSet,
    ADLSGen2FolderDataSet, BlobDataSet, BlobFolderDataSet, BlobContainerDataSet,
    KustoClusterDataSet, KustoDatabaseDataSet, SqlDBTableDataSet, SqlDWTableDataSet,
    SynapseWorkspaceSqlPoolTableDataSet

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set. Required. Known values are: "Blob", "Container", "BlobFolder",
     "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File",
     "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable", and
     "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetKind
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {
        "kind": {
            "AdlsGen1File": "ADLSGen1FileDataSet",
            "AdlsGen1Folder": "ADLSGen1FolderDataSet",
            "AdlsGen2File": "ADLSGen2FileDataSet",
            "AdlsGen2FileSystem": "ADLSGen2FileSystemDataSet",
            "AdlsGen2Folder": "ADLSGen2FolderDataSet",
            "Blob": "BlobDataSet",
            "BlobFolder": "BlobFolderDataSet",
            "Container": "BlobContainerDataSet",
            "KustoCluster": "KustoClusterDataSet",
            "KustoDatabase": "KustoDatabaseDataSet",
            "SqlDBTable": "SqlDBTableDataSet",
            "SqlDWTable": "SqlDWTableDataSet",
            "SynapseWorkspaceSqlPoolTable": "SynapseWorkspaceSqlPoolTableDataSet",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind = None  # type: Optional[str]


class ADLSGen1FileDataSet(DataSet):  # pylint: disable=too-many-instance-attributes
    """An ADLS Gen 1 file data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set. Required. Known values are: "Blob", "Container", "BlobFolder",
     "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File",
     "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable", and
     "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetKind
    :ivar account_name: The ADLS account name. Required.
    :vartype account_name: str
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :ivar file_name: The file name in the ADLS account. Required.
    :vartype file_name: str
    :ivar folder_path: The folder path within the ADLS account. Required.
    :vartype folder_path: str
    :ivar resource_group: Resource group of ADLS account. Required.
    :vartype resource_group: str
    :ivar subscription_id: Subscription id of ADLS account. Required.
    :vartype subscription_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "account_name": {"required": True},
        "data_set_id": {"readonly": True},
        "file_name": {"required": True},
        "folder_path": {"required": True},
        "resource_group": {"required": True},
        "subscription_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "account_name": {"key": "properties.accountName", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "file_name": {"key": "properties.fileName", "type": "str"},
        "folder_path": {"key": "properties.folderPath", "type": "str"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        account_name: str,
        file_name: str,
        folder_path: str,
        resource_group: str,
        subscription_id: str,
        **kwargs
    ):
        """
        :keyword account_name: The ADLS account name. Required.
        :paramtype account_name: str
        :keyword file_name: The file name in the ADLS account. Required.
        :paramtype file_name: str
        :keyword folder_path: The folder path within the ADLS account. Required.
        :paramtype folder_path: str
        :keyword resource_group: Resource group of ADLS account. Required.
        :paramtype resource_group: str
        :keyword subscription_id: Subscription id of ADLS account. Required.
        :paramtype subscription_id: str
        """
        super().__init__(**kwargs)
        self.kind = "AdlsGen1File"  # type: str
        self.account_name = account_name
        self.data_set_id = None
        self.file_name = file_name
        self.folder_path = folder_path
        self.resource_group = resource_group
        self.subscription_id = subscription_id


class ADLSGen1FolderDataSet(DataSet):
    """An ADLS Gen 1 folder data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set. Required. Known values are: "Blob", "Container", "BlobFolder",
     "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File",
     "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable", and
     "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetKind
    :ivar account_name: The ADLS account name. Required.
    :vartype account_name: str
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :ivar folder_path: The folder path within the ADLS account. Required.
    :vartype folder_path: str
    :ivar resource_group: Resource group of ADLS account. Required.
    :vartype resource_group: str
    :ivar subscription_id: Subscription id of ADLS account. Required.
    :vartype subscription_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "account_name": {"required": True},
        "data_set_id": {"readonly": True},
        "folder_path": {"required": True},
        "resource_group": {"required": True},
        "subscription_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "account_name": {"key": "properties.accountName", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "folder_path": {"key": "properties.folderPath", "type": "str"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
    }

    def __init__(self, *, account_name: str, folder_path: str, resource_group: str, subscription_id: str, **kwargs):
        """
        :keyword account_name: The ADLS account name. Required.
        :paramtype account_name: str
        :keyword folder_path: The folder path within the ADLS account. Required.
        :paramtype folder_path: str
        :keyword resource_group: Resource group of ADLS account. Required.
        :paramtype resource_group: str
        :keyword subscription_id: Subscription id of ADLS account. Required.
        :paramtype subscription_id: str
        """
        super().__init__(**kwargs)
        self.kind = "AdlsGen1Folder"  # type: str
        self.account_name = account_name
        self.data_set_id = None
        self.folder_path = folder_path
        self.resource_group = resource_group
        self.subscription_id = subscription_id


class ADLSGen2FileDataSet(DataSet):  # pylint: disable=too-many-instance-attributes
    """An ADLS Gen 2 file data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set. Required. Known values are: "Blob", "Container", "BlobFolder",
     "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File",
     "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable", and
     "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetKind
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :ivar file_path: File path within the file system. Required.
    :vartype file_path: str
    :ivar file_system: File system to which the file belongs. Required.
    :vartype file_system: str
    :ivar resource_group: Resource group of storage account. Required.
    :vartype resource_group: str
    :ivar storage_account_name: Storage account name of the source data set. Required.
    :vartype storage_account_name: str
    :ivar subscription_id: Subscription id of storage account. Required.
    :vartype subscription_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "data_set_id": {"readonly": True},
        "file_path": {"required": True},
        "file_system": {"required": True},
        "resource_group": {"required": True},
        "storage_account_name": {"required": True},
        "subscription_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "file_path": {"key": "properties.filePath", "type": "str"},
        "file_system": {"key": "properties.fileSystem", "type": "str"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "storage_account_name": {"key": "properties.storageAccountName", "type": "str"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        file_path: str,
        file_system: str,
        resource_group: str,
        storage_account_name: str,
        subscription_id: str,
        **kwargs
    ):
        """
        :keyword file_path: File path within the file system. Required.
        :paramtype file_path: str
        :keyword file_system: File system to which the file belongs. Required.
        :paramtype file_system: str
        :keyword resource_group: Resource group of storage account. Required.
        :paramtype resource_group: str
        :keyword storage_account_name: Storage account name of the source data set. Required.
        :paramtype storage_account_name: str
        :keyword subscription_id: Subscription id of storage account. Required.
        :paramtype subscription_id: str
        """
        super().__init__(**kwargs)
        self.kind = "AdlsGen2File"  # type: str
        self.data_set_id = None
        self.file_path = file_path
        self.file_system = file_system
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name
        self.subscription_id = subscription_id


class DataSetMapping(ProxyDto):
    """A data set mapping data transfer object.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ADLSGen2FileDataSetMapping, ADLSGen2FileSystemDataSetMapping, ADLSGen2FolderDataSetMapping,
    BlobDataSetMapping, BlobFolderDataSetMapping, BlobContainerDataSetMapping,
    KustoClusterDataSetMapping, KustoDatabaseDataSetMapping, SqlDBTableDataSetMapping,
    SqlDWTableDataSetMapping, SynapseWorkspaceSqlPoolTableDataSetMapping

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set mapping. Required. Known values are: "Blob", "Container",
     "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "KustoCluster",
     "KustoDatabase", "SqlDBTable", "SqlDWTable", and "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetMappingKind
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {
        "kind": {
            "AdlsGen2File": "ADLSGen2FileDataSetMapping",
            "AdlsGen2FileSystem": "ADLSGen2FileSystemDataSetMapping",
            "AdlsGen2Folder": "ADLSGen2FolderDataSetMapping",
            "Blob": "BlobDataSetMapping",
            "BlobFolder": "BlobFolderDataSetMapping",
            "Container": "BlobContainerDataSetMapping",
            "KustoCluster": "KustoClusterDataSetMapping",
            "KustoDatabase": "KustoDatabaseDataSetMapping",
            "SqlDBTable": "SqlDBTableDataSetMapping",
            "SqlDWTable": "SqlDWTableDataSetMapping",
            "SynapseWorkspaceSqlPoolTable": "SynapseWorkspaceSqlPoolTableDataSetMapping",
        }
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind = None  # type: Optional[str]


class ADLSGen2FileDataSetMapping(DataSetMapping):  # pylint: disable=too-many-instance-attributes
    """An ADLS Gen2 file data set mapping.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set mapping. Required. Known values are: "Blob", "Container",
     "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "KustoCluster",
     "KustoDatabase", "SqlDBTable", "SqlDWTable", and "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetMappingKind
    :ivar data_set_id: The id of the source data set. Required.
    :vartype data_set_id: str
    :ivar data_set_mapping_status: Gets the status of the data set mapping. Known values are: "Ok"
     and "Broken".
    :vartype data_set_mapping_status: str or ~azure.mgmt.datashare.models.DataSetMappingStatus
    :ivar file_path: File path within the file system. Required.
    :vartype file_path: str
    :ivar file_system: File system to which the file belongs. Required.
    :vartype file_system: str
    :ivar output_type: Type of output file. Known values are: "Csv" and "Parquet".
    :vartype output_type: str or ~azure.mgmt.datashare.models.OutputType
    :ivar provisioning_state: Provisioning state of the data set mapping. Known values are:
     "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :ivar resource_group: Resource group of storage account. Required.
    :vartype resource_group: str
    :ivar storage_account_name: Storage account name of the source data set. Required.
    :vartype storage_account_name: str
    :ivar subscription_id: Subscription id of storage account. Required.
    :vartype subscription_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "data_set_id": {"required": True},
        "data_set_mapping_status": {"readonly": True},
        "file_path": {"required": True},
        "file_system": {"required": True},
        "provisioning_state": {"readonly": True},
        "resource_group": {"required": True},
        "storage_account_name": {"required": True},
        "subscription_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "data_set_mapping_status": {"key": "properties.dataSetMappingStatus", "type": "str"},
        "file_path": {"key": "properties.filePath", "type": "str"},
        "file_system": {"key": "properties.fileSystem", "type": "str"},
        "output_type": {"key": "properties.outputType", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "storage_account_name": {"key": "properties.storageAccountName", "type": "str"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        data_set_id: str,
        file_path: str,
        file_system: str,
        resource_group: str,
        storage_account_name: str,
        subscription_id: str,
        output_type: Optional[Union[str, "_models.OutputType"]] = None,
        **kwargs
    ):
        """
        :keyword data_set_id: The id of the source data set. Required.
        :paramtype data_set_id: str
        :keyword file_path: File path within the file system. Required.
        :paramtype file_path: str
        :keyword file_system: File system to which the file belongs. Required.
        :paramtype file_system: str
        :keyword output_type: Type of output file. Known values are: "Csv" and "Parquet".
        :paramtype output_type: str or ~azure.mgmt.datashare.models.OutputType
        :keyword resource_group: Resource group of storage account. Required.
        :paramtype resource_group: str
        :keyword storage_account_name: Storage account name of the source data set. Required.
        :paramtype storage_account_name: str
        :keyword subscription_id: Subscription id of storage account. Required.
        :paramtype subscription_id: str
        """
        super().__init__(**kwargs)
        self.kind = "AdlsGen2File"  # type: str
        self.data_set_id = data_set_id
        self.data_set_mapping_status = None
        self.file_path = file_path
        self.file_system = file_system
        self.output_type = output_type
        self.provisioning_state = None
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name
        self.subscription_id = subscription_id


class ADLSGen2FileSystemDataSet(DataSet):
    """An ADLS Gen 2 file system data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set. Required. Known values are: "Blob", "Container", "BlobFolder",
     "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File",
     "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable", and
     "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetKind
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :ivar file_system: The file system name. Required.
    :vartype file_system: str
    :ivar resource_group: Resource group of storage account. Required.
    :vartype resource_group: str
    :ivar storage_account_name: Storage account name of the source data set. Required.
    :vartype storage_account_name: str
    :ivar subscription_id: Subscription id of storage account. Required.
    :vartype subscription_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "data_set_id": {"readonly": True},
        "file_system": {"required": True},
        "resource_group": {"required": True},
        "storage_account_name": {"required": True},
        "subscription_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "file_system": {"key": "properties.fileSystem", "type": "str"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "storage_account_name": {"key": "properties.storageAccountName", "type": "str"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
    }

    def __init__(
        self, *, file_system: str, resource_group: str, storage_account_name: str, subscription_id: str, **kwargs
    ):
        """
        :keyword file_system: The file system name. Required.
        :paramtype file_system: str
        :keyword resource_group: Resource group of storage account. Required.
        :paramtype resource_group: str
        :keyword storage_account_name: Storage account name of the source data set. Required.
        :paramtype storage_account_name: str
        :keyword subscription_id: Subscription id of storage account. Required.
        :paramtype subscription_id: str
        """
        super().__init__(**kwargs)
        self.kind = "AdlsGen2FileSystem"  # type: str
        self.data_set_id = None
        self.file_system = file_system
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name
        self.subscription_id = subscription_id


class ADLSGen2FileSystemDataSetMapping(DataSetMapping):  # pylint: disable=too-many-instance-attributes
    """An ADLS Gen2 file system data set mapping.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set mapping. Required. Known values are: "Blob", "Container",
     "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "KustoCluster",
     "KustoDatabase", "SqlDBTable", "SqlDWTable", and "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetMappingKind
    :ivar data_set_id: The id of the source data set. Required.
    :vartype data_set_id: str
    :ivar data_set_mapping_status: Gets the status of the data set mapping. Known values are: "Ok"
     and "Broken".
    :vartype data_set_mapping_status: str or ~azure.mgmt.datashare.models.DataSetMappingStatus
    :ivar file_system: The file system name. Required.
    :vartype file_system: str
    :ivar provisioning_state: Provisioning state of the data set mapping. Known values are:
     "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :ivar resource_group: Resource group of storage account. Required.
    :vartype resource_group: str
    :ivar storage_account_name: Storage account name of the source data set. Required.
    :vartype storage_account_name: str
    :ivar subscription_id: Subscription id of storage account. Required.
    :vartype subscription_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "data_set_id": {"required": True},
        "data_set_mapping_status": {"readonly": True},
        "file_system": {"required": True},
        "provisioning_state": {"readonly": True},
        "resource_group": {"required": True},
        "storage_account_name": {"required": True},
        "subscription_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "data_set_mapping_status": {"key": "properties.dataSetMappingStatus", "type": "str"},
        "file_system": {"key": "properties.fileSystem", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "storage_account_name": {"key": "properties.storageAccountName", "type": "str"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        data_set_id: str,
        file_system: str,
        resource_group: str,
        storage_account_name: str,
        subscription_id: str,
        **kwargs
    ):
        """
        :keyword data_set_id: The id of the source data set. Required.
        :paramtype data_set_id: str
        :keyword file_system: The file system name. Required.
        :paramtype file_system: str
        :keyword resource_group: Resource group of storage account. Required.
        :paramtype resource_group: str
        :keyword storage_account_name: Storage account name of the source data set. Required.
        :paramtype storage_account_name: str
        :keyword subscription_id: Subscription id of storage account. Required.
        :paramtype subscription_id: str
        """
        super().__init__(**kwargs)
        self.kind = "AdlsGen2FileSystem"  # type: str
        self.data_set_id = data_set_id
        self.data_set_mapping_status = None
        self.file_system = file_system
        self.provisioning_state = None
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name
        self.subscription_id = subscription_id


class ADLSGen2FolderDataSet(DataSet):  # pylint: disable=too-many-instance-attributes
    """An ADLS Gen 2 folder data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set. Required. Known values are: "Blob", "Container", "BlobFolder",
     "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File",
     "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable", and
     "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetKind
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :ivar file_system: File system to which the folder belongs. Required.
    :vartype file_system: str
    :ivar folder_path: Folder path within the file system. Required.
    :vartype folder_path: str
    :ivar resource_group: Resource group of storage account. Required.
    :vartype resource_group: str
    :ivar storage_account_name: Storage account name of the source data set. Required.
    :vartype storage_account_name: str
    :ivar subscription_id: Subscription id of storage account. Required.
    :vartype subscription_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "data_set_id": {"readonly": True},
        "file_system": {"required": True},
        "folder_path": {"required": True},
        "resource_group": {"required": True},
        "storage_account_name": {"required": True},
        "subscription_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "file_system": {"key": "properties.fileSystem", "type": "str"},
        "folder_path": {"key": "properties.folderPath", "type": "str"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "storage_account_name": {"key": "properties.storageAccountName", "type": "str"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        file_system: str,
        folder_path: str,
        resource_group: str,
        storage_account_name: str,
        subscription_id: str,
        **kwargs
    ):
        """
        :keyword file_system: File system to which the folder belongs. Required.
        :paramtype file_system: str
        :keyword folder_path: Folder path within the file system. Required.
        :paramtype folder_path: str
        :keyword resource_group: Resource group of storage account. Required.
        :paramtype resource_group: str
        :keyword storage_account_name: Storage account name of the source data set. Required.
        :paramtype storage_account_name: str
        :keyword subscription_id: Subscription id of storage account. Required.
        :paramtype subscription_id: str
        """
        super().__init__(**kwargs)
        self.kind = "AdlsGen2Folder"  # type: str
        self.data_set_id = None
        self.file_system = file_system
        self.folder_path = folder_path
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name
        self.subscription_id = subscription_id


class ADLSGen2FolderDataSetMapping(DataSetMapping):  # pylint: disable=too-many-instance-attributes
    """An ADLS Gen2 folder data set mapping.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set mapping. Required. Known values are: "Blob", "Container",
     "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "KustoCluster",
     "KustoDatabase", "SqlDBTable", "SqlDWTable", and "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetMappingKind
    :ivar data_set_id: The id of the source data set. Required.
    :vartype data_set_id: str
    :ivar data_set_mapping_status: Gets the status of the data set mapping. Known values are: "Ok"
     and "Broken".
    :vartype data_set_mapping_status: str or ~azure.mgmt.datashare.models.DataSetMappingStatus
    :ivar file_system: File system to which the folder belongs. Required.
    :vartype file_system: str
    :ivar folder_path: Folder path within the file system. Required.
    :vartype folder_path: str
    :ivar provisioning_state: Provisioning state of the data set mapping. Known values are:
     "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :ivar resource_group: Resource group of storage account. Required.
    :vartype resource_group: str
    :ivar storage_account_name: Storage account name of the source data set. Required.
    :vartype storage_account_name: str
    :ivar subscription_id: Subscription id of storage account. Required.
    :vartype subscription_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "data_set_id": {"required": True},
        "data_set_mapping_status": {"readonly": True},
        "file_system": {"required": True},
        "folder_path": {"required": True},
        "provisioning_state": {"readonly": True},
        "resource_group": {"required": True},
        "storage_account_name": {"required": True},
        "subscription_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "data_set_mapping_status": {"key": "properties.dataSetMappingStatus", "type": "str"},
        "file_system": {"key": "properties.fileSystem", "type": "str"},
        "folder_path": {"key": "properties.folderPath", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "storage_account_name": {"key": "properties.storageAccountName", "type": "str"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        data_set_id: str,
        file_system: str,
        folder_path: str,
        resource_group: str,
        storage_account_name: str,
        subscription_id: str,
        **kwargs
    ):
        """
        :keyword data_set_id: The id of the source data set. Required.
        :paramtype data_set_id: str
        :keyword file_system: File system to which the folder belongs. Required.
        :paramtype file_system: str
        :keyword folder_path: Folder path within the file system. Required.
        :paramtype folder_path: str
        :keyword resource_group: Resource group of storage account. Required.
        :paramtype resource_group: str
        :keyword storage_account_name: Storage account name of the source data set. Required.
        :paramtype storage_account_name: str
        :keyword subscription_id: Subscription id of storage account. Required.
        :paramtype subscription_id: str
        """
        super().__init__(**kwargs)
        self.kind = "AdlsGen2Folder"  # type: str
        self.data_set_id = data_set_id
        self.data_set_mapping_status = None
        self.file_system = file_system
        self.folder_path = folder_path
        self.provisioning_state = None
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name
        self.subscription_id = subscription_id


class BlobContainerDataSet(DataSet):
    """An Azure storage blob container data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set. Required. Known values are: "Blob", "Container", "BlobFolder",
     "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File",
     "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable", and
     "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetKind
    :ivar container_name: BLOB Container name. Required.
    :vartype container_name: str
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :ivar resource_group: Resource group of storage account. Required.
    :vartype resource_group: str
    :ivar storage_account_name: Storage account name of the source data set. Required.
    :vartype storage_account_name: str
    :ivar subscription_id: Subscription id of storage account. Required.
    :vartype subscription_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "container_name": {"required": True},
        "data_set_id": {"readonly": True},
        "resource_group": {"required": True},
        "storage_account_name": {"required": True},
        "subscription_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "container_name": {"key": "properties.containerName", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "storage_account_name": {"key": "properties.storageAccountName", "type": "str"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
    }

    def __init__(
        self, *, container_name: str, resource_group: str, storage_account_name: str, subscription_id: str, **kwargs
    ):
        """
        :keyword container_name: BLOB Container name. Required.
        :paramtype container_name: str
        :keyword resource_group: Resource group of storage account. Required.
        :paramtype resource_group: str
        :keyword storage_account_name: Storage account name of the source data set. Required.
        :paramtype storage_account_name: str
        :keyword subscription_id: Subscription id of storage account. Required.
        :paramtype subscription_id: str
        """
        super().__init__(**kwargs)
        self.kind = "Container"  # type: str
        self.container_name = container_name
        self.data_set_id = None
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name
        self.subscription_id = subscription_id


class BlobContainerDataSetMapping(DataSetMapping):  # pylint: disable=too-many-instance-attributes
    """A Blob container data set mapping.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set mapping. Required. Known values are: "Blob", "Container",
     "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "KustoCluster",
     "KustoDatabase", "SqlDBTable", "SqlDWTable", and "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetMappingKind
    :ivar container_name: BLOB Container name. Required.
    :vartype container_name: str
    :ivar data_set_id: The id of the source data set. Required.
    :vartype data_set_id: str
    :ivar data_set_mapping_status: Gets the status of the data set mapping. Known values are: "Ok"
     and "Broken".
    :vartype data_set_mapping_status: str or ~azure.mgmt.datashare.models.DataSetMappingStatus
    :ivar provisioning_state: Provisioning state of the data set mapping. Known values are:
     "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :ivar resource_group: Resource group of storage account. Required.
    :vartype resource_group: str
    :ivar storage_account_name: Storage account name of the source data set. Required.
    :vartype storage_account_name: str
    :ivar subscription_id: Subscription id of storage account. Required.
    :vartype subscription_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "container_name": {"required": True},
        "data_set_id": {"required": True},
        "data_set_mapping_status": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "resource_group": {"required": True},
        "storage_account_name": {"required": True},
        "subscription_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "container_name": {"key": "properties.containerName", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "data_set_mapping_status": {"key": "properties.dataSetMappingStatus", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "storage_account_name": {"key": "properties.storageAccountName", "type": "str"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        container_name: str,
        data_set_id: str,
        resource_group: str,
        storage_account_name: str,
        subscription_id: str,
        **kwargs
    ):
        """
        :keyword container_name: BLOB Container name. Required.
        :paramtype container_name: str
        :keyword data_set_id: The id of the source data set. Required.
        :paramtype data_set_id: str
        :keyword resource_group: Resource group of storage account. Required.
        :paramtype resource_group: str
        :keyword storage_account_name: Storage account name of the source data set. Required.
        :paramtype storage_account_name: str
        :keyword subscription_id: Subscription id of storage account. Required.
        :paramtype subscription_id: str
        """
        super().__init__(**kwargs)
        self.kind = "Container"  # type: str
        self.container_name = container_name
        self.data_set_id = data_set_id
        self.data_set_mapping_status = None
        self.provisioning_state = None
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name
        self.subscription_id = subscription_id


class BlobDataSet(DataSet):  # pylint: disable=too-many-instance-attributes
    """An Azure storage blob data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set. Required. Known values are: "Blob", "Container", "BlobFolder",
     "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File",
     "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable", and
     "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetKind
    :ivar container_name: Container that has the file path. Required.
    :vartype container_name: str
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :ivar file_path: File path within the source data set. Required.
    :vartype file_path: str
    :ivar resource_group: Resource group of storage account. Required.
    :vartype resource_group: str
    :ivar storage_account_name: Storage account name of the source data set. Required.
    :vartype storage_account_name: str
    :ivar subscription_id: Subscription id of storage account. Required.
    :vartype subscription_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "container_name": {"required": True},
        "data_set_id": {"readonly": True},
        "file_path": {"required": True},
        "resource_group": {"required": True},
        "storage_account_name": {"required": True},
        "subscription_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "container_name": {"key": "properties.containerName", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "file_path": {"key": "properties.filePath", "type": "str"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "storage_account_name": {"key": "properties.storageAccountName", "type": "str"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        container_name: str,
        file_path: str,
        resource_group: str,
        storage_account_name: str,
        subscription_id: str,
        **kwargs
    ):
        """
        :keyword container_name: Container that has the file path. Required.
        :paramtype container_name: str
        :keyword file_path: File path within the source data set. Required.
        :paramtype file_path: str
        :keyword resource_group: Resource group of storage account. Required.
        :paramtype resource_group: str
        :keyword storage_account_name: Storage account name of the source data set. Required.
        :paramtype storage_account_name: str
        :keyword subscription_id: Subscription id of storage account. Required.
        :paramtype subscription_id: str
        """
        super().__init__(**kwargs)
        self.kind = "Blob"  # type: str
        self.container_name = container_name
        self.data_set_id = None
        self.file_path = file_path
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name
        self.subscription_id = subscription_id


class BlobDataSetMapping(DataSetMapping):  # pylint: disable=too-many-instance-attributes
    """A Blob data set mapping.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set mapping. Required. Known values are: "Blob", "Container",
     "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "KustoCluster",
     "KustoDatabase", "SqlDBTable", "SqlDWTable", and "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetMappingKind
    :ivar container_name: Container that has the file path. Required.
    :vartype container_name: str
    :ivar data_set_id: The id of the source data set. Required.
    :vartype data_set_id: str
    :ivar data_set_mapping_status: Gets the status of the data set mapping. Known values are: "Ok"
     and "Broken".
    :vartype data_set_mapping_status: str or ~azure.mgmt.datashare.models.DataSetMappingStatus
    :ivar file_path: File path within the source data set. Required.
    :vartype file_path: str
    :ivar output_type: File output type. Known values are: "Csv" and "Parquet".
    :vartype output_type: str or ~azure.mgmt.datashare.models.OutputType
    :ivar provisioning_state: Provisioning state of the data set mapping. Known values are:
     "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :ivar resource_group: Resource group of storage account. Required.
    :vartype resource_group: str
    :ivar storage_account_name: Storage account name of the source data set. Required.
    :vartype storage_account_name: str
    :ivar subscription_id: Subscription id of storage account. Required.
    :vartype subscription_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "container_name": {"required": True},
        "data_set_id": {"required": True},
        "data_set_mapping_status": {"readonly": True},
        "file_path": {"required": True},
        "provisioning_state": {"readonly": True},
        "resource_group": {"required": True},
        "storage_account_name": {"required": True},
        "subscription_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "container_name": {"key": "properties.containerName", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "data_set_mapping_status": {"key": "properties.dataSetMappingStatus", "type": "str"},
        "file_path": {"key": "properties.filePath", "type": "str"},
        "output_type": {"key": "properties.outputType", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "storage_account_name": {"key": "properties.storageAccountName", "type": "str"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        container_name: str,
        data_set_id: str,
        file_path: str,
        resource_group: str,
        storage_account_name: str,
        subscription_id: str,
        output_type: Optional[Union[str, "_models.OutputType"]] = None,
        **kwargs
    ):
        """
        :keyword container_name: Container that has the file path. Required.
        :paramtype container_name: str
        :keyword data_set_id: The id of the source data set. Required.
        :paramtype data_set_id: str
        :keyword file_path: File path within the source data set. Required.
        :paramtype file_path: str
        :keyword output_type: File output type. Known values are: "Csv" and "Parquet".
        :paramtype output_type: str or ~azure.mgmt.datashare.models.OutputType
        :keyword resource_group: Resource group of storage account. Required.
        :paramtype resource_group: str
        :keyword storage_account_name: Storage account name of the source data set. Required.
        :paramtype storage_account_name: str
        :keyword subscription_id: Subscription id of storage account. Required.
        :paramtype subscription_id: str
        """
        super().__init__(**kwargs)
        self.kind = "Blob"  # type: str
        self.container_name = container_name
        self.data_set_id = data_set_id
        self.data_set_mapping_status = None
        self.file_path = file_path
        self.output_type = output_type
        self.provisioning_state = None
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name
        self.subscription_id = subscription_id


class BlobFolderDataSet(DataSet):  # pylint: disable=too-many-instance-attributes
    """An Azure storage blob folder data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set. Required. Known values are: "Blob", "Container", "BlobFolder",
     "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File",
     "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable", and
     "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetKind
    :ivar container_name: Container that has the file path. Required.
    :vartype container_name: str
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :ivar prefix: Prefix for blob folder. Required.
    :vartype prefix: str
    :ivar resource_group: Resource group of storage account. Required.
    :vartype resource_group: str
    :ivar storage_account_name: Storage account name of the source data set. Required.
    :vartype storage_account_name: str
    :ivar subscription_id: Subscription id of storage account. Required.
    :vartype subscription_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "container_name": {"required": True},
        "data_set_id": {"readonly": True},
        "prefix": {"required": True},
        "resource_group": {"required": True},
        "storage_account_name": {"required": True},
        "subscription_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "container_name": {"key": "properties.containerName", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "prefix": {"key": "properties.prefix", "type": "str"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "storage_account_name": {"key": "properties.storageAccountName", "type": "str"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        container_name: str,
        prefix: str,
        resource_group: str,
        storage_account_name: str,
        subscription_id: str,
        **kwargs
    ):
        """
        :keyword container_name: Container that has the file path. Required.
        :paramtype container_name: str
        :keyword prefix: Prefix for blob folder. Required.
        :paramtype prefix: str
        :keyword resource_group: Resource group of storage account. Required.
        :paramtype resource_group: str
        :keyword storage_account_name: Storage account name of the source data set. Required.
        :paramtype storage_account_name: str
        :keyword subscription_id: Subscription id of storage account. Required.
        :paramtype subscription_id: str
        """
        super().__init__(**kwargs)
        self.kind = "BlobFolder"  # type: str
        self.container_name = container_name
        self.data_set_id = None
        self.prefix = prefix
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name
        self.subscription_id = subscription_id


class BlobFolderDataSetMapping(DataSetMapping):  # pylint: disable=too-many-instance-attributes
    """A Blob folder data set mapping.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set mapping. Required. Known values are: "Blob", "Container",
     "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "KustoCluster",
     "KustoDatabase", "SqlDBTable", "SqlDWTable", and "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetMappingKind
    :ivar container_name: Container that has the file path. Required.
    :vartype container_name: str
    :ivar data_set_id: The id of the source data set. Required.
    :vartype data_set_id: str
    :ivar data_set_mapping_status: Gets the status of the data set mapping. Known values are: "Ok"
     and "Broken".
    :vartype data_set_mapping_status: str or ~azure.mgmt.datashare.models.DataSetMappingStatus
    :ivar prefix: Prefix for blob folder. Required.
    :vartype prefix: str
    :ivar provisioning_state: Provisioning state of the data set mapping. Known values are:
     "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :ivar resource_group: Resource group of storage account. Required.
    :vartype resource_group: str
    :ivar storage_account_name: Storage account name of the source data set. Required.
    :vartype storage_account_name: str
    :ivar subscription_id: Subscription id of storage account. Required.
    :vartype subscription_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "container_name": {"required": True},
        "data_set_id": {"required": True},
        "data_set_mapping_status": {"readonly": True},
        "prefix": {"required": True},
        "provisioning_state": {"readonly": True},
        "resource_group": {"required": True},
        "storage_account_name": {"required": True},
        "subscription_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "container_name": {"key": "properties.containerName", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "data_set_mapping_status": {"key": "properties.dataSetMappingStatus", "type": "str"},
        "prefix": {"key": "properties.prefix", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "resource_group": {"key": "properties.resourceGroup", "type": "str"},
        "storage_account_name": {"key": "properties.storageAccountName", "type": "str"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
    }

    def __init__(
        self,
        *,
        container_name: str,
        data_set_id: str,
        prefix: str,
        resource_group: str,
        storage_account_name: str,
        subscription_id: str,
        **kwargs
    ):
        """
        :keyword container_name: Container that has the file path. Required.
        :paramtype container_name: str
        :keyword data_set_id: The id of the source data set. Required.
        :paramtype data_set_id: str
        :keyword prefix: Prefix for blob folder. Required.
        :paramtype prefix: str
        :keyword resource_group: Resource group of storage account. Required.
        :paramtype resource_group: str
        :keyword storage_account_name: Storage account name of the source data set. Required.
        :paramtype storage_account_name: str
        :keyword subscription_id: Subscription id of storage account. Required.
        :paramtype subscription_id: str
        """
        super().__init__(**kwargs)
        self.kind = "BlobFolder"  # type: str
        self.container_name = container_name
        self.data_set_id = data_set_id
        self.data_set_mapping_status = None
        self.prefix = prefix
        self.provisioning_state = None
        self.resource_group = resource_group
        self.storage_account_name = storage_account_name
        self.subscription_id = subscription_id


class ConsumerInvitation(ProxyDto):  # pylint: disable=too-many-instance-attributes
    """A consumer Invitation data transfer object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar data_set_count: Number of data sets in a share.
    :vartype data_set_count: int
    :ivar description: Description shared when the invitation was created.
    :vartype description: str
    :ivar expiration_date: The expiration date for the share subscription created by accepting the
     invitation.
    :vartype expiration_date: ~datetime.datetime
    :ivar invitation_id: Unique id of the invitation. Required.
    :vartype invitation_id: str
    :ivar invitation_status: The status of the invitation. Known values are: "Pending", "Accepted",
     "Rejected", and "Withdrawn".
    :vartype invitation_status: str or ~azure.mgmt.datashare.models.InvitationStatus
    :ivar location: invitation location.
    :vartype location: str
    :ivar provider_email: Email of the provider who created the resource.
    :vartype provider_email: str
    :ivar provider_name: Name of the provider who created the resource.
    :vartype provider_name: str
    :ivar provider_tenant_name: Tenant name of the provider who created the resource.
    :vartype provider_tenant_name: str
    :ivar responded_at: The time the recipient responded to the invitation.
    :vartype responded_at: ~datetime.datetime
    :ivar sent_at: Gets the time at which the invitation was sent.
    :vartype sent_at: ~datetime.datetime
    :ivar share_name: Gets the source share Name.
    :vartype share_name: str
    :ivar terms_of_use: Terms of use shared when the invitation was created.
    :vartype terms_of_use: str
    :ivar user_email: Email of the user who created the resource.
    :vartype user_email: str
    :ivar user_name: Name of the user who created the resource.
    :vartype user_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "data_set_count": {"readonly": True},
        "description": {"readonly": True},
        "expiration_date": {"readonly": True},
        "invitation_id": {"required": True},
        "invitation_status": {"readonly": True},
        "location": {"readonly": True},
        "provider_email": {"readonly": True},
        "provider_name": {"readonly": True},
        "provider_tenant_name": {"readonly": True},
        "responded_at": {"readonly": True},
        "sent_at": {"readonly": True},
        "share_name": {"readonly": True},
        "terms_of_use": {"readonly": True},
        "user_email": {"readonly": True},
        "user_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "data_set_count": {"key": "properties.dataSetCount", "type": "int"},
        "description": {"key": "properties.description", "type": "str"},
        "expiration_date": {"key": "properties.expirationDate", "type": "iso-8601"},
        "invitation_id": {"key": "properties.invitationId", "type": "str"},
        "invitation_status": {"key": "properties.invitationStatus", "type": "str"},
        "location": {"key": "properties.location", "type": "str"},
        "provider_email": {"key": "properties.providerEmail", "type": "str"},
        "provider_name": {"key": "properties.providerName", "type": "str"},
        "provider_tenant_name": {"key": "properties.providerTenantName", "type": "str"},
        "responded_at": {"key": "properties.respondedAt", "type": "iso-8601"},
        "sent_at": {"key": "properties.sentAt", "type": "iso-8601"},
        "share_name": {"key": "properties.shareName", "type": "str"},
        "terms_of_use": {"key": "properties.termsOfUse", "type": "str"},
        "user_email": {"key": "properties.userEmail", "type": "str"},
        "user_name": {"key": "properties.userName", "type": "str"},
    }

    def __init__(self, *, invitation_id: str, **kwargs):
        """
        :keyword invitation_id: Unique id of the invitation. Required.
        :paramtype invitation_id: str
        """
        super().__init__(**kwargs)
        self.data_set_count = None
        self.description = None
        self.expiration_date = None
        self.invitation_id = invitation_id
        self.invitation_status = None
        self.location = None
        self.provider_email = None
        self.provider_name = None
        self.provider_tenant_name = None
        self.responded_at = None
        self.sent_at = None
        self.share_name = None
        self.terms_of_use = None
        self.user_email = None
        self.user_name = None


class ConsumerInvitationList(_serialization.Model):
    """List response for get InvitationList.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: The Url of next result page.
    :vartype next_link: str
    :ivar value: Collection of items of type DataTransferObjects. Required.
    :vartype value: list[~azure.mgmt.datashare.models.ConsumerInvitation]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ConsumerInvitation]"},
    }

    def __init__(self, *, value: List["_models.ConsumerInvitation"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The Url of next result page.
        :paramtype next_link: str
        :keyword value: Collection of items of type DataTransferObjects. Required.
        :paramtype value: list[~azure.mgmt.datashare.models.ConsumerInvitation]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ConsumerSourceDataSet(ProxyDto):
    """A consumer side dataSet data transfer object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar data_set_id: DataSet Id.
    :vartype data_set_id: str
    :ivar data_set_location: Location of the data set.
    :vartype data_set_location: str
    :ivar data_set_name: DataSet name.
    :vartype data_set_name: str
    :ivar data_set_path: DataSet path.
    :vartype data_set_path: str
    :ivar data_set_type: Type of data set. Known values are: "Blob", "Container", "BlobFolder",
     "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File",
     "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable", and
     "SynapseWorkspaceSqlPoolTable".
    :vartype data_set_type: str or ~azure.mgmt.datashare.models.DataSetType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "data_set_id": {"readonly": True},
        "data_set_location": {"readonly": True},
        "data_set_name": {"readonly": True},
        "data_set_path": {"readonly": True},
        "data_set_type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "data_set_location": {"key": "properties.dataSetLocation", "type": "str"},
        "data_set_name": {"key": "properties.dataSetName", "type": "str"},
        "data_set_path": {"key": "properties.dataSetPath", "type": "str"},
        "data_set_type": {"key": "properties.dataSetType", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.data_set_id = None
        self.data_set_location = None
        self.data_set_name = None
        self.data_set_path = None
        self.data_set_type = None


class ConsumerSourceDataSetList(_serialization.Model):
    """A consumer side list of source dataSets.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: The Url of next result page.
    :vartype next_link: str
    :ivar value: Collection of items of type DataTransferObjects. Required.
    :vartype value: list[~azure.mgmt.datashare.models.ConsumerSourceDataSet]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ConsumerSourceDataSet]"},
    }

    def __init__(self, *, value: List["_models.ConsumerSourceDataSet"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The Url of next result page.
        :paramtype next_link: str
        :keyword value: Collection of items of type DataTransferObjects. Required.
        :paramtype value: list[~azure.mgmt.datashare.models.ConsumerSourceDataSet]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class DataSetList(_serialization.Model):
    """List response for get DataSets.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: The Url of next result page.
    :vartype next_link: str
    :ivar value: Collection of items of type DataTransferObjects. Required.
    :vartype value: list[~azure.mgmt.datashare.models.DataSet]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[DataSet]"},
    }

    def __init__(self, *, value: List["_models.DataSet"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The Url of next result page.
        :paramtype next_link: str
        :keyword value: Collection of items of type DataTransferObjects. Required.
        :paramtype value: list[~azure.mgmt.datashare.models.DataSet]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class DataSetMappingList(_serialization.Model):
    """List response for get DataSetMappings.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: The Url of next result page.
    :vartype next_link: str
    :ivar value: Collection of items of type DataTransferObjects. Required.
    :vartype value: list[~azure.mgmt.datashare.models.DataSetMapping]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[DataSetMapping]"},
    }

    def __init__(self, *, value: List["_models.DataSetMapping"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The Url of next result page.
        :paramtype next_link: str
        :keyword value: Collection of items of type DataTransferObjects. Required.
        :paramtype value: list[~azure.mgmt.datashare.models.DataSetMapping]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class DataShareError(_serialization.Model):
    """The data share error model.

    All required parameters must be populated in order to send to Azure.

    :ivar error: The data share error body. Required.
    :vartype error: ~azure.mgmt.datashare.models.DataShareErrorInfo
    """

    _validation = {
        "error": {"required": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "DataShareErrorInfo"},
    }

    def __init__(self, *, error: "_models.DataShareErrorInfo", **kwargs):
        """
        :keyword error: The data share error body. Required.
        :paramtype error: ~azure.mgmt.datashare.models.DataShareErrorInfo
        """
        super().__init__(**kwargs)
        self.error = error


class DataShareErrorInfo(_serialization.Model):
    """The data share error body model.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Code of the error. Required.
    :vartype code: str
    :ivar details: Nested details of the error model.
    :vartype details: list[~azure.mgmt.datashare.models.DataShareErrorInfo]
    :ivar message: Message of the error. Required.
    :vartype message: str
    :ivar target: Target of the error.
    :vartype target: str
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "details": {"key": "details", "type": "[DataShareErrorInfo]"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        details: Optional[List["_models.DataShareErrorInfo"]] = None,
        target: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword code: Code of the error. Required.
        :paramtype code: str
        :keyword details: Nested details of the error model.
        :paramtype details: list[~azure.mgmt.datashare.models.DataShareErrorInfo]
        :keyword message: Message of the error. Required.
        :paramtype message: str
        :keyword target: Target of the error.
        :paramtype target: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.details = details
        self.message = message
        self.target = target


class DimensionProperties(_serialization.Model):
    """properties for dimension.

    :ivar display_name: localized display name of the dimension to customer.
    :vartype display_name: str
    :ivar name: dimension name.
    :vartype name: str
    """

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, display_name: Optional[str] = None, name: Optional[str] = None, **kwargs):
        """
        :keyword display_name: localized display name of the dimension to customer.
        :paramtype display_name: str
        :keyword name: dimension name.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.name = name


class EmailRegistration(_serialization.Model):
    """Dto for tenant domain registration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar activation_code: Activation code for the registration.
    :vartype activation_code: str
    :ivar activation_expiration_date: Date of the activation expiration.
    :vartype activation_expiration_date: ~datetime.datetime
    :ivar email: The email to register.
    :vartype email: str
    :ivar registration_status: Registration status. Known values are: "ActivationPending",
     "Activated", and "ActivationAttemptsExhausted".
    :vartype registration_status: str or ~azure.mgmt.datashare.models.RegistrationStatus
    :ivar tenant_id: The tenant to register.
    :vartype tenant_id: str
    """

    _validation = {
        "activation_expiration_date": {"readonly": True},
        "email": {"readonly": True},
        "registration_status": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "activation_code": {"key": "activationCode", "type": "str"},
        "activation_expiration_date": {"key": "activationExpirationDate", "type": "iso-8601"},
        "email": {"key": "email", "type": "str"},
        "registration_status": {"key": "registrationStatus", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, *, activation_code: Optional[str] = None, **kwargs):
        """
        :keyword activation_code: Activation code for the registration.
        :paramtype activation_code: str
        """
        super().__init__(**kwargs)
        self.activation_code = activation_code
        self.activation_expiration_date = None
        self.email = None
        self.registration_status = None
        self.tenant_id = None


class Identity(_serialization.Model):
    """Identity of resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: service principal Id.
    :vartype principal_id: str
    :ivar tenant_id: Tenant Id.
    :vartype tenant_id: str
    :ivar type: Identity Type. "SystemAssigned"
    :vartype type: str or ~azure.mgmt.datashare.models.Type
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.Type"]] = None, **kwargs):
        """
        :keyword type: Identity Type. "SystemAssigned"
        :paramtype type: str or ~azure.mgmt.datashare.models.Type
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class Invitation(ProxyDto):  # pylint: disable=too-many-instance-attributes
    """A Invitation data transfer object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar expiration_date: The expiration date for the invitation and share subscription.
    :vartype expiration_date: ~datetime.datetime
    :ivar invitation_id: unique invitation id.
    :vartype invitation_id: str
    :ivar invitation_status: The status of the invitation. Known values are: "Pending", "Accepted",
     "Rejected", and "Withdrawn".
    :vartype invitation_status: str or ~azure.mgmt.datashare.models.InvitationStatus
    :ivar responded_at: The time the recipient responded to the invitation.
    :vartype responded_at: ~datetime.datetime
    :ivar sent_at: Gets the time at which the invitation was sent.
    :vartype sent_at: ~datetime.datetime
    :ivar target_active_directory_id: The target Azure AD Id. Can't be combined with email.
    :vartype target_active_directory_id: str
    :ivar target_email: The email the invitation is directed to.
    :vartype target_email: str
    :ivar target_object_id: The target user or application Id that invitation is being sent to.
     Must be specified along TargetActiveDirectoryId. This enables sending
     invitations to specific users or applications in an AD tenant.
    :vartype target_object_id: str
    :ivar user_email: Email of the user who created the resource.
    :vartype user_email: str
    :ivar user_name: Name of the user who created the resource.
    :vartype user_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "invitation_id": {"readonly": True},
        "invitation_status": {"readonly": True},
        "responded_at": {"readonly": True},
        "sent_at": {"readonly": True},
        "user_email": {"readonly": True},
        "user_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "expiration_date": {"key": "properties.expirationDate", "type": "iso-8601"},
        "invitation_id": {"key": "properties.invitationId", "type": "str"},
        "invitation_status": {"key": "properties.invitationStatus", "type": "str"},
        "responded_at": {"key": "properties.respondedAt", "type": "iso-8601"},
        "sent_at": {"key": "properties.sentAt", "type": "iso-8601"},
        "target_active_directory_id": {"key": "properties.targetActiveDirectoryId", "type": "str"},
        "target_email": {"key": "properties.targetEmail", "type": "str"},
        "target_object_id": {"key": "properties.targetObjectId", "type": "str"},
        "user_email": {"key": "properties.userEmail", "type": "str"},
        "user_name": {"key": "properties.userName", "type": "str"},
    }

    def __init__(
        self,
        *,
        expiration_date: Optional[datetime.datetime] = None,
        target_active_directory_id: Optional[str] = None,
        target_email: Optional[str] = None,
        target_object_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword expiration_date: The expiration date for the invitation and share subscription.
        :paramtype expiration_date: ~datetime.datetime
        :keyword target_active_directory_id: The target Azure AD Id. Can't be combined with email.
        :paramtype target_active_directory_id: str
        :keyword target_email: The email the invitation is directed to.
        :paramtype target_email: str
        :keyword target_object_id: The target user or application Id that invitation is being sent to.
         Must be specified along TargetActiveDirectoryId. This enables sending
         invitations to specific users or applications in an AD tenant.
        :paramtype target_object_id: str
        """
        super().__init__(**kwargs)
        self.expiration_date = expiration_date
        self.invitation_id = None
        self.invitation_status = None
        self.responded_at = None
        self.sent_at = None
        self.target_active_directory_id = target_active_directory_id
        self.target_email = target_email
        self.target_object_id = target_object_id
        self.user_email = None
        self.user_name = None


class InvitationList(_serialization.Model):
    """List response for get InvitationList.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: The Url of next result page.
    :vartype next_link: str
    :ivar value: Collection of items of type DataTransferObjects. Required.
    :vartype value: list[~azure.mgmt.datashare.models.Invitation]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Invitation]"},
    }

    def __init__(self, *, value: List["_models.Invitation"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The Url of next result page.
        :paramtype next_link: str
        :keyword value: Collection of items of type DataTransferObjects. Required.
        :paramtype value: list[~azure.mgmt.datashare.models.Invitation]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class KustoClusterDataSet(DataSet):
    """A kusto cluster data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set. Required. Known values are: "Blob", "Container", "BlobFolder",
     "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File",
     "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable", and
     "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetKind
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :ivar kusto_cluster_resource_id: Resource id of the kusto cluster. Required.
    :vartype kusto_cluster_resource_id: str
    :ivar location: Location of the kusto cluster.
    :vartype location: str
    :ivar provisioning_state: Provisioning state of the kusto cluster data set. Known values are:
     "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "data_set_id": {"readonly": True},
        "kusto_cluster_resource_id": {"required": True},
        "location": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "kusto_cluster_resource_id": {"key": "properties.kustoClusterResourceId", "type": "str"},
        "location": {"key": "properties.location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, kusto_cluster_resource_id: str, **kwargs):
        """
        :keyword kusto_cluster_resource_id: Resource id of the kusto cluster. Required.
        :paramtype kusto_cluster_resource_id: str
        """
        super().__init__(**kwargs)
        self.kind = "KustoCluster"  # type: str
        self.data_set_id = None
        self.kusto_cluster_resource_id = kusto_cluster_resource_id
        self.location = None
        self.provisioning_state = None


class KustoClusterDataSetMapping(DataSetMapping):
    """A Kusto cluster data set mapping.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set mapping. Required. Known values are: "Blob", "Container",
     "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "KustoCluster",
     "KustoDatabase", "SqlDBTable", "SqlDWTable", and "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetMappingKind
    :ivar data_set_id: The id of the source data set. Required.
    :vartype data_set_id: str
    :ivar data_set_mapping_status: Gets the status of the data set mapping. Known values are: "Ok"
     and "Broken".
    :vartype data_set_mapping_status: str or ~azure.mgmt.datashare.models.DataSetMappingStatus
    :ivar kusto_cluster_resource_id: Resource id of the sink kusto cluster. Required.
    :vartype kusto_cluster_resource_id: str
    :ivar location: Location of the sink kusto cluster.
    :vartype location: str
    :ivar provisioning_state: Provisioning state of the data set mapping. Known values are:
     "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "data_set_id": {"required": True},
        "data_set_mapping_status": {"readonly": True},
        "kusto_cluster_resource_id": {"required": True},
        "location": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "data_set_mapping_status": {"key": "properties.dataSetMappingStatus", "type": "str"},
        "kusto_cluster_resource_id": {"key": "properties.kustoClusterResourceId", "type": "str"},
        "location": {"key": "properties.location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, data_set_id: str, kusto_cluster_resource_id: str, **kwargs):
        """
        :keyword data_set_id: The id of the source data set. Required.
        :paramtype data_set_id: str
        :keyword kusto_cluster_resource_id: Resource id of the sink kusto cluster. Required.
        :paramtype kusto_cluster_resource_id: str
        """
        super().__init__(**kwargs)
        self.kind = "KustoCluster"  # type: str
        self.data_set_id = data_set_id
        self.data_set_mapping_status = None
        self.kusto_cluster_resource_id = kusto_cluster_resource_id
        self.location = None
        self.provisioning_state = None


class KustoDatabaseDataSet(DataSet):
    """A kusto database data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set. Required. Known values are: "Blob", "Container", "BlobFolder",
     "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File",
     "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable", and
     "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetKind
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :ivar kusto_database_resource_id: Resource id of the kusto database. Required.
    :vartype kusto_database_resource_id: str
    :ivar location: Location of the kusto cluster.
    :vartype location: str
    :ivar provisioning_state: Provisioning state of the kusto database data set. Known values are:
     "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "data_set_id": {"readonly": True},
        "kusto_database_resource_id": {"required": True},
        "location": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "kusto_database_resource_id": {"key": "properties.kustoDatabaseResourceId", "type": "str"},
        "location": {"key": "properties.location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, kusto_database_resource_id: str, **kwargs):
        """
        :keyword kusto_database_resource_id: Resource id of the kusto database. Required.
        :paramtype kusto_database_resource_id: str
        """
        super().__init__(**kwargs)
        self.kind = "KustoDatabase"  # type: str
        self.data_set_id = None
        self.kusto_database_resource_id = kusto_database_resource_id
        self.location = None
        self.provisioning_state = None


class KustoDatabaseDataSetMapping(DataSetMapping):
    """A Kusto database data set mapping.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set mapping. Required. Known values are: "Blob", "Container",
     "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "KustoCluster",
     "KustoDatabase", "SqlDBTable", "SqlDWTable", and "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetMappingKind
    :ivar data_set_id: The id of the source data set. Required.
    :vartype data_set_id: str
    :ivar data_set_mapping_status: Gets the status of the data set mapping. Known values are: "Ok"
     and "Broken".
    :vartype data_set_mapping_status: str or ~azure.mgmt.datashare.models.DataSetMappingStatus
    :ivar kusto_cluster_resource_id: Resource id of the sink kusto cluster. Required.
    :vartype kusto_cluster_resource_id: str
    :ivar location: Location of the sink kusto cluster.
    :vartype location: str
    :ivar provisioning_state: Provisioning state of the data set mapping. Known values are:
     "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "data_set_id": {"required": True},
        "data_set_mapping_status": {"readonly": True},
        "kusto_cluster_resource_id": {"required": True},
        "location": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "data_set_mapping_status": {"key": "properties.dataSetMappingStatus", "type": "str"},
        "kusto_cluster_resource_id": {"key": "properties.kustoClusterResourceId", "type": "str"},
        "location": {"key": "properties.location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, data_set_id: str, kusto_cluster_resource_id: str, **kwargs):
        """
        :keyword data_set_id: The id of the source data set. Required.
        :paramtype data_set_id: str
        :keyword kusto_cluster_resource_id: Resource id of the sink kusto cluster. Required.
        :paramtype kusto_cluster_resource_id: str
        """
        super().__init__(**kwargs)
        self.kind = "KustoDatabase"  # type: str
        self.data_set_id = data_set_id
        self.data_set_mapping_status = None
        self.kusto_cluster_resource_id = kusto_cluster_resource_id
        self.location = None
        self.provisioning_state = None


class OperationList(_serialization.Model):
    """List response for get operations.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: The Url of next result page.
    :vartype next_link: str
    :ivar value: Collection of items of type DataTransferObjects. Required.
    :vartype value: list[~azure.mgmt.datashare.models.OperationModel]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[OperationModel]"},
    }

    def __init__(self, *, value: List["_models.OperationModel"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The Url of next result page.
        :paramtype next_link: str
        :keyword value: Collection of items of type DataTransferObjects. Required.
        :paramtype value: list[~azure.mgmt.datashare.models.OperationModel]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class OperationMetaLogSpecification(_serialization.Model):
    """log specifications for operation api.

    :ivar blob_duration: blob duration of the log.
    :vartype blob_duration: str
    :ivar display_name: localized name of the log category.
    :vartype display_name: str
    :ivar name: name of the log category.
    :vartype name: str
    """

    _attribute_map = {
        "blob_duration": {"key": "blobDuration", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(
        self,
        *,
        blob_duration: Optional[str] = None,
        display_name: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword blob_duration: blob duration of the log.
        :paramtype blob_duration: str
        :keyword display_name: localized name of the log category.
        :paramtype display_name: str
        :keyword name: name of the log category.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.blob_duration = blob_duration
        self.display_name = display_name
        self.name = name


class OperationMetaMetricSpecification(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """metric specifications for the operation.

    :ivar aggregation_type: aggregation type of metric.
    :vartype aggregation_type: str
    :ivar dimensions: properties for dimension.
    :vartype dimensions: list[~azure.mgmt.datashare.models.DimensionProperties]
    :ivar display_description: description of the metric.
    :vartype display_description: str
    :ivar display_name: localized name of the metric.
    :vartype display_name: str
    :ivar enable_regional_mdm_account: enable regional mdm account.
    :vartype enable_regional_mdm_account: str
    :ivar fill_gap_with_zero: fill gap with zero.
    :vartype fill_gap_with_zero: bool
    :ivar internal_metric_name: internal metric name.
    :vartype internal_metric_name: str
    :ivar name: name of the metric.
    :vartype name: str
    :ivar resource_id_dimension_name_override: dimension name use to replace resource id if
     specified.
    :vartype resource_id_dimension_name_override: str
    :ivar supported_aggregation_types: supported aggregation types.
    :vartype supported_aggregation_types: list[str]
    :ivar supported_time_grain_types: supported time grain types.
    :vartype supported_time_grain_types: list[str]
    :ivar unit: units for the metric.
    :vartype unit: str
    """

    _attribute_map = {
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[DimensionProperties]"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "enable_regional_mdm_account": {"key": "enableRegionalMdmAccount", "type": "str"},
        "fill_gap_with_zero": {"key": "fillGapWithZero", "type": "bool"},
        "internal_metric_name": {"key": "internalMetricName", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "resource_id_dimension_name_override": {"key": "resourceIdDimensionNameOverride", "type": "str"},
        "supported_aggregation_types": {"key": "supportedAggregationTypes", "type": "[str]"},
        "supported_time_grain_types": {"key": "supportedTimeGrainTypes", "type": "[str]"},
        "unit": {"key": "unit", "type": "str"},
    }

    def __init__(
        self,
        *,
        aggregation_type: Optional[str] = None,
        dimensions: Optional[List["_models.DimensionProperties"]] = None,
        display_description: Optional[str] = None,
        display_name: Optional[str] = None,
        enable_regional_mdm_account: Optional[str] = None,
        fill_gap_with_zero: Optional[bool] = None,
        internal_metric_name: Optional[str] = None,
        name: Optional[str] = None,
        resource_id_dimension_name_override: Optional[str] = None,
        supported_aggregation_types: Optional[List[str]] = None,
        supported_time_grain_types: Optional[List[str]] = None,
        unit: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword aggregation_type: aggregation type of metric.
        :paramtype aggregation_type: str
        :keyword dimensions: properties for dimension.
        :paramtype dimensions: list[~azure.mgmt.datashare.models.DimensionProperties]
        :keyword display_description: description of the metric.
        :paramtype display_description: str
        :keyword display_name: localized name of the metric.
        :paramtype display_name: str
        :keyword enable_regional_mdm_account: enable regional mdm account.
        :paramtype enable_regional_mdm_account: str
        :keyword fill_gap_with_zero: fill gap with zero.
        :paramtype fill_gap_with_zero: bool
        :keyword internal_metric_name: internal metric name.
        :paramtype internal_metric_name: str
        :keyword name: name of the metric.
        :paramtype name: str
        :keyword resource_id_dimension_name_override: dimension name use to replace resource id if
         specified.
        :paramtype resource_id_dimension_name_override: str
        :keyword supported_aggregation_types: supported aggregation types.
        :paramtype supported_aggregation_types: list[str]
        :keyword supported_time_grain_types: supported time grain types.
        :paramtype supported_time_grain_types: list[str]
        :keyword unit: units for the metric.
        :paramtype unit: str
        """
        super().__init__(**kwargs)
        self.aggregation_type = aggregation_type
        self.dimensions = dimensions
        self.display_description = display_description
        self.display_name = display_name
        self.enable_regional_mdm_account = enable_regional_mdm_account
        self.fill_gap_with_zero = fill_gap_with_zero
        self.internal_metric_name = internal_metric_name
        self.name = name
        self.resource_id_dimension_name_override = resource_id_dimension_name_override
        self.supported_aggregation_types = supported_aggregation_types
        self.supported_time_grain_types = supported_time_grain_types
        self.unit = unit


class OperationMetaServiceSpecification(_serialization.Model):
    """The operation meta service specification.

    :ivar log_specifications: log specifications for the operation.
    :vartype log_specifications: list[~azure.mgmt.datashare.models.OperationMetaLogSpecification]
    :ivar metric_specifications: metric specifications for the operation.
    :vartype metric_specifications:
     list[~azure.mgmt.datashare.models.OperationMetaMetricSpecification]
    """

    _attribute_map = {
        "log_specifications": {"key": "logSpecifications", "type": "[OperationMetaLogSpecification]"},
        "metric_specifications": {"key": "metricSpecifications", "type": "[OperationMetaMetricSpecification]"},
    }

    def __init__(
        self,
        *,
        log_specifications: Optional[List["_models.OperationMetaLogSpecification"]] = None,
        metric_specifications: Optional[List["_models.OperationMetaMetricSpecification"]] = None,
        **kwargs
    ):
        """
        :keyword log_specifications: log specifications for the operation.
        :paramtype log_specifications: list[~azure.mgmt.datashare.models.OperationMetaLogSpecification]
        :keyword metric_specifications: metric specifications for the operation.
        :paramtype metric_specifications:
         list[~azure.mgmt.datashare.models.OperationMetaMetricSpecification]
        """
        super().__init__(**kwargs)
        self.log_specifications = log_specifications
        self.metric_specifications = metric_specifications


class OperationModel(_serialization.Model):
    """The response model for get operations.

    :ivar display: Properties on the operation.
    :vartype display: ~azure.mgmt.datashare.models.OperationModelProperties
    :ivar name: Operation name for display purposes.
    :vartype name: str
    :ivar origin: origin of the operation.
    :vartype origin: str
    :ivar service_specification: meta service specification.
    :vartype service_specification: ~azure.mgmt.datashare.models.OperationMetaServiceSpecification
    """

    _attribute_map = {
        "display": {"key": "display", "type": "OperationModelProperties"},
        "name": {"key": "name", "type": "str"},
        "origin": {"key": "origin", "type": "str"},
        "service_specification": {
            "key": "properties.serviceSpecification",
            "type": "OperationMetaServiceSpecification",
        },
    }

    def __init__(
        self,
        *,
        display: Optional["_models.OperationModelProperties"] = None,
        name: Optional[str] = None,
        origin: Optional[str] = None,
        service_specification: Optional["_models.OperationMetaServiceSpecification"] = None,
        **kwargs
    ):
        """
        :keyword display: Properties on the operation.
        :paramtype display: ~azure.mgmt.datashare.models.OperationModelProperties
        :keyword name: Operation name for display purposes.
        :paramtype name: str
        :keyword origin: origin of the operation.
        :paramtype origin: str
        :keyword service_specification: meta service specification.
        :paramtype service_specification:
         ~azure.mgmt.datashare.models.OperationMetaServiceSpecification
        """
        super().__init__(**kwargs)
        self.display = display
        self.name = name
        self.origin = origin
        self.service_specification = service_specification


class OperationModelProperties(_serialization.Model):
    """Properties on operations.

    :ivar description: Description of the operation for display purposes.
    :vartype description: str
    :ivar operation: Name of the operation for display purposes.
    :vartype operation: str
    :ivar provider: Name of the provider for display purposes.
    :vartype provider: str
    :ivar resource: Name of the resource type for display purposes.
    :vartype resource: str
    """

    _attribute_map = {
        "description": {"key": "description", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        operation: Optional[str] = None,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Description of the operation for display purposes.
        :paramtype description: str
        :keyword operation: Name of the operation for display purposes.
        :paramtype operation: str
        :keyword provider: Name of the provider for display purposes.
        :paramtype provider: str
        :keyword resource: Name of the resource type for display purposes.
        :paramtype resource: str
        """
        super().__init__(**kwargs)
        self.description = description
        self.operation = operation
        self.provider = provider
        self.resource = resource


class OperationResponse(_serialization.Model):
    """Response for long running operation.

    All required parameters must be populated in order to send to Azure.

    :ivar end_time: start time.
    :vartype end_time: ~datetime.datetime
    :ivar error: The error property when status is failed.
    :vartype error: ~azure.mgmt.datashare.models.DataShareErrorInfo
    :ivar start_time: start time.
    :vartype start_time: ~datetime.datetime
    :ivar status: Operation state of the long running operation. Required. Known values are:
     "Accepted", "InProgress", "TransientFailure", "Succeeded", "Failed", and "Canceled".
    :vartype status: str or ~azure.mgmt.datashare.models.Status
    """

    _validation = {
        "status": {"required": True},
    }

    _attribute_map = {
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "error": {"key": "error", "type": "DataShareErrorInfo"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Union[str, "_models.Status"],
        end_time: Optional[datetime.datetime] = None,
        error: Optional["_models.DataShareErrorInfo"] = None,
        start_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword end_time: start time.
        :paramtype end_time: ~datetime.datetime
        :keyword error: The error property when status is failed.
        :paramtype error: ~azure.mgmt.datashare.models.DataShareErrorInfo
        :keyword start_time: start time.
        :paramtype start_time: ~datetime.datetime
        :keyword status: Operation state of the long running operation. Required. Known values are:
         "Accepted", "InProgress", "TransientFailure", "Succeeded", "Failed", and "Canceled".
        :paramtype status: str or ~azure.mgmt.datashare.models.Status
        """
        super().__init__(**kwargs)
        self.end_time = end_time
        self.error = error
        self.start_time = start_time
        self.status = status


class ProviderShareSubscription(ProxyDto):  # pylint: disable=too-many-instance-attributes
    """A provider side share subscription data transfer object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar consumer_email: Email of the consumer who created the share subscription.
    :vartype consumer_email: str
    :ivar consumer_name: Name of the consumer who created the share subscription.
    :vartype consumer_name: str
    :ivar consumer_tenant_name: Tenant name of the consumer who created the share subscription.
    :vartype consumer_tenant_name: str
    :ivar created_at: created at.
    :vartype created_at: ~datetime.datetime
    :ivar expiration_date: Expiration date of the share subscription in UTC format.
    :vartype expiration_date: ~datetime.datetime
    :ivar provider_email: Email of the provider who created the share.
    :vartype provider_email: str
    :ivar provider_name: Name of the provider who created the share.
    :vartype provider_name: str
    :ivar shared_at: Shared at.
    :vartype shared_at: ~datetime.datetime
    :ivar share_subscription_object_id: share Subscription Object Id.
    :vartype share_subscription_object_id: str
    :ivar share_subscription_status: Gets the status of share subscription. Known values are:
     "Active", "Revoked", "SourceDeleted", and "Revoking".
    :vartype share_subscription_status: str or ~azure.mgmt.datashare.models.ShareSubscriptionStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "consumer_email": {"readonly": True},
        "consumer_name": {"readonly": True},
        "consumer_tenant_name": {"readonly": True},
        "created_at": {"readonly": True},
        "provider_email": {"readonly": True},
        "provider_name": {"readonly": True},
        "shared_at": {"readonly": True},
        "share_subscription_object_id": {"readonly": True},
        "share_subscription_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "consumer_email": {"key": "properties.consumerEmail", "type": "str"},
        "consumer_name": {"key": "properties.consumerName", "type": "str"},
        "consumer_tenant_name": {"key": "properties.consumerTenantName", "type": "str"},
        "created_at": {"key": "properties.createdAt", "type": "iso-8601"},
        "expiration_date": {"key": "properties.expirationDate", "type": "iso-8601"},
        "provider_email": {"key": "properties.providerEmail", "type": "str"},
        "provider_name": {"key": "properties.providerName", "type": "str"},
        "shared_at": {"key": "properties.sharedAt", "type": "iso-8601"},
        "share_subscription_object_id": {"key": "properties.shareSubscriptionObjectId", "type": "str"},
        "share_subscription_status": {"key": "properties.shareSubscriptionStatus", "type": "str"},
    }

    def __init__(self, *, expiration_date: Optional[datetime.datetime] = None, **kwargs):
        """
        :keyword expiration_date: Expiration date of the share subscription in UTC format.
        :paramtype expiration_date: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.consumer_email = None
        self.consumer_name = None
        self.consumer_tenant_name = None
        self.created_at = None
        self.expiration_date = expiration_date
        self.provider_email = None
        self.provider_name = None
        self.shared_at = None
        self.share_subscription_object_id = None
        self.share_subscription_status = None


class ProviderShareSubscriptionList(_serialization.Model):
    """List response for get ShareSubscription.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: The Url of next result page.
    :vartype next_link: str
    :ivar value: Collection of items of type DataTransferObjects. Required.
    :vartype value: list[~azure.mgmt.datashare.models.ProviderShareSubscription]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ProviderShareSubscription]"},
    }

    def __init__(self, *, value: List["_models.ProviderShareSubscription"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The Url of next result page.
        :paramtype next_link: str
        :keyword value: Collection of items of type DataTransferObjects. Required.
        :paramtype value: list[~azure.mgmt.datashare.models.ProviderShareSubscription]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class SourceShareSynchronizationSetting(_serialization.Model):
    """A view of synchronization setting added by the provider.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ScheduledSourceSynchronizationSetting

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Kind of synchronization setting on share. Required. "ScheduleBased"
    :vartype kind: str or ~azure.mgmt.datashare.models.SourceShareSynchronizationSettingKind
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {"kind": {"ScheduleBased": "ScheduledSourceSynchronizationSetting"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind = None  # type: Optional[str]


class ScheduledSourceSynchronizationSetting(SourceShareSynchronizationSetting):
    """A type of synchronization setting based on schedule.

    All required parameters must be populated in order to send to Azure.

    :ivar kind: Kind of synchronization setting on share. Required. "ScheduleBased"
    :vartype kind: str or ~azure.mgmt.datashare.models.SourceShareSynchronizationSettingKind
    :ivar recurrence_interval: Recurrence Interval. Known values are: "Hour" and "Day".
    :vartype recurrence_interval: str or ~azure.mgmt.datashare.models.RecurrenceInterval
    :ivar synchronization_time: Synchronization time.
    :vartype synchronization_time: ~datetime.datetime
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
        "recurrence_interval": {"key": "properties.recurrenceInterval", "type": "str"},
        "synchronization_time": {"key": "properties.synchronizationTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        recurrence_interval: Optional[Union[str, "_models.RecurrenceInterval"]] = None,
        synchronization_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword recurrence_interval: Recurrence Interval. Known values are: "Hour" and "Day".
        :paramtype recurrence_interval: str or ~azure.mgmt.datashare.models.RecurrenceInterval
        :keyword synchronization_time: Synchronization time.
        :paramtype synchronization_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.kind = "ScheduleBased"  # type: str
        self.recurrence_interval = recurrence_interval
        self.synchronization_time = synchronization_time


class SynchronizationSetting(ProxyDto):
    """A Synchronization Setting data transfer object.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ScheduledSynchronizationSetting

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of synchronization setting. Required. "ScheduleBased"
    :vartype kind: str or ~azure.mgmt.datashare.models.SynchronizationSettingKind
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {"kind": {"ScheduleBased": "ScheduledSynchronizationSetting"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind = None  # type: Optional[str]


class ScheduledSynchronizationSetting(SynchronizationSetting):
    """A type of synchronization setting based on schedule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of synchronization setting. Required. "ScheduleBased"
    :vartype kind: str or ~azure.mgmt.datashare.models.SynchronizationSettingKind
    :ivar created_at: Time at which the synchronization setting was created.
    :vartype created_at: ~datetime.datetime
    :ivar provisioning_state: Gets or sets the provisioning state. Known values are: "Succeeded",
     "Creating", "Deleting", "Moving", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :ivar recurrence_interval: Recurrence Interval. Required. Known values are: "Hour" and "Day".
    :vartype recurrence_interval: str or ~azure.mgmt.datashare.models.RecurrenceInterval
    :ivar synchronization_time: Synchronization time. Required.
    :vartype synchronization_time: ~datetime.datetime
    :ivar user_name: Name of the user who created the synchronization setting.
    :vartype user_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "created_at": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "recurrence_interval": {"required": True},
        "synchronization_time": {"required": True},
        "user_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "created_at": {"key": "properties.createdAt", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "recurrence_interval": {"key": "properties.recurrenceInterval", "type": "str"},
        "synchronization_time": {"key": "properties.synchronizationTime", "type": "iso-8601"},
        "user_name": {"key": "properties.userName", "type": "str"},
    }

    def __init__(
        self,
        *,
        recurrence_interval: Union[str, "_models.RecurrenceInterval"],
        synchronization_time: datetime.datetime,
        **kwargs
    ):
        """
        :keyword recurrence_interval: Recurrence Interval. Required. Known values are: "Hour" and
         "Day".
        :paramtype recurrence_interval: str or ~azure.mgmt.datashare.models.RecurrenceInterval
        :keyword synchronization_time: Synchronization time. Required.
        :paramtype synchronization_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.kind = "ScheduleBased"  # type: str
        self.created_at = None
        self.provisioning_state = None
        self.recurrence_interval = recurrence_interval
        self.synchronization_time = synchronization_time
        self.user_name = None


class Trigger(ProxyDto):
    """A Trigger data transfer object.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ScheduledTrigger

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of synchronization on trigger. Required. "ScheduleBased"
    :vartype kind: str or ~azure.mgmt.datashare.models.TriggerKind
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {"kind": {"ScheduleBased": "ScheduledTrigger"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind = None  # type: Optional[str]


class ScheduledTrigger(Trigger):  # pylint: disable=too-many-instance-attributes
    """A type of trigger based on schedule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of synchronization on trigger. Required. "ScheduleBased"
    :vartype kind: str or ~azure.mgmt.datashare.models.TriggerKind
    :ivar created_at: Time at which the trigger was created.
    :vartype created_at: ~datetime.datetime
    :ivar provisioning_state: Gets the provisioning state. Known values are: "Succeeded",
     "Creating", "Deleting", "Moving", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :ivar recurrence_interval: Recurrence Interval. Required. Known values are: "Hour" and "Day".
    :vartype recurrence_interval: str or ~azure.mgmt.datashare.models.RecurrenceInterval
    :ivar synchronization_mode: Synchronization mode. Known values are: "Incremental" and
     "FullSync".
    :vartype synchronization_mode: str or ~azure.mgmt.datashare.models.SynchronizationMode
    :ivar synchronization_time: Synchronization time. Required.
    :vartype synchronization_time: ~datetime.datetime
    :ivar trigger_status: Gets the trigger state. Known values are: "Active", "Inactive", and
     "SourceSynchronizationSettingDeleted".
    :vartype trigger_status: str or ~azure.mgmt.datashare.models.TriggerStatus
    :ivar user_name: Name of the user who created the trigger.
    :vartype user_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "created_at": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "recurrence_interval": {"required": True},
        "synchronization_time": {"required": True},
        "trigger_status": {"readonly": True},
        "user_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "created_at": {"key": "properties.createdAt", "type": "iso-8601"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "recurrence_interval": {"key": "properties.recurrenceInterval", "type": "str"},
        "synchronization_mode": {"key": "properties.synchronizationMode", "type": "str"},
        "synchronization_time": {"key": "properties.synchronizationTime", "type": "iso-8601"},
        "trigger_status": {"key": "properties.triggerStatus", "type": "str"},
        "user_name": {"key": "properties.userName", "type": "str"},
    }

    def __init__(
        self,
        *,
        recurrence_interval: Union[str, "_models.RecurrenceInterval"],
        synchronization_time: datetime.datetime,
        synchronization_mode: Optional[Union[str, "_models.SynchronizationMode"]] = None,
        **kwargs
    ):
        """
        :keyword recurrence_interval: Recurrence Interval. Required. Known values are: "Hour" and
         "Day".
        :paramtype recurrence_interval: str or ~azure.mgmt.datashare.models.RecurrenceInterval
        :keyword synchronization_mode: Synchronization mode. Known values are: "Incremental" and
         "FullSync".
        :paramtype synchronization_mode: str or ~azure.mgmt.datashare.models.SynchronizationMode
        :keyword synchronization_time: Synchronization time. Required.
        :paramtype synchronization_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.kind = "ScheduleBased"  # type: str
        self.created_at = None
        self.provisioning_state = None
        self.recurrence_interval = recurrence_interval
        self.synchronization_mode = synchronization_mode
        self.synchronization_time = synchronization_time
        self.trigger_status = None
        self.user_name = None


class Share(ProxyDto):  # pylint: disable=too-many-instance-attributes
    """A share data transfer object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar created_at: Time at which the share was created.
    :vartype created_at: ~datetime.datetime
    :ivar description: Share description.
    :vartype description: str
    :ivar provisioning_state: Gets or sets the provisioning state. Known values are: "Succeeded",
     "Creating", "Deleting", "Moving", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :ivar share_kind: Share kind. Known values are: "CopyBased" and "InPlace".
    :vartype share_kind: str or ~azure.mgmt.datashare.models.ShareKind
    :ivar terms: Share terms.
    :vartype terms: str
    :ivar user_email: Email of the user who created the resource.
    :vartype user_email: str
    :ivar user_name: Name of the user who created the resource.
    :vartype user_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "created_at": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "user_email": {"readonly": True},
        "user_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "created_at": {"key": "properties.createdAt", "type": "iso-8601"},
        "description": {"key": "properties.description", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "share_kind": {"key": "properties.shareKind", "type": "str"},
        "terms": {"key": "properties.terms", "type": "str"},
        "user_email": {"key": "properties.userEmail", "type": "str"},
        "user_name": {"key": "properties.userName", "type": "str"},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        share_kind: Optional[Union[str, "_models.ShareKind"]] = None,
        terms: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword description: Share description.
        :paramtype description: str
        :keyword share_kind: Share kind. Known values are: "CopyBased" and "InPlace".
        :paramtype share_kind: str or ~azure.mgmt.datashare.models.ShareKind
        :keyword terms: Share terms.
        :paramtype terms: str
        """
        super().__init__(**kwargs)
        self.created_at = None
        self.description = description
        self.provisioning_state = None
        self.share_kind = share_kind
        self.terms = terms
        self.user_email = None
        self.user_name = None


class ShareList(_serialization.Model):
    """List response for get Shares.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: The Url of next result page.
    :vartype next_link: str
    :ivar value: Collection of items of type DataTransferObjects. Required.
    :vartype value: list[~azure.mgmt.datashare.models.Share]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Share]"},
    }

    def __init__(self, *, value: List["_models.Share"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The Url of next result page.
        :paramtype next_link: str
        :keyword value: Collection of items of type DataTransferObjects. Required.
        :paramtype value: list[~azure.mgmt.datashare.models.Share]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ShareSubscription(ProxyDto):  # pylint: disable=too-many-instance-attributes
    """A share subscription data transfer object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar created_at: Time at which the share subscription was created.
    :vartype created_at: ~datetime.datetime
    :ivar expiration_date: The expiration date of the share subscription.
    :vartype expiration_date: ~datetime.datetime
    :ivar invitation_id: The invitation id. Required.
    :vartype invitation_id: str
    :ivar provider_email: Email of the provider who created the resource.
    :vartype provider_email: str
    :ivar provider_name: Name of the provider who created the resource.
    :vartype provider_name: str
    :ivar provider_tenant_name: Tenant name of the provider who created the resource.
    :vartype provider_tenant_name: str
    :ivar provisioning_state: Provisioning state of the share subscription. Known values are:
     "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :ivar share_description: Description of share.
    :vartype share_description: str
    :ivar share_kind: Kind of share. Known values are: "CopyBased" and "InPlace".
    :vartype share_kind: str or ~azure.mgmt.datashare.models.ShareKind
    :ivar share_name: Name of the share.
    :vartype share_name: str
    :ivar share_subscription_status: Gets the current status of share subscription. Known values
     are: "Active", "Revoked", "SourceDeleted", and "Revoking".
    :vartype share_subscription_status: str or ~azure.mgmt.datashare.models.ShareSubscriptionStatus
    :ivar share_terms: Terms of a share.
    :vartype share_terms: str
    :ivar source_share_location: Source share location. Required.
    :vartype source_share_location: str
    :ivar user_email: Email of the user who created the resource.
    :vartype user_email: str
    :ivar user_name: Name of the user who created the resource.
    :vartype user_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "created_at": {"readonly": True},
        "invitation_id": {"required": True},
        "provider_email": {"readonly": True},
        "provider_name": {"readonly": True},
        "provider_tenant_name": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "share_description": {"readonly": True},
        "share_kind": {"readonly": True},
        "share_name": {"readonly": True},
        "share_subscription_status": {"readonly": True},
        "share_terms": {"readonly": True},
        "source_share_location": {"required": True},
        "user_email": {"readonly": True},
        "user_name": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "created_at": {"key": "properties.createdAt", "type": "iso-8601"},
        "expiration_date": {"key": "properties.expirationDate", "type": "iso-8601"},
        "invitation_id": {"key": "properties.invitationId", "type": "str"},
        "provider_email": {"key": "properties.providerEmail", "type": "str"},
        "provider_name": {"key": "properties.providerName", "type": "str"},
        "provider_tenant_name": {"key": "properties.providerTenantName", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "share_description": {"key": "properties.shareDescription", "type": "str"},
        "share_kind": {"key": "properties.shareKind", "type": "str"},
        "share_name": {"key": "properties.shareName", "type": "str"},
        "share_subscription_status": {"key": "properties.shareSubscriptionStatus", "type": "str"},
        "share_terms": {"key": "properties.shareTerms", "type": "str"},
        "source_share_location": {"key": "properties.sourceShareLocation", "type": "str"},
        "user_email": {"key": "properties.userEmail", "type": "str"},
        "user_name": {"key": "properties.userName", "type": "str"},
    }

    def __init__(
        self,
        *,
        invitation_id: str,
        source_share_location: str,
        expiration_date: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword expiration_date: The expiration date of the share subscription.
        :paramtype expiration_date: ~datetime.datetime
        :keyword invitation_id: The invitation id. Required.
        :paramtype invitation_id: str
        :keyword source_share_location: Source share location. Required.
        :paramtype source_share_location: str
        """
        super().__init__(**kwargs)
        self.created_at = None
        self.expiration_date = expiration_date
        self.invitation_id = invitation_id
        self.provider_email = None
        self.provider_name = None
        self.provider_tenant_name = None
        self.provisioning_state = None
        self.share_description = None
        self.share_kind = None
        self.share_name = None
        self.share_subscription_status = None
        self.share_terms = None
        self.source_share_location = source_share_location
        self.user_email = None
        self.user_name = None


class ShareSubscriptionList(_serialization.Model):
    """List response for get ShareSubscription.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: The Url of next result page.
    :vartype next_link: str
    :ivar value: Collection of items of type DataTransferObjects. Required.
    :vartype value: list[~azure.mgmt.datashare.models.ShareSubscription]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ShareSubscription]"},
    }

    def __init__(self, *, value: List["_models.ShareSubscription"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The Url of next result page.
        :paramtype next_link: str
        :keyword value: Collection of items of type DataTransferObjects. Required.
        :paramtype value: list[~azure.mgmt.datashare.models.ShareSubscription]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ShareSubscriptionSynchronization(_serialization.Model):
    """A ShareSubscriptionSynchronization data transfer object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar duration_ms: Synchronization duration.
    :vartype duration_ms: int
    :ivar end_time: End time of synchronization.
    :vartype end_time: ~datetime.datetime
    :ivar message: message of Synchronization.
    :vartype message: str
    :ivar start_time: start time of synchronization.
    :vartype start_time: ~datetime.datetime
    :ivar status: Raw Status.
    :vartype status: str
    :ivar synchronization_id: Synchronization id. Required.
    :vartype synchronization_id: str
    :ivar synchronization_mode: Synchronization Mode. Known values are: "Incremental" and
     "FullSync".
    :vartype synchronization_mode: str or ~azure.mgmt.datashare.models.SynchronizationMode
    """

    _validation = {
        "duration_ms": {"readonly": True},
        "end_time": {"readonly": True},
        "message": {"readonly": True},
        "start_time": {"readonly": True},
        "status": {"readonly": True},
        "synchronization_id": {"required": True},
        "synchronization_mode": {"readonly": True},
    }

    _attribute_map = {
        "duration_ms": {"key": "durationMs", "type": "int"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "message": {"key": "message", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "synchronization_id": {"key": "synchronizationId", "type": "str"},
        "synchronization_mode": {"key": "synchronizationMode", "type": "str"},
    }

    def __init__(self, *, synchronization_id: str, **kwargs):
        """
        :keyword synchronization_id: Synchronization id. Required.
        :paramtype synchronization_id: str
        """
        super().__init__(**kwargs)
        self.duration_ms = None
        self.end_time = None
        self.message = None
        self.start_time = None
        self.status = None
        self.synchronization_id = synchronization_id
        self.synchronization_mode = None


class ShareSubscriptionSynchronizationList(_serialization.Model):
    """A consumer side list of share subscription synchronizations.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: The Url of next result page.
    :vartype next_link: str
    :ivar value: Collection of items of type DataTransferObjects. Required.
    :vartype value: list[~azure.mgmt.datashare.models.ShareSubscriptionSynchronization]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ShareSubscriptionSynchronization]"},
    }

    def __init__(
        self, *, value: List["_models.ShareSubscriptionSynchronization"], next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword next_link: The Url of next result page.
        :paramtype next_link: str
        :keyword value: Collection of items of type DataTransferObjects. Required.
        :paramtype value: list[~azure.mgmt.datashare.models.ShareSubscriptionSynchronization]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class ShareSynchronization(_serialization.Model):
    """A ShareSynchronization data transfer object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar consumer_email: Email of the user who created the synchronization.
    :vartype consumer_email: str
    :ivar consumer_name: Name of the user who created the synchronization.
    :vartype consumer_name: str
    :ivar consumer_tenant_name: Tenant name of the consumer who created the synchronization.
    :vartype consumer_tenant_name: str
    :ivar duration_ms: synchronization duration.
    :vartype duration_ms: int
    :ivar end_time: End time of synchronization.
    :vartype end_time: ~datetime.datetime
    :ivar message: message of synchronization.
    :vartype message: str
    :ivar start_time: start time of synchronization.
    :vartype start_time: ~datetime.datetime
    :ivar status: Raw Status.
    :vartype status: str
    :ivar synchronization_id: Synchronization id.
    :vartype synchronization_id: str
    :ivar synchronization_mode: Synchronization mode. Known values are: "Incremental" and
     "FullSync".
    :vartype synchronization_mode: str or ~azure.mgmt.datashare.models.SynchronizationMode
    """

    _validation = {
        "synchronization_mode": {"readonly": True},
    }

    _attribute_map = {
        "consumer_email": {"key": "consumerEmail", "type": "str"},
        "consumer_name": {"key": "consumerName", "type": "str"},
        "consumer_tenant_name": {"key": "consumerTenantName", "type": "str"},
        "duration_ms": {"key": "durationMs", "type": "int"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "message": {"key": "message", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "synchronization_id": {"key": "synchronizationId", "type": "str"},
        "synchronization_mode": {"key": "synchronizationMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        consumer_email: Optional[str] = None,
        consumer_name: Optional[str] = None,
        consumer_tenant_name: Optional[str] = None,
        duration_ms: Optional[int] = None,
        end_time: Optional[datetime.datetime] = None,
        message: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        status: Optional[str] = None,
        synchronization_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword consumer_email: Email of the user who created the synchronization.
        :paramtype consumer_email: str
        :keyword consumer_name: Name of the user who created the synchronization.
        :paramtype consumer_name: str
        :keyword consumer_tenant_name: Tenant name of the consumer who created the synchronization.
        :paramtype consumer_tenant_name: str
        :keyword duration_ms: synchronization duration.
        :paramtype duration_ms: int
        :keyword end_time: End time of synchronization.
        :paramtype end_time: ~datetime.datetime
        :keyword message: message of synchronization.
        :paramtype message: str
        :keyword start_time: start time of synchronization.
        :paramtype start_time: ~datetime.datetime
        :keyword status: Raw Status.
        :paramtype status: str
        :keyword synchronization_id: Synchronization id.
        :paramtype synchronization_id: str
        """
        super().__init__(**kwargs)
        self.consumer_email = consumer_email
        self.consumer_name = consumer_name
        self.consumer_tenant_name = consumer_tenant_name
        self.duration_ms = duration_ms
        self.end_time = end_time
        self.message = message
        self.start_time = start_time
        self.status = status
        self.synchronization_id = synchronization_id
        self.synchronization_mode = None


class ShareSynchronizationList(_serialization.Model):
    """List response for get ShareSynchronization.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: The Url of next result page.
    :vartype next_link: str
    :ivar value: Collection of items of type DataTransferObjects. Required.
    :vartype value: list[~azure.mgmt.datashare.models.ShareSynchronization]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ShareSynchronization]"},
    }

    def __init__(self, *, value: List["_models.ShareSynchronization"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The Url of next result page.
        :paramtype next_link: str
        :keyword value: Collection of items of type DataTransferObjects. Required.
        :paramtype value: list[~azure.mgmt.datashare.models.ShareSynchronization]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class SourceShareSynchronizationSettingList(_serialization.Model):
    """List response for get source share Synchronization settings.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: The Url of next result page.
    :vartype next_link: str
    :ivar value: Collection of items of type DataTransferObjects. Required.
    :vartype value: list[~azure.mgmt.datashare.models.SourceShareSynchronizationSetting]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[SourceShareSynchronizationSetting]"},
    }

    def __init__(
        self, *, value: List["_models.SourceShareSynchronizationSetting"], next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword next_link: The Url of next result page.
        :paramtype next_link: str
        :keyword value: Collection of items of type DataTransferObjects. Required.
        :paramtype value: list[~azure.mgmt.datashare.models.SourceShareSynchronizationSetting]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class SqlDBTableDataSet(DataSet):
    """A SQL DB table data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set. Required. Known values are: "Blob", "Container", "BlobFolder",
     "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File",
     "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable", and
     "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetKind
    :ivar database_name: Database name of the source data set.
    :vartype database_name: str
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :ivar schema_name: Schema of the table. Default value is dbo.
    :vartype schema_name: str
    :ivar sql_server_resource_id: Resource id of SQL server.
    :vartype sql_server_resource_id: str
    :ivar table_name: SQL DB table name.
    :vartype table_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "data_set_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "database_name": {"key": "properties.databaseName", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "schema_name": {"key": "properties.schemaName", "type": "str"},
        "sql_server_resource_id": {"key": "properties.sqlServerResourceId", "type": "str"},
        "table_name": {"key": "properties.tableName", "type": "str"},
    }

    def __init__(
        self,
        *,
        database_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        sql_server_resource_id: Optional[str] = None,
        table_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword database_name: Database name of the source data set.
        :paramtype database_name: str
        :keyword schema_name: Schema of the table. Default value is dbo.
        :paramtype schema_name: str
        :keyword sql_server_resource_id: Resource id of SQL server.
        :paramtype sql_server_resource_id: str
        :keyword table_name: SQL DB table name.
        :paramtype table_name: str
        """
        super().__init__(**kwargs)
        self.kind = "SqlDBTable"  # type: str
        self.database_name = database_name
        self.data_set_id = None
        self.schema_name = schema_name
        self.sql_server_resource_id = sql_server_resource_id
        self.table_name = table_name


class SqlDBTableDataSetMapping(DataSetMapping):  # pylint: disable=too-many-instance-attributes
    """A SQL DB Table data set mapping.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set mapping. Required. Known values are: "Blob", "Container",
     "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "KustoCluster",
     "KustoDatabase", "SqlDBTable", "SqlDWTable", and "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetMappingKind
    :ivar database_name: DatabaseName name of the sink data set. Required.
    :vartype database_name: str
    :ivar data_set_id: The id of the source data set. Required.
    :vartype data_set_id: str
    :ivar data_set_mapping_status: Gets the status of the data set mapping. Known values are: "Ok"
     and "Broken".
    :vartype data_set_mapping_status: str or ~azure.mgmt.datashare.models.DataSetMappingStatus
    :ivar provisioning_state: Provisioning state of the data set mapping. Known values are:
     "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :ivar schema_name: Schema of the table. Default value is dbo. Required.
    :vartype schema_name: str
    :ivar sql_server_resource_id: Resource id of SQL server. Required.
    :vartype sql_server_resource_id: str
    :ivar table_name: SQL DB table name. Required.
    :vartype table_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "database_name": {"required": True},
        "data_set_id": {"required": True},
        "data_set_mapping_status": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "schema_name": {"required": True},
        "sql_server_resource_id": {"required": True},
        "table_name": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "database_name": {"key": "properties.databaseName", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "data_set_mapping_status": {"key": "properties.dataSetMappingStatus", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "schema_name": {"key": "properties.schemaName", "type": "str"},
        "sql_server_resource_id": {"key": "properties.sqlServerResourceId", "type": "str"},
        "table_name": {"key": "properties.tableName", "type": "str"},
    }

    def __init__(
        self,
        *,
        database_name: str,
        data_set_id: str,
        schema_name: str,
        sql_server_resource_id: str,
        table_name: str,
        **kwargs
    ):
        """
        :keyword database_name: DatabaseName name of the sink data set. Required.
        :paramtype database_name: str
        :keyword data_set_id: The id of the source data set. Required.
        :paramtype data_set_id: str
        :keyword schema_name: Schema of the table. Default value is dbo. Required.
        :paramtype schema_name: str
        :keyword sql_server_resource_id: Resource id of SQL server. Required.
        :paramtype sql_server_resource_id: str
        :keyword table_name: SQL DB table name. Required.
        :paramtype table_name: str
        """
        super().__init__(**kwargs)
        self.kind = "SqlDBTable"  # type: str
        self.database_name = database_name
        self.data_set_id = data_set_id
        self.data_set_mapping_status = None
        self.provisioning_state = None
        self.schema_name = schema_name
        self.sql_server_resource_id = sql_server_resource_id
        self.table_name = table_name


class SqlDWTableDataSet(DataSet):
    """A SQL DW table data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set. Required. Known values are: "Blob", "Container", "BlobFolder",
     "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File",
     "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable", and
     "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetKind
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :ivar data_warehouse_name: DataWarehouse name of the source data set.
    :vartype data_warehouse_name: str
    :ivar schema_name: Schema of the table. Default value is dbo.
    :vartype schema_name: str
    :ivar sql_server_resource_id: Resource id of SQL server.
    :vartype sql_server_resource_id: str
    :ivar table_name: SQL DW table name.
    :vartype table_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "data_set_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "data_warehouse_name": {"key": "properties.dataWarehouseName", "type": "str"},
        "schema_name": {"key": "properties.schemaName", "type": "str"},
        "sql_server_resource_id": {"key": "properties.sqlServerResourceId", "type": "str"},
        "table_name": {"key": "properties.tableName", "type": "str"},
    }

    def __init__(
        self,
        *,
        data_warehouse_name: Optional[str] = None,
        schema_name: Optional[str] = None,
        sql_server_resource_id: Optional[str] = None,
        table_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword data_warehouse_name: DataWarehouse name of the source data set.
        :paramtype data_warehouse_name: str
        :keyword schema_name: Schema of the table. Default value is dbo.
        :paramtype schema_name: str
        :keyword sql_server_resource_id: Resource id of SQL server.
        :paramtype sql_server_resource_id: str
        :keyword table_name: SQL DW table name.
        :paramtype table_name: str
        """
        super().__init__(**kwargs)
        self.kind = "SqlDWTable"  # type: str
        self.data_set_id = None
        self.data_warehouse_name = data_warehouse_name
        self.schema_name = schema_name
        self.sql_server_resource_id = sql_server_resource_id
        self.table_name = table_name


class SqlDWTableDataSetMapping(DataSetMapping):  # pylint: disable=too-many-instance-attributes
    """A SQL DW Table data set mapping.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set mapping. Required. Known values are: "Blob", "Container",
     "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "KustoCluster",
     "KustoDatabase", "SqlDBTable", "SqlDWTable", and "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetMappingKind
    :ivar data_set_id: The id of the source data set. Required.
    :vartype data_set_id: str
    :ivar data_set_mapping_status: Gets the status of the data set mapping. Known values are: "Ok"
     and "Broken".
    :vartype data_set_mapping_status: str or ~azure.mgmt.datashare.models.DataSetMappingStatus
    :ivar data_warehouse_name: DataWarehouse name of the source data set. Required.
    :vartype data_warehouse_name: str
    :ivar provisioning_state: Provisioning state of the data set mapping. Known values are:
     "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :ivar schema_name: Schema of the table. Default value is dbo. Required.
    :vartype schema_name: str
    :ivar sql_server_resource_id: Resource id of SQL server. Required.
    :vartype sql_server_resource_id: str
    :ivar table_name: SQL DW table name. Required.
    :vartype table_name: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "data_set_id": {"required": True},
        "data_set_mapping_status": {"readonly": True},
        "data_warehouse_name": {"required": True},
        "provisioning_state": {"readonly": True},
        "schema_name": {"required": True},
        "sql_server_resource_id": {"required": True},
        "table_name": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "data_set_mapping_status": {"key": "properties.dataSetMappingStatus", "type": "str"},
        "data_warehouse_name": {"key": "properties.dataWarehouseName", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "schema_name": {"key": "properties.schemaName", "type": "str"},
        "sql_server_resource_id": {"key": "properties.sqlServerResourceId", "type": "str"},
        "table_name": {"key": "properties.tableName", "type": "str"},
    }

    def __init__(
        self,
        *,
        data_set_id: str,
        data_warehouse_name: str,
        schema_name: str,
        sql_server_resource_id: str,
        table_name: str,
        **kwargs
    ):
        """
        :keyword data_set_id: The id of the source data set. Required.
        :paramtype data_set_id: str
        :keyword data_warehouse_name: DataWarehouse name of the source data set. Required.
        :paramtype data_warehouse_name: str
        :keyword schema_name: Schema of the table. Default value is dbo. Required.
        :paramtype schema_name: str
        :keyword sql_server_resource_id: Resource id of SQL server. Required.
        :paramtype sql_server_resource_id: str
        :keyword table_name: SQL DW table name. Required.
        :paramtype table_name: str
        """
        super().__init__(**kwargs)
        self.kind = "SqlDWTable"  # type: str
        self.data_set_id = data_set_id
        self.data_set_mapping_status = None
        self.data_warehouse_name = data_warehouse_name
        self.provisioning_state = None
        self.schema_name = schema_name
        self.sql_server_resource_id = sql_server_resource_id
        self.table_name = table_name


class SynapseWorkspaceSqlPoolTableDataSet(DataSet):
    """A Synapse Workspace Sql Pool Table data set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set. Required. Known values are: "Blob", "Container", "BlobFolder",
     "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File",
     "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable", and
     "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetKind
    :ivar data_set_id: Unique id for identifying a data set resource.
    :vartype data_set_id: str
    :ivar synapse_workspace_sql_pool_table_resource_id: Resource id of the Synapse Workspace SQL
     Pool Table. Required.
    :vartype synapse_workspace_sql_pool_table_resource_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "data_set_id": {"readonly": True},
        "synapse_workspace_sql_pool_table_resource_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "synapse_workspace_sql_pool_table_resource_id": {
            "key": "properties.synapseWorkspaceSqlPoolTableResourceId",
            "type": "str",
        },
    }

    def __init__(self, *, synapse_workspace_sql_pool_table_resource_id: str, **kwargs):
        """
        :keyword synapse_workspace_sql_pool_table_resource_id: Resource id of the Synapse Workspace SQL
         Pool Table. Required.
        :paramtype synapse_workspace_sql_pool_table_resource_id: str
        """
        super().__init__(**kwargs)
        self.kind = "SynapseWorkspaceSqlPoolTable"  # type: str
        self.data_set_id = None
        self.synapse_workspace_sql_pool_table_resource_id = synapse_workspace_sql_pool_table_resource_id


class SynapseWorkspaceSqlPoolTableDataSetMapping(DataSetMapping):
    """A Synapse Workspace Sql Pool Table data set mapping.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource id of the azure resource.
    :vartype id: str
    :ivar name: Name of the azure resource.
    :vartype name: str
    :ivar system_data: System Data of the Azure resource.
    :vartype system_data: ~azure.mgmt.datashare.models.SystemData
    :ivar type: Type of the azure resource.
    :vartype type: str
    :ivar kind: Kind of data set mapping. Required. Known values are: "Blob", "Container",
     "BlobFolder", "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "KustoCluster",
     "KustoDatabase", "SqlDBTable", "SqlDWTable", and "SynapseWorkspaceSqlPoolTable".
    :vartype kind: str or ~azure.mgmt.datashare.models.DataSetMappingKind
    :ivar data_set_id: The id of the source data set. Required.
    :vartype data_set_id: str
    :ivar data_set_mapping_status: Gets the status of the data set mapping. Known values are: "Ok"
     and "Broken".
    :vartype data_set_mapping_status: str or ~azure.mgmt.datashare.models.DataSetMappingStatus
    :ivar provisioning_state: Provisioning state of the data set mapping. Known values are:
     "Succeeded", "Creating", "Deleting", "Moving", and "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.datashare.models.ProvisioningState
    :ivar synapse_workspace_sql_pool_table_resource_id: Resource id of the Synapse Workspace SQL
     Pool Table. Required.
    :vartype synapse_workspace_sql_pool_table_resource_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "system_data": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "data_set_id": {"required": True},
        "data_set_mapping_status": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "synapse_workspace_sql_pool_table_resource_id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "data_set_id": {"key": "properties.dataSetId", "type": "str"},
        "data_set_mapping_status": {"key": "properties.dataSetMappingStatus", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "synapse_workspace_sql_pool_table_resource_id": {
            "key": "properties.synapseWorkspaceSqlPoolTableResourceId",
            "type": "str",
        },
    }

    def __init__(self, *, data_set_id: str, synapse_workspace_sql_pool_table_resource_id: str, **kwargs):
        """
        :keyword data_set_id: The id of the source data set. Required.
        :paramtype data_set_id: str
        :keyword synapse_workspace_sql_pool_table_resource_id: Resource id of the Synapse Workspace SQL
         Pool Table. Required.
        :paramtype synapse_workspace_sql_pool_table_resource_id: str
        """
        super().__init__(**kwargs)
        self.kind = "SynapseWorkspaceSqlPoolTable"  # type: str
        self.data_set_id = data_set_id
        self.data_set_mapping_status = None
        self.provisioning_state = None
        self.synapse_workspace_sql_pool_table_resource_id = synapse_workspace_sql_pool_table_resource_id


class SynchronizationDetails(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Synchronization details at data set level.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar data_set_id: Id of data set.
    :vartype data_set_id: str
    :ivar data_set_type: Type of the data set. Known values are: "Blob", "Container", "BlobFolder",
     "AdlsGen2FileSystem", "AdlsGen2Folder", "AdlsGen2File", "AdlsGen1Folder", "AdlsGen1File",
     "KustoCluster", "KustoDatabase", "SqlDBTable", "SqlDWTable", and
     "SynapseWorkspaceSqlPoolTable".
    :vartype data_set_type: str or ~azure.mgmt.datashare.models.DataSetType
    :ivar duration_ms: Duration of data set level copy.
    :vartype duration_ms: int
    :ivar end_time: End time of data set level copy.
    :vartype end_time: ~datetime.datetime
    :ivar files_read: The number of files read from the source data set.
    :vartype files_read: int
    :ivar files_written: The number of files written into the sink data set.
    :vartype files_written: int
    :ivar message: Error message if any.
    :vartype message: str
    :ivar name: Name of the data set.
    :vartype name: str
    :ivar rows_copied: The number of files copied into the sink data set.
    :vartype rows_copied: int
    :ivar rows_read: The number of rows read from the source data set.
    :vartype rows_read: int
    :ivar size_read: The size of the data read from the source data set in bytes.
    :vartype size_read: int
    :ivar size_written: The size of the data written into the sink data set in bytes.
    :vartype size_written: int
    :ivar start_time: Start time of data set level copy.
    :vartype start_time: ~datetime.datetime
    :ivar status: Raw Status.
    :vartype status: str
    :ivar v_core: The vCore units consumed for the data set synchronization.
    :vartype v_core: int
    """

    _validation = {
        "data_set_id": {"readonly": True},
        "data_set_type": {"readonly": True},
        "duration_ms": {"readonly": True},
        "end_time": {"readonly": True},
        "files_read": {"readonly": True},
        "files_written": {"readonly": True},
        "message": {"readonly": True},
        "name": {"readonly": True},
        "rows_copied": {"readonly": True},
        "rows_read": {"readonly": True},
        "size_read": {"readonly": True},
        "size_written": {"readonly": True},
        "start_time": {"readonly": True},
        "status": {"readonly": True},
        "v_core": {"readonly": True},
    }

    _attribute_map = {
        "data_set_id": {"key": "dataSetId", "type": "str"},
        "data_set_type": {"key": "dataSetType", "type": "str"},
        "duration_ms": {"key": "durationMs", "type": "int"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "files_read": {"key": "filesRead", "type": "int"},
        "files_written": {"key": "filesWritten", "type": "int"},
        "message": {"key": "message", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "rows_copied": {"key": "rowsCopied", "type": "int"},
        "rows_read": {"key": "rowsRead", "type": "int"},
        "size_read": {"key": "sizeRead", "type": "int"},
        "size_written": {"key": "sizeWritten", "type": "int"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "v_core": {"key": "vCore", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.data_set_id = None
        self.data_set_type = None
        self.duration_ms = None
        self.end_time = None
        self.files_read = None
        self.files_written = None
        self.message = None
        self.name = None
        self.rows_copied = None
        self.rows_read = None
        self.size_read = None
        self.size_written = None
        self.start_time = None
        self.status = None
        self.v_core = None


class SynchronizationDetailsList(_serialization.Model):
    """details of synchronization.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: The Url of next result page.
    :vartype next_link: str
    :ivar value: Collection of items of type DataTransferObjects. Required.
    :vartype value: list[~azure.mgmt.datashare.models.SynchronizationDetails]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[SynchronizationDetails]"},
    }

    def __init__(self, *, value: List["_models.SynchronizationDetails"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The Url of next result page.
        :paramtype next_link: str
        :keyword value: Collection of items of type DataTransferObjects. Required.
        :paramtype value: list[~azure.mgmt.datashare.models.SynchronizationDetails]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class SynchronizationSettingList(_serialization.Model):
    """List response for get Synchronization settings.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: The Url of next result page.
    :vartype next_link: str
    :ivar value: Collection of items of type DataTransferObjects. Required.
    :vartype value: list[~azure.mgmt.datashare.models.SynchronizationSetting]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[SynchronizationSetting]"},
    }

    def __init__(self, *, value: List["_models.SynchronizationSetting"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The Url of next result page.
        :paramtype next_link: str
        :keyword value: Collection of items of type DataTransferObjects. Required.
        :paramtype value: list[~azure.mgmt.datashare.models.SynchronizationSetting]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class Synchronize(_serialization.Model):
    """Payload for the synchronizing the data.

    :ivar synchronization_mode: Mode of synchronization used in triggers and snapshot sync.
     Incremental by default. Known values are: "Incremental" and "FullSync".
    :vartype synchronization_mode: str or ~azure.mgmt.datashare.models.SynchronizationMode
    """

    _attribute_map = {
        "synchronization_mode": {"key": "synchronizationMode", "type": "str"},
    }

    def __init__(self, *, synchronization_mode: Optional[Union[str, "_models.SynchronizationMode"]] = None, **kwargs):
        """
        :keyword synchronization_mode: Mode of synchronization used in triggers and snapshot sync.
         Incremental by default. Known values are: "Incremental" and "FullSync".
        :paramtype synchronization_mode: str or ~azure.mgmt.datashare.models.SynchronizationMode
        """
        super().__init__(**kwargs)
        self.synchronization_mode = synchronization_mode


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.datashare.models.CreatedByType
    :ivar last_modified_at: The type of identity that last modified the resource.
    :vartype last_modified_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.datashare.models.LastModifiedByType
    """

    _attribute_map = {
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
    }

    def __init__(
        self,
        *,
        created_at: Optional[datetime.datetime] = None,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.LastModifiedByType"]] = None,
        **kwargs
    ):
        """
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.datashare.models.CreatedByType
        :keyword last_modified_at: The type of identity that last modified the resource.
        :paramtype last_modified_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.datashare.models.LastModifiedByType
        """
        super().__init__(**kwargs)
        self.created_at = created_at
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.last_modified_at = last_modified_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type


class TriggerList(_serialization.Model):
    """List response for get triggers.

    All required parameters must be populated in order to send to Azure.

    :ivar next_link: The Url of next result page.
    :vartype next_link: str
    :ivar value: Collection of items of type DataTransferObjects. Required.
    :vartype value: list[~azure.mgmt.datashare.models.Trigger]
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[Trigger]"},
    }

    def __init__(self, *, value: List["_models.Trigger"], next_link: Optional[str] = None, **kwargs):
        """
        :keyword next_link: The Url of next result page.
        :paramtype next_link: str
        :keyword value: Collection of items of type DataTransferObjects. Required.
        :paramtype value: list[~azure.mgmt.datashare.models.Trigger]
        """
        super().__init__(**kwargs)
        self.next_link = next_link
        self.value = value
