# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, Optional, TYPE_CHECKING, cast
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.settings import settings
from azure.mgmt.core import AsyncARMPipelineClient
from azure.mgmt.core.policies import AsyncARMAutoResourceProviderRegistrationPolicy
from azure.mgmt.core.tools import get_arm_endpoints

from .. import models as _models
from .._utils.serialization import Deserializer, Serializer
from ._configuration import MonitorManagementClientConfiguration
from .operations import (
    ActionGroupsOperations,
    ActivityLogAlertsOperations,
    ActivityLogsOperations,
    AlertRuleIncidentsOperations,
    AutoscaleSettingsOperations,
    AzureMonitorWorkspacesOperations,
    BaselinesOperations,
    DataCollectionEndpointsOperations,
    DataCollectionRuleAssociationsOperations,
    DataCollectionRulesOperations,
    DiagnosticSettingsCategoryOperations,
    DiagnosticSettingsOperations,
    EventCategoriesOperations,
    GuestDiagnosticsSettingsAssociationOperations,
    GuestDiagnosticsSettingsOperations,
    LogProfilesOperations,
    MetricAlertsOperations,
    MetricAlertsStatusOperations,
    MetricDefinitionsOperations,
    MetricNamespacesOperations,
    MetricsOperations,
    MonitorOperationsOperations,
    Operations,
    PredictiveMetricOperations,
    PrivateEndpointConnectionsOperations,
    PrivateLinkResourcesOperations,
    PrivateLinkScopeOperationStatusOperations,
    PrivateLinkScopedResourcesOperations,
    PrivateLinkScopesOperations,
    ScheduledQueryRulesOperations,
    ServiceDiagnosticSettingsOperations,
    SubscriptionDiagnosticSettingsOperations,
    TenantActivityLogsOperations,
    VMInsightsOperations,
)

if TYPE_CHECKING:
    from azure.core.credentials_async import AsyncTokenCredential


class MonitorManagementClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """Monitor Management Client.

    :ivar action_groups: ActionGroupsOperations operations
    :vartype action_groups: azure.mgmt.monitor.aio.operations.ActionGroupsOperations
    :ivar activity_log_alerts: ActivityLogAlertsOperations operations
    :vartype activity_log_alerts: azure.mgmt.monitor.aio.operations.ActivityLogAlertsOperations
    :ivar activity_logs: ActivityLogsOperations operations
    :vartype activity_logs: azure.mgmt.monitor.aio.operations.ActivityLogsOperations
    :ivar tenant_activity_logs: TenantActivityLogsOperations operations
    :vartype tenant_activity_logs: azure.mgmt.monitor.aio.operations.TenantActivityLogsOperations
    :ivar alert_rule_incidents: AlertRuleIncidentsOperations operations
    :vartype alert_rule_incidents: azure.mgmt.monitor.aio.operations.AlertRuleIncidentsOperations
    :ivar autoscale_settings: AutoscaleSettingsOperations operations
    :vartype autoscale_settings: azure.mgmt.monitor.aio.operations.AutoscaleSettingsOperations
    :ivar predictive_metric: PredictiveMetricOperations operations
    :vartype predictive_metric: azure.mgmt.monitor.aio.operations.PredictiveMetricOperations
    :ivar baselines: BaselinesOperations operations
    :vartype baselines: azure.mgmt.monitor.aio.operations.BaselinesOperations
    :ivar diagnostic_settings: DiagnosticSettingsOperations operations
    :vartype diagnostic_settings: azure.mgmt.monitor.aio.operations.DiagnosticSettingsOperations
    :ivar diagnostic_settings_category: DiagnosticSettingsCategoryOperations operations
    :vartype diagnostic_settings_category:
     azure.mgmt.monitor.aio.operations.DiagnosticSettingsCategoryOperations
    :ivar event_categories: EventCategoriesOperations operations
    :vartype event_categories: azure.mgmt.monitor.aio.operations.EventCategoriesOperations
    :ivar guest_diagnostics_settings: GuestDiagnosticsSettingsOperations operations
    :vartype guest_diagnostics_settings:
     azure.mgmt.monitor.aio.operations.GuestDiagnosticsSettingsOperations
    :ivar guest_diagnostics_settings_association: GuestDiagnosticsSettingsAssociationOperations
     operations
    :vartype guest_diagnostics_settings_association:
     azure.mgmt.monitor.aio.operations.GuestDiagnosticsSettingsAssociationOperations
    :ivar log_profiles: LogProfilesOperations operations
    :vartype log_profiles: azure.mgmt.monitor.aio.operations.LogProfilesOperations
    :ivar metric_alerts: MetricAlertsOperations operations
    :vartype metric_alerts: azure.mgmt.monitor.aio.operations.MetricAlertsOperations
    :ivar metric_alerts_status: MetricAlertsStatusOperations operations
    :vartype metric_alerts_status: azure.mgmt.monitor.aio.operations.MetricAlertsStatusOperations
    :ivar metric_definitions: MetricDefinitionsOperations operations
    :vartype metric_definitions: azure.mgmt.monitor.aio.operations.MetricDefinitionsOperations
    :ivar metric_namespaces: MetricNamespacesOperations operations
    :vartype metric_namespaces: azure.mgmt.monitor.aio.operations.MetricNamespacesOperations
    :ivar metrics: MetricsOperations operations
    :vartype metrics: azure.mgmt.monitor.aio.operations.MetricsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.monitor.aio.operations.Operations
    :ivar scheduled_query_rules: ScheduledQueryRulesOperations operations
    :vartype scheduled_query_rules: azure.mgmt.monitor.aio.operations.ScheduledQueryRulesOperations
    :ivar service_diagnostic_settings: ServiceDiagnosticSettingsOperations operations
    :vartype service_diagnostic_settings:
     azure.mgmt.monitor.aio.operations.ServiceDiagnosticSettingsOperations
    :ivar vm_insights: VMInsightsOperations operations
    :vartype vm_insights: azure.mgmt.monitor.aio.operations.VMInsightsOperations
    :ivar private_link_scopes: PrivateLinkScopesOperations operations
    :vartype private_link_scopes: azure.mgmt.monitor.aio.operations.PrivateLinkScopesOperations
    :ivar private_link_scope_operation_status: PrivateLinkScopeOperationStatusOperations operations
    :vartype private_link_scope_operation_status:
     azure.mgmt.monitor.aio.operations.PrivateLinkScopeOperationStatusOperations
    :ivar private_link_resources: PrivateLinkResourcesOperations operations
    :vartype private_link_resources:
     azure.mgmt.monitor.aio.operations.PrivateLinkResourcesOperations
    :ivar private_endpoint_connections: PrivateEndpointConnectionsOperations operations
    :vartype private_endpoint_connections:
     azure.mgmt.monitor.aio.operations.PrivateEndpointConnectionsOperations
    :ivar private_link_scoped_resources: PrivateLinkScopedResourcesOperations operations
    :vartype private_link_scoped_resources:
     azure.mgmt.monitor.aio.operations.PrivateLinkScopedResourcesOperations
    :ivar subscription_diagnostic_settings: SubscriptionDiagnosticSettingsOperations operations
    :vartype subscription_diagnostic_settings:
     azure.mgmt.monitor.aio.operations.SubscriptionDiagnosticSettingsOperations
    :ivar azure_monitor_workspaces: AzureMonitorWorkspacesOperations operations
    :vartype azure_monitor_workspaces:
     azure.mgmt.monitor.aio.operations.AzureMonitorWorkspacesOperations
    :ivar monitor_operations: MonitorOperationsOperations operations
    :vartype monitor_operations: azure.mgmt.monitor.aio.operations.MonitorOperationsOperations
    :ivar data_collection_endpoints: DataCollectionEndpointsOperations operations
    :vartype data_collection_endpoints:
     azure.mgmt.monitor.aio.operations.DataCollectionEndpointsOperations
    :ivar data_collection_rule_associations: DataCollectionRuleAssociationsOperations operations
    :vartype data_collection_rule_associations:
     azure.mgmt.monitor.aio.operations.DataCollectionRuleAssociationsOperations
    :ivar data_collection_rules: DataCollectionRulesOperations operations
    :vartype data_collection_rules: azure.mgmt.monitor.aio.operations.DataCollectionRulesOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The ID of the target subscription. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is None.
    :type base_url: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self, credential: "AsyncTokenCredential", subscription_id: str, base_url: Optional[str] = None, **kwargs: Any
    ) -> None:
        _cloud = kwargs.pop("cloud_setting", None) or settings.current.azure_cloud  # type: ignore
        _endpoints = get_arm_endpoints(_cloud)
        if not base_url:
            base_url = _endpoints["resource_manager"]
        credential_scopes = kwargs.pop("credential_scopes", _endpoints["credential_scopes"])
        self._config = MonitorManagementClientConfiguration(
            credential=credential, subscription_id=subscription_id, credential_scopes=credential_scopes, **kwargs
        )

        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                AsyncARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: AsyncARMPipelineClient = AsyncARMPipelineClient(
            base_url=cast(str, base_url), policies=_policies, **kwargs
        )

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.action_groups = ActionGroupsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.activity_log_alerts = ActivityLogAlertsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.activity_logs = ActivityLogsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.tenant_activity_logs = TenantActivityLogsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.alert_rule_incidents = AlertRuleIncidentsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.autoscale_settings = AutoscaleSettingsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.predictive_metric = PredictiveMetricOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.baselines = BaselinesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.diagnostic_settings = DiagnosticSettingsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.diagnostic_settings_category = DiagnosticSettingsCategoryOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.event_categories = EventCategoriesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.guest_diagnostics_settings = GuestDiagnosticsSettingsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.guest_diagnostics_settings_association = GuestDiagnosticsSettingsAssociationOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.log_profiles = LogProfilesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.metric_alerts = MetricAlertsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.metric_alerts_status = MetricAlertsStatusOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.metric_definitions = MetricDefinitionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.metric_namespaces = MetricNamespacesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.metrics = MetricsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.scheduled_query_rules = ScheduledQueryRulesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.service_diagnostic_settings = ServiceDiagnosticSettingsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.vm_insights = VMInsightsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.private_link_scopes = PrivateLinkScopesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.private_link_scope_operation_status = PrivateLinkScopeOperationStatusOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.private_link_resources = PrivateLinkResourcesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.private_endpoint_connections = PrivateEndpointConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.private_link_scoped_resources = PrivateLinkScopedResourcesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.subscription_diagnostic_settings = SubscriptionDiagnosticSettingsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.azure_monitor_workspaces = AzureMonitorWorkspacesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.monitor_operations = MonitorOperationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.data_collection_endpoints = DataCollectionEndpointsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.data_collection_rule_associations = DataCollectionRuleAssociationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.data_collection_rules = DataCollectionRulesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(
        self, request: HttpRequest, *, stream: bool = False, **kwargs: Any
    ) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> Self:
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details: Any) -> None:
        await self._client.__aexit__(*exc_details)
