/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.util.XMLPrinter;
import org.apache.webdav.lib.methods.XMLResponseMethodBase;

public class MDeleteMethod
extends XMLResponseMethodBase {
    private static final String RDFNS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    protected String requestPath = "";
    protected String resourceURI = "";
    protected Hashtable toSet = new Hashtable();
    protected Hashtable toRemove = new Hashtable();

    public MDeleteMethod() {
    }

    public MDeleteMethod(String path, String uri) {
        super(path);
        this.requestPath = path;
        this.resourceURI = uri;
        NameValuePair[] pairs = new NameValuePair[]{new NameValuePair("uri", this.resourceURI)};
        this.setQueryString(pairs);
    }

    public void setResourceURI(String uri) {
        this.resourceURI = uri;
    }

    public String getResourceURI() {
        return this.resourceURI;
    }

    public void addPropertyToRemove(String name, String value) {
        this.checkNotUsed();
        Property propertyToRemove = new Property();
        if (name != null) {
            propertyToRemove.name = name;
            if (value != null) {
                propertyToRemove.value = value;
            }
            this.toRemove.put(name, propertyToRemove);
        }
    }

    public void addPropertyToRemove(String name, String value, String namespace, String namespaceInfo) {
        this.checkNotUsed();
        Property propertyToRemove = new Property();
        if (name != null) {
            propertyToRemove.name = name;
            propertyToRemove.namespace = namespace;
            propertyToRemove.namespaceInfo = namespaceInfo;
            if (value != null) {
                propertyToRemove.value = value;
            }
            this.toRemove.put(name, propertyToRemove);
        }
    }

    public String getName() {
        return "MDELETE";
    }

    public void addRequestHeaders(HttpState state, HttpConnection conn) throws IOException, HttpException {
        if (this.getRequestHeader("Content-Type") == null) {
            super.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
        }
        super.addRequestHeaders(state, conn);
    }

    protected String generateRequestBody() {
        XMLPrinter printer = new XMLPrinter();
        if (this.toRemove.size() > 0) {
            printer.writeXMLHeader();
            printer.writeElement("rdf", RDFNS, "RDF", 0);
            printer.writeElement("rdf", RDFNS, "Description", 0, "rdf:about=\"" + this.resourceURI + "\"");
            Enumeration toRemoveList = this.toRemove.elements();
            while (toRemoveList.hasMoreElements()) {
                Property current = (Property)toRemoveList.nextElement();
                printer.writeProperty(current.namespace, current.namespaceInfo, current.name, current.value);
            }
            printer.writeElement("rdf", "Description", 1);
            printer.writeElement("rdf", "RDF", 1);
        }
        return printer.toString();
    }

    public void parseResponse(InputStream input, HttpState state, HttpConnection conn) throws IOException, HttpException {
        try {
            int code = this.getStatusLine().getStatusCode();
            if (code == 409 || code == 207 || code == 403) {
                this.parseXMLResponse(input);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private class Property {
        public String name = "";
        public String namespace;
        public String namespaceInfo;
        public String value;

        private Property() {
        }
    }
}

