# -*- coding: binary -*-

module Msf
  class Exploit
    class Remote
      module Kerberos
        # Helper methods for handling Kerberos clock skew adjustments.
        module ClockSkew
          CLOCK_SKEW_REGEX = /\A([+-]?\d+(?:\.\d+)?(?:[smhd])?)+\z/i.freeze

          UNIT_IN_SECONDS = {
            's' => 1,
            'm' => 60,
            'h' => 3_600,
            'd' => 86_400
          }.freeze

          module_function

          # Convert a user supplied clock skew value into seconds.
          #
          # @param value [String, Numeric, nil] The skew value to parse, e.g. '-5m', '120', 30
          # @return [Float] The skew in seconds
          # @raise [Msf::OptionValidateError] If the value cannot be parsed
          def parse(value)
            return 0 if value.nil?
            return value.to_f if value.is_a?(Numeric)

            trimmed_value = value.to_s.strip
            return 0 if trimmed_value.empty?
            return trimmed_value.to_f if trimmed_value.match?(/\A[+-]?\d+(?:\.\d+)?\z/)
            raise Msf::OptionValidateError, 'Invalid KrbClockSkew format' unless trimmed_value.match?(CLOCK_SKEW_REGEX)

            total = 0
            trimmed_value.scan(/([+-]?\d+(?:\.\d+)?)([smhd]?)/i) do |amount, unit|
              unit = 's' if unit.blank?
              multiplier = UNIT_IN_SECONDS[unit.downcase]
              total += amount.to_f * multiplier
            end
            total
          end
        end
      end
    end
  end
end
