set(_leveldb_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES ${CMAKE_FIND_LIBRARY_SUFFIXES})

find_path(LevelDb_INCLUDE_PATH leveldb/db.h)

if (LevelDb_STATIC)
  if (WIN32)
    set(CMAKE_FIND_LIBRARY_SUFFIXES .lib ${CMAKE_FIND_LIBRARY_SUFFIXES})
  else (WIN32)
    set(CMAKE_FIND_LIBRARY_SUFFIXES .a ${CMAKE_FIND_LIBRARY_SUFFIXES})
  endif (WIN32)
endif (LevelDb_STATIC)
find_library(LevelDb_LIBRARY NAMES leveldb libleveldb)
if(LevelDb_INCLUDE_PATH AND LevelDb_LIBRARY)
  set(LevelDb_FOUND TRUE)
endif(LevelDb_INCLUDE_PATH AND LevelDb_LIBRARY)
if(LevelDb_FOUND)
  if(NOT LevelDb_FIND_QUIETLY)
    message(STATUS "Found leveldb: ${LevelDb_LIBRARY}")
  endif(NOT LevelDb_FIND_QUIETLY)
else(LevelDb_FOUND)
  if(LevelDb_FIND_REQUIRED)
    message(FATAL_ERROR "Could not find leveldb library.")
  endif(LevelDb_FIND_REQUIRED)
endif(LevelDb_FOUND)

set(CMAKE_FIND_LIBRARY_SUFFIXES ${_leveldb_ORIG_CMAKE_FIND_LIBRARY_SUFFIXES})
