/*
Copyright The Helm Authors.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package v3

import (
	"testing"

	fuzz "github.com/AdaLogics/go-fuzz-headers"
)

func FuzzMetadataValidate(f *testing.F) {
	f.Fuzz(func(t *testing.T, data []byte) {
		fdp := fuzz.NewConsumer(data)
		// Add random values to the metadata
		md := &Metadata{}
		err := fdp.GenerateStruct(md)
		if err != nil {
			t.Skip()
		}
		md.Validate()
	})
}

func FuzzDependencyValidate(f *testing.F) {
	f.Fuzz(func(t *testing.T, data []byte) {
		f := fuzz.NewConsumer(data)
		// Add random values to the dependenci
		d := &Dependency{}
		err := f.GenerateStruct(d)
		if err != nil {
			t.Skip()
		}
		d.Validate()
	})
}
