/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.nashorn.internal.runtime.linker;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.dynalink.CallSiteDescriptor;
import jdk.dynalink.StandardOperation;
import jdk.dynalink.beans.StaticClass;
import jdk.dynalink.linker.support.SimpleLinkRequest;
import org.openjdk.nashorn.internal.lookup.Lookup;
import org.openjdk.nashorn.internal.runtime.ECMAErrors;
import org.openjdk.nashorn.internal.runtime.ECMAException;
import org.openjdk.nashorn.internal.runtime.ScriptFunction;
import org.openjdk.nashorn.internal.runtime.ScriptObject;
import org.openjdk.nashorn.internal.runtime.linker.Bootstrap;
import org.openjdk.nashorn.internal.runtime.linker.ClassAndLoader;
import org.openjdk.nashorn.internal.runtime.linker.JavaAdapterBytecodeGenerator;
import org.openjdk.nashorn.internal.runtime.linker.JavaAdapterClassLoader;
import org.openjdk.nashorn.internal.runtime.linker.JavaAdapterServices;

public final class JavaAdapterFactory {
    private static final ClassValue<Map<List<Class<?>>, AdapterInfo>> ADAPTER_INFO_MAPS = new ClassValue<Map<List<Class<?>>, AdapterInfo>>(){

        @Override
        protected Map<List<Class<?>>, AdapterInfo> computeValue(Class<?> type) {
            return new ConcurrentHashMap();
        }
    };
    private static final ClassValue<Boolean> AUTO_CONVERTIBLE_FROM_FUNCTION = new ClassValue<Boolean>(){

        @Override
        protected Boolean computeValue(Class<?> type) {
            try {
                return JavaAdapterFactory.getAdapterInfo(new Class[]{type}).autoConvertibleFromFunction;
            }
            catch (Exception e) {
                return false;
            }
        }
    };

    public static StaticClass getAdapterClassFor(Class<?>[] types, ScriptObject classOverrides) {
        assert (types != null && types.length > 0);
        return JavaAdapterFactory.getAdapterInfo(types).getAdapterClass(classOverrides);
    }

    public static MethodHandle getConstructor(Class<?> sourceType, Class<?> targetType, MethodHandles.Lookup lookup2) throws Exception {
        StaticClass adapterClass = JavaAdapterFactory.getAdapterClassFor(new Class[]{targetType}, null);
        return Lookup.MH.bindTo(Bootstrap.getLinkerServices().getGuardedInvocation(new SimpleLinkRequest(new CallSiteDescriptor(lookup2, StandardOperation.NEW, MethodType.methodType(targetType, StaticClass.class, sourceType)), false, adapterClass, null)).getInvocation(), adapterClass);
    }

    static boolean isAutoConvertibleFromFunction(Class<?> clazz) {
        return AUTO_CONVERTIBLE_FROM_FUNCTION.get(clazz);
    }

    private static AdapterInfo getAdapterInfo(Class<?>[] types) {
        ClassAndLoader definingClassAndLoader = ClassAndLoader.getDefiningClassAndLoader(types);
        Map<List<Class<?>>, AdapterInfo> adapterInfoMap = ADAPTER_INFO_MAPS.get(definingClassAndLoader.getRepresentativeClass());
        return adapterInfoMap.computeIfAbsent(List.of(types), t -> JavaAdapterFactory.createAdapterInfo(t, definingClassAndLoader));
    }

    private static AdapterInfo createAdapterInfo(List<Class<?>> types, ClassAndLoader definingClassAndLoader) {
        Class<?> superClass = null;
        ArrayList interfaces = new ArrayList(types.size());
        HashSet interfacesDedup = new HashSet(Math.max((int)((float)types.size() / 0.75f) + 1, 16));
        for (Class<?> t : types) {
            int mod = t.getModifiers();
            if (!t.isInterface()) {
                if (superClass == t) {
                    throw JavaAdapterFactory.adaptationException(ErrorOutcome.DUPLICATE_TYPE, t.getCanonicalName());
                }
                if (superClass != null) {
                    throw JavaAdapterFactory.adaptationException(ErrorOutcome.MULTIPLE_SUPERCLASSES, t.getCanonicalName() + " and " + superClass.getCanonicalName());
                }
                if (Modifier.isFinal(mod)) {
                    throw JavaAdapterFactory.adaptationException(ErrorOutcome.FINAL_CLASS, t.getCanonicalName());
                }
                superClass = t;
            } else {
                if (interfaces.size() > 65535) {
                    throw JavaAdapterFactory.adaptationException(ErrorOutcome.TOO_MANY_INTERFACES, "65535");
                }
                if (!interfacesDedup.add(t)) {
                    throw JavaAdapterFactory.adaptationException(ErrorOutcome.DUPLICATE_TYPE, t.getCanonicalName());
                }
                interfaces.add(t);
            }
            if (Modifier.isPublic(mod)) continue;
            throw JavaAdapterFactory.adaptationException(ErrorOutcome.NON_PUBLIC_CLASS, t.getCanonicalName());
        }
        Class effectiveSuperClass = superClass == null ? Object.class : superClass;
        return new AdapterInfo(effectiveSuperClass, interfaces, definingClassAndLoader);
    }

    static ECMAException adaptationException(ErrorOutcome outcome, String ... messageArgs) {
        return ECMAErrors.typeError("extend." + String.valueOf((Object)outcome), messageArgs);
    }

    private static class AdapterInfo {
        private static final ClassAndLoader SCRIPT_OBJECT_LOADER = new ClassAndLoader(ScriptFunction.class, true);
        private final ClassLoader commonLoader;
        private final JavaAdapterClassLoader classAdapterGenerator;
        private JavaAdapterClassLoader instanceAdapterGenerator;
        private volatile StaticClass instanceAdapter;
        final boolean autoConvertibleFromFunction;

        AdapterInfo(Class<?> superClass, List<Class<?>> interfaces, ClassAndLoader definingLoader) {
            this.commonLoader = AdapterInfo.findCommonLoader(definingLoader);
            JavaAdapterBytecodeGenerator gen = new JavaAdapterBytecodeGenerator(superClass, interfaces, this.commonLoader, false);
            this.autoConvertibleFromFunction = gen.isAutoConvertibleFromFunction();
            this.instanceAdapterGenerator = gen.createAdapterClassLoader();
            this.classAdapterGenerator = new JavaAdapterBytecodeGenerator(superClass, interfaces, this.commonLoader, true).createAdapterClassLoader();
        }

        StaticClass getAdapterClass(ScriptObject classOverrides) {
            return classOverrides == null ? this.getInstanceAdapterClass() : this.getClassAdapterClass(classOverrides);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private StaticClass getInstanceAdapterClass() {
            if (this.instanceAdapter == null) {
                AdapterInfo adapterInfo = this;
                synchronized (adapterInfo) {
                    if (this.instanceAdapter == null) {
                        this.instanceAdapter = this.instanceAdapterGenerator.generateClass(this.commonLoader);
                        this.instanceAdapterGenerator = null;
                    }
                }
            }
            return this.instanceAdapter;
        }

        private StaticClass getClassAdapterClass(ScriptObject classOverrides) {
            JavaAdapterServices.setClassOverrides(classOverrides);
            try {
                StaticClass staticClass = this.classAdapterGenerator.generateClass(this.commonLoader);
                return staticClass;
            }
            finally {
                JavaAdapterServices.setClassOverrides(null);
            }
        }

        private static ClassLoader findCommonLoader(ClassAndLoader classAndLoader) {
            if (classAndLoader.canSee(SCRIPT_OBJECT_LOADER)) {
                return classAndLoader.getLoader();
            }
            if (SCRIPT_OBJECT_LOADER.canSee(classAndLoader)) {
                return SCRIPT_OBJECT_LOADER.getLoader();
            }
            throw JavaAdapterFactory.adaptationException(ErrorOutcome.NO_COMMON_LOADER, classAndLoader.getRepresentativeClass().getCanonicalName());
        }
    }

    static enum ErrorOutcome {
        FINAL_CLASS,
        NON_PUBLIC_CLASS,
        NO_ACCESSIBLE_CONSTRUCTOR,
        MULTIPLE_SUPERCLASSES,
        DUPLICATE_TYPE,
        TOO_MANY_INTERFACES,
        NO_COMMON_LOADER;

    }
}

