/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.sql;

import com.jsql.model.injection.vendor.model.Vendor;
import com.jsql.model.injection.vendor.model.yaml.Method;
import com.jsql.model.injection.vendor.model.yaml.ModelYaml;
import com.jsql.util.I18nUtil;
import com.jsql.view.swing.sql.JSyntaxTextArea;
import com.jsql.view.swing.tab.TabbedPaneWheeled;
import com.jsql.view.swing.text.listener.DocumentListenerEditing;
import com.jsql.view.swing.util.I18nViewUtil;
import com.jsql.view.swing.util.MediatorHelper;
import com.jsql.view.swing.util.UiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class SqlEngine
extends JPanel {
    private static ModelYaml modelYaml = MediatorHelper.model().getMediatorVendor().getVendor().instance().getModelYaml();
    private static final JTabbedPane TABS_ERROR = new TabbedPaneWheeled(4);
    private static final List<JSyntaxTextArea> LIST_TEXTAREAS_ERROR = new ArrayList<JSyntaxTextArea>();

    public SqlEngine() {
        modelYaml = MediatorHelper.model().getMediatorVendor().getVendor().instance().getModelYaml();
        SqlEngine.initTextComponents();
        JTabbedPane panelStructure = this.getPanelStructure();
        RTextScrollPane panelFile = new RTextScrollPane(TextareaWithColor.EXPLOIT.getTextArea(), false);
        JTabbedPane panelStrategy = this.getPanelStrategy();
        JTabbedPane panelConfiguration = this.getPanelConfiguration();
        JTabbedPane panelFingerprinting = this.getPanelFingerprinting();
        TabbedPaneWheeled tabsBottom = new TabbedPaneWheeled(3);
        Stream.of(new AbstractMap.SimpleEntry<String, JTabbedPane>("SQLENGINE_STRUCTURE", panelStructure), new AbstractMap.SimpleEntry<String, JTabbedPane>("SQLENGINE_STRATEGY", panelStrategy), new AbstractMap.SimpleEntry<String, JTabbedPane>("SQLENGINE_CONFIGURATION", panelConfiguration), new AbstractMap.SimpleEntry<String, JTabbedPane>("SQLENGINE_FINGERPRINTING", panelFingerprinting), new AbstractMap.SimpleEntry<String, RTextScrollPane>("SQLENGINE_EXPLOIT", panelFile)).forEach(entry -> {
            tabsBottom.addTab(I18nUtil.valueByKey((String)entry.getKey()), (Component)entry.getValue());
            JLabel label = new JLabel(I18nUtil.valueByKey((String)entry.getKey()));
            tabsBottom.setTabComponentAt(tabsBottom.indexOfTab(I18nUtil.valueByKey((String)entry.getKey())), label);
            I18nViewUtil.addComponentForKey((String)entry.getKey(), label);
        });
        this.setLayout(new BorderLayout());
        JPanel panelCombo = SqlEngine.initMenuVendor();
        tabsBottom.putClientProperty("JTabbedPane.trailingComponent", panelCombo);
        this.add(tabsBottom);
        SwingUtilities.invokeLater(() -> {
            MediatorHelper.menubar().switchLocale(I18nUtil.getCurrentLocale());
            TABS_ERROR.updateUI();
        });
    }

    private JTabbedPane getPanelStructure() {
        String keyDatabases = "SQLENGINE_DATABASES";
        String keyTables = "SQLENGINE_TABLES";
        String keyColumns = "SQLENGINE_COLUMNS";
        String keyRows = "SQLENGINE_ROWS";
        String keyField = "SQLENGINE_FIELD";
        String keyFieldSeparator = "SQLENGINE_FIELDS_SEPARATOR";
        TabbedPaneWheeled tabsDefault = new TabbedPaneWheeled();
        Stream.of(new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("SQLENGINE_DATABASES", TextareaWithColor.DATABASE_DEFAULT.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("SQLENGINE_TABLES", TextareaWithColor.TABLE_DEFAULT.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("SQLENGINE_COLUMNS", TextareaWithColor.COLUMN_DEFAULT.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("SQLENGINE_ROWS", TextareaWithColor.QUERY_DEFAULT.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("SQLENGINE_FIELD", TextareaWithColor.FIELD_DEFAULT.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("SQLENGINE_FIELDS_SEPARATOR", TextareaWithColor.CONCAT_DEFAULT.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("SQLENGINE_METADATA", TextareaWithColor.INFO.getTextArea())).forEach(entry -> {
            tabsDefault.addTab(I18nUtil.valueByKey((String)entry.getKey()), new RTextScrollPane((RTextArea)entry.getValue(), false));
            JLabel label = new JLabel(I18nUtil.valueByKey((String)entry.getKey()));
            tabsDefault.setTabComponentAt(tabsDefault.indexOfTab(I18nUtil.valueByKey((String)entry.getKey())), label);
            I18nViewUtil.addComponentForKey((String)entry.getKey(), label);
        });
        TabbedPaneWheeled tabsZip = new TabbedPaneWheeled();
        Stream.of(new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("SQLENGINE_DATABASES", TextareaWithColor.DATABASE_ZIP.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("SQLENGINE_TABLES", TextareaWithColor.TABLE_ZIP.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("SQLENGINE_COLUMNS", TextareaWithColor.COLUMN_ZIP.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("SQLENGINE_ROWS", TextareaWithColor.QUERY_ZIP.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("SQLENGINE_FIELD", TextareaWithColor.FIELD_ZIP.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("SQLENGINE_FIELDS_SEPARATOR", TextareaWithColor.CONCAT_ZIP.getTextArea())).forEach(entry -> {
            tabsZip.addTab(I18nUtil.valueByKey((String)entry.getKey()), new RTextScrollPane((RTextArea)entry.getValue(), false));
            JLabel label = new JLabel(I18nUtil.valueByKey((String)entry.getKey()));
            tabsZip.setTabComponentAt(tabsZip.indexOfTab(I18nUtil.valueByKey((String)entry.getKey())), label);
            I18nViewUtil.addComponentForKey((String)entry.getKey(), label);
        });
        TabbedPaneWheeled tabsDios = new TabbedPaneWheeled();
        Stream.of(new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("SQLENGINE_DATABASES", TextareaWithColor.DATABASE_DIOS.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("SQLENGINE_TABLES", TextareaWithColor.TABLE_DIOS.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("SQLENGINE_COLUMNS", TextareaWithColor.COLUMN_DIOS.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("SQLENGINE_ROWS", TextareaWithColor.QUERY_DIOS.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("SQLENGINE_FIELD", TextareaWithColor.FIELD_DIOS.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("SQLENGINE_FIELDS_SEPARATOR", TextareaWithColor.CONCAT_DIOS.getTextArea())).forEach(entry -> {
            tabsDios.addTab(I18nUtil.valueByKey((String)entry.getKey()), new RTextScrollPane((RTextArea)entry.getValue(), false));
            JLabel label = new JLabel(I18nUtil.valueByKey((String)entry.getKey()));
            tabsDios.setTabComponentAt(tabsDios.indexOfTab(I18nUtil.valueByKey((String)entry.getKey())), label);
            I18nViewUtil.addComponentForKey((String)entry.getKey(), label);
        });
        TabbedPaneWheeled tabs = new TabbedPaneWheeled(4);
        Stream.of(new AbstractMap.SimpleEntry<String, TabbedPaneWheeled>("SQLENGINE_STANDARD", tabsDefault), new AbstractMap.SimpleEntry<String, TabbedPaneWheeled>("SQLENGINE_ZIP", tabsZip), new AbstractMap.SimpleEntry<String, TabbedPaneWheeled>("SQLENGINE_DIOS", tabsDios)).forEach(entry -> {
            tabs.addTab(I18nUtil.valueByKey((String)entry.getKey()), (Component)entry.getValue());
            JLabel label = new JLabel(I18nUtil.valueByKey((String)entry.getKey()));
            tabs.setTabComponentAt(tabs.indexOfTab(I18nUtil.valueByKey((String)entry.getKey())), label);
            I18nViewUtil.addComponentForKey((String)entry.getKey(), label);
        });
        return tabs;
    }

    private JTabbedPane getPanelStrategy() {
        TabbedPaneWheeled tabs = new TabbedPaneWheeled();
        tabs.addTab(I18nUtil.valueByKey("SQLENGINE_UNION"), new RTextScrollPane(TextareaWithColor.INDICES.getTextArea(), false));
        tabs.addTab(I18nUtil.valueByKey("SQLENGINE_STACK"), new RTextScrollPane(TextareaWithColor.STACK.getTextArea(), false));
        tabs.addTab(I18nUtil.valueByKey("SQLENGINE_ERROR"), TABS_ERROR);
        tabs.addTab(I18nUtil.valueByKey("SQLENGINE_DNS"), new RTextScrollPane(TextareaWithColor.DNS.getTextArea(), false));
        TabbedPaneWheeled tabsBoolean = new TabbedPaneWheeled(4);
        Stream.of(new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("AND mode", TextareaWithColor.MODE_AND.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("OR mode", TextareaWithColor.MODE_OR.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("Stack mode", TextareaWithColor.MODE_STACK.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("Time", TextareaWithColor.TIME.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("Blind", TextareaWithColor.BLIND.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("Bin test", TextareaWithColor.TEST_BIN.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("Bin truthy", TextareaWithColor.TRUTHY_BIN.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("Bin falsy", TextareaWithColor.FALSY_BIN.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("Bit test", TextareaWithColor.TEST_BIT.getTextArea()), new AbstractMap.SimpleEntry<String, JSyntaxTextArea>("Multibit", TextareaWithColor.MULTIBIT.getTextArea())).forEach(entry -> {
            tabsBoolean.addTab((String)entry.getKey(), new RTextScrollPane((RTextArea)entry.getValue(), false));
            tabsBoolean.setTitleAt(tabsBoolean.getTabCount() - 1, String.format("<html><div style=\"text-align:left;width:60px;\">%s</div></html>", entry.getKey()));
        });
        tabs.addTab(I18nUtil.valueByKey("SQLENGINE_BOOLEAN"), tabsBoolean);
        Stream.of("SQLENGINE_UNION", "SQLENGINE_STACK", "SQLENGINE_ERROR", "SQLENGINE_BOOLEAN").forEach(keyI18n -> {
            JLabel label = new JLabel(I18nUtil.valueByKey(keyI18n));
            tabs.setTabComponentAt(tabs.indexOfTab(I18nUtil.valueByKey(keyI18n)), label);
            I18nViewUtil.addComponentForKey(keyI18n, label);
        });
        return tabs;
    }

    private JTabbedPane getPanelConfiguration() {
        TabbedPaneWheeled tabs = new TabbedPaneWheeled();
        Stream.of(new AbstractMap.SimpleEntry<String, RTextScrollPane>("SQLENGINE_CHARACTERS_SLIDINGWINDOW", new RTextScrollPane(TextareaWithColor.SLIDING_WINDOW.getTextArea(), false)), new AbstractMap.SimpleEntry<String, RTextScrollPane>("SQLENGINE_ROWS_SLIDINGWINDOW", new RTextScrollPane(TextareaWithColor.LIMIT.getTextArea(), false)), new AbstractMap.SimpleEntry<String, RTextScrollPane>("SQLENGINE_LIMIT_START_INDEX", new RTextScrollPane(TextareaWithColor.LIMIT_BOUNDARY.getTextArea(), false)), new AbstractMap.SimpleEntry<String, RTextScrollPane>("SQLENGINE_CAPACITY", new RTextScrollPane(TextareaWithColor.CAPACITY.getTextArea(), false)), new AbstractMap.SimpleEntry<String, RTextScrollPane>("SQLENGINE_CALIBRATOR", new RTextScrollPane(TextareaWithColor.CALIBRATOR.getTextArea(), false)), new AbstractMap.SimpleEntry<String, RTextScrollPane>("SQLENGINE_FAILSAFE", new RTextScrollPane(TextareaWithColor.FAILSAFE.getTextArea(), false)), new AbstractMap.SimpleEntry<String, RTextScrollPane>("SQLENGINE_END_COMMENT", new RTextScrollPane(TextareaWithColor.ENDING_COMMENT.getTextArea(), false))).forEach(keyI18n -> {
            tabs.addTab(I18nUtil.valueByKey((String)keyI18n.getKey()), (Component)keyI18n.getValue());
            JLabel label = new JLabel(I18nUtil.valueByKey((String)keyI18n.getKey()));
            tabs.setTabComponentAt(tabs.indexOfTab(I18nUtil.valueByKey((String)keyI18n.getKey())), label);
            I18nViewUtil.addComponentForKey((String)keyI18n.getKey(), label);
        });
        return tabs;
    }

    private JTabbedPane getPanelFingerprinting() {
        TabbedPaneWheeled tabs = new TabbedPaneWheeled();
        tabs.addTab(I18nUtil.valueByKey("SQLENGINE_ORDER_BY"), new RTextScrollPane(TextareaWithColor.ORDER_BY.getTextArea(), false));
        tabs.addTab("Order by error", new RTextScrollPane(TextareaWithColor.ORDER_BY_ERROR_MESSAGE.getTextArea(), false));
        tabs.addTab("String error", new RTextScrollPane(TextareaWithColor.INCORRECT_STRING_ERROR_MESSAGE.getTextArea(), false));
        tabs.addTab("Vendor specific", new RTextScrollPane(TextareaWithColor.VENDOR_SPECIFIC.getTextArea(), false));
        tabs.addTab("Truthy", new RTextScrollPane(TextareaWithColor.TRUTHY.getTextArea(), false));
        tabs.addTab("Falsy", new RTextScrollPane(TextareaWithColor.FALSY.getTextArea(), false));
        Stream.of("SQLENGINE_ORDER_BY").forEach(keyI18n -> {
            JLabel label = new JLabel(I18nUtil.valueByKey(keyI18n));
            tabs.setTabComponentAt(tabs.indexOfTab(I18nUtil.valueByKey(keyI18n)), label);
            I18nViewUtil.addComponentForKey(keyI18n, label);
        });
        return tabs;
    }

    private static JPanel initMenuVendor() {
        JPanel panelMenuVendor = new JPanel();
        panelMenuVendor.setLayout(new BorderLayout());
        final JPopupMenu popupMenuVendors = new JPopupMenu();
        popupMenuVendors.setLayout(UiUtil.getColumnLayout(MediatorHelper.model().getMediatorVendor().getVendors().size()));
        JLabel labelVendor = new JLabel(MediatorHelper.model().getMediatorVendor().getVendor().toString(), UiUtil.ARROW_DOWN.getIcon(), 2);
        labelVendor.setBorder(UiUtil.BORDER_5PX);
        labelVendor.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Arrays.stream(popupMenuVendors.getComponents()).map(a -> (JComponent)a).forEach(JComponent::updateUI);
                popupMenuVendors.updateUI();
                popupMenuVendors.show(e.getComponent(), e.getComponent().getX(), e.getComponent().getY() + e.getComponent().getHeight());
                popupMenuVendors.setLocation(e.getComponent().getLocationOnScreen().x, e.getComponent().getLocationOnScreen().y + e.getComponent().getHeight());
            }
        });
        LinkedList<Vendor> listVendors = new LinkedList<Vendor>(MediatorHelper.model().getMediatorVendor().getVendors());
        listVendors.removeIf(vendor -> vendor == MediatorHelper.model().getMediatorVendor().getAuto());
        ButtonGroup groupVendor = new ButtonGroup();
        for (Vendor vendor2 : listVendors) {
            JRadioButtonMenuItem itemRadioVendor = new JRadioButtonMenuItem(vendor2.toString(), vendor2 == MediatorHelper.model().getMediatorVendor().getVendor());
            itemRadioVendor.addActionListener(actionEvent -> {
                modelYaml = vendor2.instance().getModelYaml();
                SqlEngine.initTextComponents();
                labelVendor.setText(vendor2.toString());
            });
            groupVendor.add(itemRadioVendor);
            popupMenuVendors.add(itemRadioVendor);
        }
        panelMenuVendor.add((Component)labelVendor, "After");
        return panelMenuVendor;
    }

    private static void initTextComponents() {
        SqlEngine.getTextareas().forEach(SqlEngine::reset);
        SqlEngine.getTextareas().forEach(textPaneLexer -> textPaneLexer.setText(""));
        Stream.of(TextareaWithColor.values()).map(textareaWithColor -> textareaWithColor.textarea).forEach(textArea -> {
            textArea.setText(textArea.getSupplierGetter().get().trim());
            textArea.setCaretPosition(0);
        });
        SqlEngine.populateTabError();
        SqlEngine.applyTheme();
    }

    public static void applyTheme() {
        SqlEngine.getTextareas().forEach(UiUtil::applySyntaxTheme);
    }

    private static void populateTabError() {
        TABS_ERROR.removeAll();
        if (modelYaml.getStrategy().getError() == null) {
            return;
        }
        for (Method methodError : modelYaml.getStrategy().getError().getMethod()) {
            JPanel panelError = new JPanel(new BorderLayout());
            JSyntaxTextArea textareaError = new JSyntaxTextArea(methodError::setQuery, methodError::getQuery);
            SqlEngine.reset(textareaError);
            textareaError.setText(methodError.getQuery().trim());
            textareaError.setCaretPosition(0);
            panelError.add((Component)new RTextScrollPane(textareaError, false), "Center");
            JPanel panelLimit = new JPanel();
            panelLimit.setLayout(new BoxLayout(panelLimit, 2));
            panelLimit.add(new JLabel(" Overflow limit: "));
            panelLimit.add(new JTextField(Integer.toString(methodError.getCapacity())));
            panelError.add((Component)panelLimit, "South");
            TABS_ERROR.addTab(methodError.getName(), panelError);
            TABS_ERROR.setTitleAt(TABS_ERROR.getTabCount() - 1, String.format("<html><div style=\"text-align:left;width:100px;\">%s</div></html>", methodError.getName()));
            LIST_TEXTAREAS_ERROR.add(textareaError);
        }
    }

    private static void reset(final JSyntaxTextArea textarea) {
        textarea.setDocument(new RSyntaxDocument("text/sql"));
        textarea.getDocument().addDocumentListener(new DocumentListenerEditing(){

            @Override
            public void process() {
                textarea.setAttribute();
            }
        });
    }

    private static List<JSyntaxTextArea> getTextareas() {
        return Stream.concat(LIST_TEXTAREAS_ERROR.stream(), Stream.of(TextareaWithColor.values()).map(TextareaWithColor::getTextArea)).collect(Collectors.toList());
    }

    static enum TextareaWithColor {
        DATABASE_DEFAULT(new JSyntaxTextArea(v -> modelYaml.getResource().getSchema().setDatabase((String)v), () -> modelYaml.getResource().getSchema().getDatabase())),
        TABLE_DEFAULT(new JSyntaxTextArea(v -> modelYaml.getResource().getSchema().setTable((String)v), () -> modelYaml.getResource().getSchema().getTable())),
        COLUMN_DEFAULT(new JSyntaxTextArea(v -> modelYaml.getResource().getSchema().setColumn((String)v), () -> modelYaml.getResource().getSchema().getColumn())),
        QUERY_DEFAULT(new JSyntaxTextArea(v -> modelYaml.getResource().getSchema().getRow().setQuery((String)v), () -> modelYaml.getResource().getSchema().getRow().getQuery())),
        FIELD_DEFAULT(new JSyntaxTextArea(v -> modelYaml.getResource().getSchema().getRow().getFields().setField((String)v), () -> modelYaml.getResource().getSchema().getRow().getFields().getField())),
        CONCAT_DEFAULT(new JSyntaxTextArea(v -> modelYaml.getResource().getSchema().getRow().getFields().setConcat((String)v), () -> modelYaml.getResource().getSchema().getRow().getFields().getConcat())),
        DATABASE_ZIP(new JSyntaxTextArea(v -> modelYaml.getResource().getZip().setDatabase((String)v), () -> modelYaml.getResource().getZip().getDatabase())),
        TABLE_ZIP(new JSyntaxTextArea(v -> modelYaml.getResource().getZip().setTable((String)v), () -> modelYaml.getResource().getZip().getTable())),
        COLUMN_ZIP(new JSyntaxTextArea(v -> modelYaml.getResource().getZip().setColumn((String)v), () -> modelYaml.getResource().getZip().getColumn())),
        QUERY_ZIP(new JSyntaxTextArea(v -> modelYaml.getResource().getZip().getRow().setQuery((String)v), () -> modelYaml.getResource().getZip().getRow().getQuery())),
        FIELD_ZIP(new JSyntaxTextArea(v -> modelYaml.getResource().getZip().getRow().getFields().setField((String)v), () -> modelYaml.getResource().getZip().getRow().getFields().getField())),
        CONCAT_ZIP(new JSyntaxTextArea(v -> modelYaml.getResource().getZip().getRow().getFields().setConcat((String)v), () -> modelYaml.getResource().getZip().getRow().getFields().getConcat())),
        DATABASE_DIOS(new JSyntaxTextArea(v -> modelYaml.getResource().getDios().setDatabase((String)v), () -> modelYaml.getResource().getDios().getDatabase())),
        TABLE_DIOS(new JSyntaxTextArea(v -> modelYaml.getResource().getDios().setTable((String)v), () -> modelYaml.getResource().getDios().getTable())),
        COLUMN_DIOS(new JSyntaxTextArea(v -> modelYaml.getResource().getDios().setColumn((String)v), () -> modelYaml.getResource().getDios().getColumn())),
        QUERY_DIOS(new JSyntaxTextArea(v -> modelYaml.getResource().getDios().getRow().setQuery((String)v), () -> modelYaml.getResource().getDios().getRow().getQuery())),
        FIELD_DIOS(new JSyntaxTextArea(v -> modelYaml.getResource().getDios().getRow().getFields().setField((String)v), () -> modelYaml.getResource().getDios().getRow().getFields().getField())),
        CONCAT_DIOS(new JSyntaxTextArea(v -> modelYaml.getResource().getDios().getRow().getFields().setConcat((String)v), () -> modelYaml.getResource().getDios().getRow().getFields().getConcat())),
        INFO(new JSyntaxTextArea(v -> modelYaml.getResource().setInfo((String)v), () -> modelYaml.getResource().getInfo())),
        SLIDING_WINDOW(new JSyntaxTextArea(v -> modelYaml.getStrategy().getConfiguration().setSlidingWindow((String)v), () -> modelYaml.getStrategy().getConfiguration().getSlidingWindow())),
        LIMIT(new JSyntaxTextArea(v -> modelYaml.getStrategy().getConfiguration().setLimit((String)v), () -> modelYaml.getStrategy().getConfiguration().getLimit())),
        FAILSAFE(new JSyntaxTextArea(v -> modelYaml.getStrategy().getConfiguration().setFailsafe((String)v), () -> modelYaml.getStrategy().getConfiguration().getFailsafe())),
        CALIBRATOR(new JSyntaxTextArea(v -> modelYaml.getStrategy().getConfiguration().setCalibrator((String)v), () -> modelYaml.getStrategy().getConfiguration().getCalibrator())),
        ENDING_COMMENT(new JSyntaxTextArea(v -> modelYaml.getStrategy().getConfiguration().setEndingComment((String)v), () -> modelYaml.getStrategy().getConfiguration().getEndingComment())),
        LIMIT_BOUNDARY(new JSyntaxTextArea(v -> modelYaml.getStrategy().getConfiguration().setLimitBoundary((String)v), () -> modelYaml.getStrategy().getConfiguration().getLimitBoundary())),
        INDICES(new JSyntaxTextArea(v -> modelYaml.getStrategy().getUnion().setIndices((String)v), () -> modelYaml.getStrategy().getUnion().getIndices())),
        CAPACITY(new JSyntaxTextArea(v -> modelYaml.getStrategy().getUnion().setCapacity((String)v), () -> modelYaml.getStrategy().getUnion().getCapacity())),
        STACK(new JSyntaxTextArea(v -> modelYaml.getStrategy().setStack((String)v), () -> modelYaml.getStrategy().getStack())),
        DNS(new JSyntaxTextArea(v -> modelYaml.getStrategy().setDns((String)v), () -> modelYaml.getStrategy().getDns())),
        MODE_AND(new JSyntaxTextArea(v -> modelYaml.getStrategy().getBinary().setModeAnd((String)v), () -> modelYaml.getStrategy().getBinary().getModeAnd())),
        MODE_OR(new JSyntaxTextArea(v -> modelYaml.getStrategy().getBinary().setModeOr((String)v), () -> modelYaml.getStrategy().getBinary().getModeOr())),
        MODE_STACK(new JSyntaxTextArea(v -> modelYaml.getStrategy().getBinary().setModeStack((String)v), () -> modelYaml.getStrategy().getBinary().getModeStack())),
        BLIND(new JSyntaxTextArea(v -> modelYaml.getStrategy().getBinary().setBlind((String)v), () -> modelYaml.getStrategy().getBinary().getBlind())),
        TIME(new JSyntaxTextArea(v -> modelYaml.getStrategy().getBinary().setTime((String)v), () -> modelYaml.getStrategy().getBinary().getTime())),
        MULTIBIT(new JSyntaxTextArea(v -> modelYaml.getStrategy().getBinary().setMultibit((String)v), () -> modelYaml.getStrategy().getBinary().getMultibit())),
        TEST_BIT(new JSyntaxTextArea(v -> modelYaml.getStrategy().getBinary().getTest().setBit((String)v), () -> modelYaml.getStrategy().getBinary().getTest().getBit())),
        TEST_BIN(new JSyntaxTextArea(v -> modelYaml.getStrategy().getBinary().getTest().setBin((String)v), () -> modelYaml.getStrategy().getBinary().getTest().getBin())),
        TRUTHY_BIN(new JSyntaxTextArea(v -> modelYaml.getStrategy().getBinary().getTest().setTruthyBin((String)v), () -> modelYaml.getStrategy().getBinary().getTest().getTruthyBinAsString())),
        FALSY_BIN(new JSyntaxTextArea(v -> modelYaml.getStrategy().getBinary().getTest().setFalsyBin((String)v), () -> modelYaml.getStrategy().getBinary().getTest().getFalsyBinAsString())),
        EXPLOIT(new JSyntaxTextArea(v -> modelYaml.getResource().setExploit((String)v), () -> modelYaml.getResource().getExploit())),
        TRUTHY(new JSyntaxTextArea(v -> modelYaml.getStrategy().getBinary().getTest().setTruthyBit((String)v), () -> modelYaml.getStrategy().getBinary().getTest().getTruthyBitAsString())),
        FALSY(new JSyntaxTextArea(v -> modelYaml.getStrategy().getBinary().getTest().setFalsyBit((String)v), () -> modelYaml.getStrategy().getBinary().getTest().getFalsyBitAsString())),
        INCORRECT_STRING_ERROR_MESSAGE(new JSyntaxTextArea(v -> modelYaml.getStrategy().getConfiguration().getFingerprint().setErrorMessageAsString((String)v), () -> modelYaml.getStrategy().getConfiguration().getFingerprint().getErrorMessageAsString())),
        ORDER_BY_ERROR_MESSAGE(new JSyntaxTextArea(v -> modelYaml.getStrategy().getConfiguration().getFingerprint().setOrderByErrorMessage((String)v), () -> modelYaml.getStrategy().getConfiguration().getFingerprint().getOrderByErrorMessage())),
        ORDER_BY(new JSyntaxTextArea(v -> modelYaml.getStrategy().getUnion().setOrderBy((String)v), () -> modelYaml.getStrategy().getUnion().getOrderBy())),
        VENDOR_SPECIFIC(new JSyntaxTextArea(v -> modelYaml.getStrategy().getConfiguration().getFingerprint().setVendorSpecific((String)v), () -> modelYaml.getStrategy().getConfiguration().getFingerprint().getVendorSpecific()));

        final JSyntaxTextArea textarea;

        public JSyntaxTextArea getTextArea() {
            return this.textarea;
        }

        private TextareaWithColor(JSyntaxTextArea textarea) {
            this.textarea = textarea;
        }
    }
}

