/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.model.suspendable;

import com.jsql.model.InjectionModel;
import com.jsql.model.bean.util.Header;
import com.jsql.model.bean.util.Interaction;
import com.jsql.model.bean.util.Request;
import com.jsql.model.exception.JSqlRuntimeException;
import com.jsql.model.exception.StoppedByUserSlidingException;
import com.jsql.model.injection.strategy.blind.AbstractInjectionBit;
import com.jsql.model.injection.strategy.blind.InjectionVendor;
import com.jsql.model.injection.vendor.model.Vendor;
import com.jsql.model.suspendable.AbstractSuspendable;
import com.jsql.util.LogLevelUtil;
import java.util.EnumMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SuspendableGetVendor
extends AbstractSuspendable {
    private static final Logger LOGGER = LogManager.getRootLogger();

    public SuspendableGetVendor(InjectionModel injectionModel) {
        super(injectionModel);
    }

    @Override
    public String run(Object ... args) {
        LOGGER.log(LogLevelUtil.CONSOLE_DEFAULT, "Fingerprinting database with Boolean match...");
        AtomicBoolean isVendorFound = new AtomicBoolean(false);
        this.injectionModel.getMediatorVendor().getVendorsForFingerprint().stream().filter(vendor -> vendor != this.injectionModel.getMediatorVendor().getAuto()).filter(vendor -> StringUtils.isNotEmpty(vendor.instance().getModelYaml().getStrategy().getConfiguration().getFingerprint().getVendorSpecific())).forEach(vendor -> {
            if (isVendorFound.get()) {
                return;
            }
            String vendorSpecificWithOperator = this.injectionModel.getMediatorVendor().getVendor().instance().sqlTestBlindWithOperator(vendor.instance().getModelYaml().getStrategy().getConfiguration().getFingerprint().getVendorSpecific(), AbstractInjectionBit.BlindOperator.OR);
            try {
                InjectionVendor injectionCharInsertion = new InjectionVendor(this.injectionModel, vendorSpecificWithOperator, (Vendor)vendor);
                if (injectionCharInsertion.isInjectable(vendorSpecificWithOperator)) {
                    if (this.isSuspended()) {
                        throw new StoppedByUserSlidingException();
                    }
                    LOGGER.log(LogLevelUtil.CONSOLE_SUCCESS, "Found [{}] using Boolean match", vendor);
                    this.injectionModel.getMediatorVendor().setVendor((Vendor)vendor);
                    isVendorFound.set(true);
                    Request requestSetVendor = new Request();
                    requestSetVendor.setMessage(Interaction.SET_VENDOR);
                    EnumMap<Header, Object> msgHeader = new EnumMap<Header, Object>(Header.class);
                    msgHeader.put(Header.URL, this.injectionModel.getMediatorUtils().getConnectionUtil().getUrlByUser());
                    msgHeader.put(Header.VENDOR, this.injectionModel.getMediatorVendor().getVendor());
                    requestSetVendor.setParameters(msgHeader);
                    this.injectionModel.sendToViews(requestSetVendor);
                }
            }
            catch (StoppedByUserSlidingException e) {
                throw new JSqlRuntimeException(e);
            }
        });
        return null;
    }
}

