# transforms grammar js file into go
# cgo can't be used in tests
out=test_grammar.go

npm install tree-sitter-cli@0.20.0
export PATH=$PATH:./node_modules/.bin

tree-sitter generate $(pwd)/test_grammar.js

echo "//Code generated by test_grammar_generate.sh; DO NOT EDIT." > $out
echo "package sitter" >> $out
sed -e 's/^/\/\//' src/tree_sitter/parser.h >> $out
sed -e 's/^/\/\//' src/parser.c | grep -v "#include <tree_sitter/parser.h>" >> $out
echo "import \"C\"
import \"unsafe\"

func getTestGrammar() *Language {
	ptr := unsafe.Pointer(C.tree_sitter_test_grammar())
	return NewLanguage(ptr)
}" >> $out

# cleanup
rm binding.gyp
rm -rf node_modules/
rm -rf src/
rm package-lock.json
rm Cargo.toml
rm -rf bindings/
rm package.json
