/* ###
 * IP: GHIDRA
 * REVIEWED: YES
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ghidra.pcodeCPort.slghpatexpress;

import generic.stl.VectorSTL;
import ghidra.pcodeCPort.slghsymbol.Constructor;
import ghidra.pcodeCPort.slghsymbol.OperandSymbol;
import ghidra.sleigh.grammar.Location;

public abstract class PatternEquation {
	public final Location location;

	private int refcount; // Number of objects referencing this
	private TokenPattern resultpattern; // Resulting pattern generated by this equation

	protected final void setTokenPattern(TokenPattern tokenPattern) {
		this.resultpattern = new TokenPattern(location, tokenPattern);
	}

	protected void dispose() {
		// Only delete through release
	}

	public PatternEquation(Location location) {
		this.location = location;
		resultpattern = new TokenPattern(location);
		refcount = 0;
	}

	public TokenPattern getTokenPattern() {
		return resultpattern;
	}

	public abstract void genPattern(VectorSTL<TokenPattern> ops);
	
	public abstract boolean resolveOperandLeft(OperandResolve state);

	/**
		returns a vector of the self-defining OperandSymbols as they appear
		in left to right order in the pattern
	 * @param ct		is the Constructor containing the operands
	 * @param order     is the vector that will hold the ordered list
	 */
	public void operandOrder(Constructor ct, VectorSTL<OperandSymbol> order) {
		// by default do nothing
	}

	public void layClaim() {
		refcount += 1;
	}

	public static void release(PatternEquation pateq) {
		pateq.refcount -= 1;
		if (pateq.refcount <= 0)
			pateq.dispose();
	}
}
