/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine;

import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.AIMessage;
import org.jkiss.dbeaver.model.ai.engine.AIEngine;
import org.jkiss.dbeaver.model.ai.utils.AIUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public record AIEngineRequest(@NotNull List<AIMessage> messages) {
    public static AIEngineRequest of(@NotNull DBRProgressMonitor monitor, AIEngine engine, List<AIMessage> messages) throws DBException {
        int maxRequestSize = engine.getContextWindowSize(monitor);
        List<AIMessage> truncatedMessages = AIUtils.truncateMessages(messages, maxRequestSize);
        return new AIEngineRequest(truncatedMessages);
    }

    @Override
    public String toString() {
        return "AI request " + String.valueOf(this.messages);
    }
}

