/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

// BaselineAdminNetworkPolicySpecApplyConfiguration represents an declarative configuration of the BaselineAdminNetworkPolicySpec type for use
// with apply.
type BaselineAdminNetworkPolicySpecApplyConfiguration struct {
	Subject *AdminNetworkPolicySubjectApplyConfiguration              `json:"subject,omitempty"`
	Ingress []BaselineAdminNetworkPolicyIngressRuleApplyConfiguration `json:"ingress,omitempty"`
	Egress  []BaselineAdminNetworkPolicyEgressRuleApplyConfiguration  `json:"egress,omitempty"`
}

// BaselineAdminNetworkPolicySpecApplyConfiguration constructs an declarative configuration of the BaselineAdminNetworkPolicySpec type for use with
// apply.
func BaselineAdminNetworkPolicySpec() *BaselineAdminNetworkPolicySpecApplyConfiguration {
	return &BaselineAdminNetworkPolicySpecApplyConfiguration{}
}

// WithSubject sets the Subject field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Subject field is set to the value of the last call.
func (b *BaselineAdminNetworkPolicySpecApplyConfiguration) WithSubject(value *AdminNetworkPolicySubjectApplyConfiguration) *BaselineAdminNetworkPolicySpecApplyConfiguration {
	b.Subject = value
	return b
}

// WithIngress adds the given value to the Ingress field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Ingress field.
func (b *BaselineAdminNetworkPolicySpecApplyConfiguration) WithIngress(values ...*BaselineAdminNetworkPolicyIngressRuleApplyConfiguration) *BaselineAdminNetworkPolicySpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithIngress")
		}
		b.Ingress = append(b.Ingress, *values[i])
	}
	return b
}

// WithEgress adds the given value to the Egress field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Egress field.
func (b *BaselineAdminNetworkPolicySpecApplyConfiguration) WithEgress(values ...*BaselineAdminNetworkPolicyEgressRuleApplyConfiguration) *BaselineAdminNetworkPolicySpecApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithEgress")
		}
		b.Egress = append(b.Egress, *values[i])
	}
	return b
}
