import { MuiPickersAdapterContextValue } from '../../../LocalizationProvider/LocalizationProvider';
export interface ValidationProps<TError, TInputValue> {
    /**
     * Callback that fired when input value or new `value` prop validation returns **new** validation error (or value is valid after error).
     * In case of validation error detected `reason` prop return non-null value and `TextField` must be displayed in `error` state.
     * This can be used to render appropriate form error.
     *
     * [Read the guide](https://next.material-ui-pickers.dev/guides/forms) about form integration and error displaying.
     * @DateIOType
     *
     * @template TError, TInputValue
     * @param {TError} reason The reason why the current value is not valid.
     * @param {TInputValue} value The invalid value.
     */
    onError?: (reason: TError, value: TInputValue) => void;
    value: TInputValue;
}
export declare type InferError<TProps> = TProps extends Pick<ValidationProps<any, any>, 'onError'> ? Parameters<Exclude<TProps['onError'], undefined>>[0] : never;
declare type InferInputValue<TProps> = TProps extends {
    value: any;
} ? TProps['value'] : never;
export declare type Validator<TDate, TProps> = (params: {
    adapter: MuiPickersAdapterContextValue<TDate>;
    value: InferInputValue<TProps>;
    props: Omit<TProps, 'value' | 'onError'>;
}) => InferError<TProps>;
export declare function useValidation<TDate, TProps extends ValidationProps<any, any>>(props: TProps, validate: Validator<TDate, TProps>, isSameError: (a: InferError<TProps>, b: InferError<TProps> | null) => boolean): InferError<TProps>;
export {};
