export interface TreeItemClasses {
    /** Styles applied to the root element. */
    root: string;
    /** Styles applied to the transition component. */
    group: string;
    /** Styles applied to the content element. */
    content: string;
    /** State class applied to the content element when expanded. */
    expanded: string;
    /** State class applied to the content element when selected. */
    selected: string;
    /** State class applied to the content element when focused. */
    focused: string;
    /** State class applied to the element when disabled. */
    disabled: string;
    /** Styles applied to the tree node icon. */
    iconContainer: string;
    /** Styles applied to the label element. */
    label: string;
}
export type TreeItemClassKey = keyof TreeItemClasses;
export declare function getTreeItemUtilityClass(slot: string): string;
declare const treeItemClasses: TreeItemClasses;
export default treeItemClasses;
