import { ListState, ListReducerAction, ListActionContext, SelectionMode } from './useList.types';
/**
 * Gets the next item to highlight based on the current highlighted item and the search direction.
 *
 * @param previouslyHighlightedValue The item from which to start the search for the next candidate.
 * @param offset The offset from the previously highlighted item to search for the next candidate or a special named value ('reset', 'start', 'end').
 * @param context The list action context.
 *
 * @returns The next item to highlight or null if no item is valid.
 */
export declare function moveHighlight<ItemValue>(previouslyHighlightedValue: ItemValue | null, offset: number | 'reset' | 'start' | 'end', context: ListActionContext<ItemValue>): NonNullable<ItemValue> | (ItemValue & undefined) | null;
/**
 * Toggles the selection of an item.
 *
 * @param item Item to toggle.
 * @param selectedValues Already selected items.
 * @param selectionMode The number of items that can be simultanously selected.
 * @param itemComparer A custom item comparer function.
 *
 * @returns The new array of selected items.
 */
export declare function toggleSelection<ItemValue>(item: ItemValue, selectedValues: ItemValue[], selectionMode: SelectionMode, itemComparer: (item1: ItemValue, item2: ItemValue) => boolean): ItemValue[];
export default function listReducer<ItemValue, State extends ListState<ItemValue>>(state: State, action: ListReducerAction<ItemValue> & {
    context: ListActionContext<ItemValue>;
}): State;
