// Copyright 2025 Specter Ops, Inc.
//
// Licensed under the Apache License, Version 2.0
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0

import React from 'react';
import { BasePath, BaseSVG, BaseSVGProps } from './utils';

export const BHCELogo: React.FC<BaseSVGProps> = (props) => {
    return (
        <BaseSVG
            name='bhce-logo'
            id='Layer_1'
            xmlns='http://www.w3.org/2000/svg'
            viewBox='0 0 334.73 255.83'
            {...props}>
            <defs>
                <style>.cls-1</style>
            </defs>
            <BasePath
                className='cls-1'
                d='m330.01,219.78s-.04,0-.06,0l-6.38-17.37c1.04-.87,1.72-2.15,1.72-3.61,0-1.72-.93-3.21-2.31-4.04l.78-3.89c2.34-.28,4.15-2.25,4.15-4.66,0-2.61-2.11-4.72-4.72-4.72-.29,0-.58.04-.86.09l-19.51-29.12c.57-.78.92-1.74.92-2.78,0-2.61-2.11-4.72-4.72-4.72-.69,0-1.35.16-1.94.43l-18.37-19.12c.32-.64.52-1.35.52-2.11,0-2.61-2.11-4.72-4.72-4.72-.78,0-1.51.21-2.16.55l-15.19-14.21c.25-.58.4-1.22.4-1.89,0-2.61-2.11-4.72-4.72-4.72-.78,0-1.51.21-2.16.55l-12.06-11.28c.25-.58.4-1.22.4-1.89,0-2.61-2.11-4.72-4.72-4.72-1.38,0-2.61.6-3.47,1.54l-40.05-16.95c0-2.6-2.12-4.7-4.72-4.7-1.68,0-3.15.89-3.99,2.21l-36.97-5.64c-.4-2.2-2.32-3.87-4.63-3.87-2.06,0-3.79,1.32-4.44,3.16h-22.23c-.65-1.84-2.38-3.16-4.43-3.16-2.43,0-4.4,1.84-4.67,4.19l-19.9,4.63c-.84-1.31-2.3-2.18-3.97-2.18-2.2,0-4.04,1.51-4.56,3.55l-14.24,1.29c-.75-1.62-2.38-2.75-4.28-2.75-1.4,0-2.64.62-3.51,1.59l-16.47-6.73c.01-.15.05-.3.05-.46,0-2.61-2.11-4.72-4.72-4.72-.82,0-1.58.23-2.25.59l-12.34-12.34-5.24-11.72c1.05-.87,1.73-2.16,1.73-3.63,0-2.26-1.59-4.14-3.71-4.61l-.57-20.09-2.68-1.07L3.52,4.54l-.44.83L.11,21.81v.54s2.23,13.52,2.23,13.52c-1.39.82-2.34,2.32-2.34,4.05,0,2.61,2.11,4.72,4.72,4.72.25,0,.49-.04.74-.07l5,8.43c-.68.82-1.11,1.86-1.11,3,0,2.61,2.11,4.72,4.72,4.72.92,0,1.77-.27,2.5-.73l22.96,18.21c-.18.49-.29,1.02-.29,1.57,0,2.61,2.11,4.72,4.72,4.72,1.54,0,2.9-.75,3.76-1.89l13.82,4.41c.06,1.75,1.07,3.25,2.54,4.02l-2.97,21.36c-2.15.44-3.77,2.34-3.77,4.62s1.54,4.07,3.6,4.57l1.2,11.89c-1.6.76-2.71,2.37-2.71,4.25,0,1.28.52,2.45,1.35,3.3l-7.28,14.84c-.15-.01-.3-.05-.45-.05-2.61,0-4.72,2.11-4.72,4.72,0,.71.17,1.37.44,1.97l-13.63,13.66c-.61-.29-1.29-.47-2.02-.47-2.61,0-4.72,2.11-4.72,4.72,0,1.56.76,2.92,1.92,3.78l-5.83,19.16c-2.5.11-4.5,2.16-4.5,4.7s2.11,4.72,4.72,4.72c.27,0,.54-.04.8-.08l11.64,20.72c-.76.84-1.23,1.94-1.23,3.15,0,2.61,2.11,4.72,4.72,4.72,2.03,0,3.75-1.29,4.41-3.09l25.81.34,1.52-2.06-2.6-7.96c1.04-.87,1.71-2.15,1.71-3.61,0-2.61-2.11-4.72-4.72-4.72-1.06,0-2.03.36-2.82.96l-12.97-6.74c.03-.21.06-.42.06-.64,0-1.73-.94-3.23-2.33-4.05l3.03-15.56c2.27-.34,4.02-2.28,4.02-4.65,0-.59-.12-1.14-.31-1.66l15.76-13.29c.7.41,1.5.66,2.37.66,2.61,0,4.72-2.11,4.72-4.72,0-.88-.26-1.7-.68-2.4l10.57-12.59c.51.19,1.06.31,1.64.31.22,0,.42-.04.63-.06l8.26,15.98c-.79.84-1.29,1.97-1.29,3.22,0,1.45.67,2.73,1.7,3.6l-5.3,14.24s-.05,0-.07,0c-2.61,0-4.72,2.11-4.72,4.72s2.1,4.7,4.69,4.72l9.78,28.21c-.84.85-1.36,2.02-1.36,3.32,0,2.61,2.11,4.72,4.72,4.72.62,0,1.21-.13,1.75-.34l11.53,11.06c-.27.59-.43,1.25-.43,1.94,0,2.61,2.11,4.72,4.72,4.72,2.05,0,3.78-1.32,4.43-3.15h18.12l1.43-2.22-3.34-7.43c.85-.85,1.38-2.03,1.38-3.33,0-2.61-2.11-4.72-4.72-4.72-1.2,0-2.29.46-3.12,1.2l-7.94-3.84c.02-.17.05-.33.05-.51,0-2.56-2.04-4.64-4.59-4.71l-8.81-27.22c1.12-.86,1.86-2.2,1.86-3.73,0-1.24-.49-2.36-1.27-3.2l10.31-19.68c.22.03.43.07.66.07,2.61,0,4.72-2.11,4.72-4.72,0-1.78-.99-3.3-2.44-4.11l3.26-19.57c.97-.17,1.85-.63,2.52-1.3l27.25,13.02c-.01.14-.04.28-.04.43,0,1.41.63,2.65,1.6,3.52l-8.74,23.49s-.05,0-.07,0c-2.61,0-4.72,2.11-4.72,4.72,0,1.84,1.06,3.41,2.59,4.19l-3.6,27.65c-2.12.46-3.71,2.35-3.71,4.61,0,2.61,2.11,4.72,4.72,4.72.32,0,.64-.03.94-.1l10.71,18.64c-.48.74-.77,1.62-.77,2.56,0,2.61,2.11,4.72,4.72,4.72,2.05,0,3.78-1.32,4.43-3.15h27.15l1.37-2.35-5.52-9.66c.71-.83,1.16-1.89,1.16-3.06,0-2.61-2.11-4.72-4.72-4.72-1.3,0-2.48.53-3.34,1.38l-11.73-5.61c.02-.16.05-.32.05-.49,0-1.93-1.16-3.59-2.83-4.32l1.72-23.56c2.2-.4,3.86-2.32,3.86-4.63,0-1.09-.38-2.07-1-2.87l11.94-16.48c.42.12.86.21,1.32.21,2.36,0,4.3-1.74,4.65-4l3.73-.71c.73,1.24,2,2.11,3.5,2.29l1.82,8.08c-1.38.82-2.31,2.32-2.31,4.04,0,2.61,2.11,4.72,4.72,4.72.1,0,.19-.02.28-.03l12.15,32.58c-1.05.87-1.74,2.16-1.74,3.63,0,2.61,2.11,4.72,4.72,4.72.69,0,1.34-.16,1.93-.42l12.29,13.36c-.18.5-.3,1.04-.3,1.61,0,2.61,2.11,4.72,4.72,4.72,1.9,0,3.53-1.13,4.28-2.75h25.93l1.29-2.48-9.31-13.25c.41-.7.66-1.5.66-2.36,0-2.61-2.11-4.72-4.72-4.72-1.33,0-2.53.56-3.39,1.45l-10.31-4.29c.01-.14.04-.27.04-.4,0-2.46-1.88-4.45-4.28-4.68l-8.12-33.28c1.2-.79,2-2.11,2.11-3.63l8.23-2.31c.86,1.2,2.25,1.99,3.84,1.99,1.3,0,2.47-.53,3.33-1.37l8.6,4.08c-.01.13-.04.26-.04.39,0,1.4.62,2.64,1.58,3.5l-5.51,13.13c-.09,0-.17-.03-.26-.03-2.61,0-4.72,2.11-4.72,4.72s2.11,4.72,4.72,4.72c.54,0,1.06-.11,1.54-.28l14.64,18.26c-.45.72-.72,1.56-.72,2.48,0,2.61,2.11,4.72,4.72,4.72s4.72-2.11,4.72-4.72c0-1.18-.45-2.24-1.16-3.07l6.1-10.71c.24.06.48.08.73.1l3.04,12.6c-1.29.84-2.15,2.29-2.15,3.95,0,2.61,2.11,4.72,4.72,4.72,1.62,0,3.06-.82,3.91-2.07l19.61,5.13c.54,2.01,2.36,3.49,4.54,3.49,2.61,0,4.72-2.11,4.72-4.72,0-.94-.28-1.8-.75-2.54l4.95-7.81c.34.08.69.13,1.05.13,2.61,0,4.72-2.11,4.72-4.72s-2.11-4.72-4.72-4.72Zm-54.01,5.51s-.04,0-.07,0l-9.13-37.57c1.56-.77,2.64-2.36,2.64-4.22,0-.89-.26-1.71-.69-2.42l27.76-27.42c.19.12.4.24.61.33l-6.17,30.79c-2.53.08-4.56,2.15-4.56,4.7,0,1.91,1.14,3.54,2.76,4.28l-2.64,13.18c-2.5.12-4.49,2.17-4.49,4.7,0,1.08.38,2.06.98,2.86l-6.19,10.86c-.27-.05-.55-.08-.83-.08Zm-32.57-49.89l-8.21,2.3c-.85-1.21-2.26-2.01-3.85-2.01s-3.02.8-3.87,2.03l-18.69-7.54c.04-.24.07-.49.07-.74,0-.9-.26-1.72-.7-2.44l17.21-16.68c.74.48,1.62.77,2.57.77.66,0,1.29-.14,1.86-.38l14.84,21.79c-.71.77-1.16,1.78-1.23,2.89Zm-15.49,51.52l9.56-2.35c.63,1.15,1.72,2.02,3.04,2.33l-.11,15.04c-.33.11-.64.24-.94.42l-12.06-13.11c.32-.64.52-1.35.52-2.11,0-.07-.02-.14-.02-.21Zm-16.04-38.34c.4-.7.65-1.49.65-2.35,0-2.37-1.76-4.32-4.04-4.65l-1.84-8.15c.53-.34,1-.77,1.36-1.29l18.69,7.54c-.04.24-.07.49-.07.74,0,2.44,1.86,4.43,4.24,4.67l8.02,32.88-27.01-29.39Zm-24.69,50.33l-16.05,8.84c-.85-.83-2.01-1.34-3.29-1.34-.5,0-.97.1-1.42.24l-10.56-18.37c.34-.42.62-.89.8-1.41l10.62,1.65c.18,2.45,2.19,4.38,4.69,4.38,1.3,0,2.48-.53,3.34-1.38l11.73,5.61c-.02.16-.05.32-.05.49,0,.45.08.88.2,1.29Zm-26.36-47.38l9.22,3.69c-.01.15-.05.3-.05.45,0,1.07.37,2.05.97,2.84l-16.55,21.96,3.51-27.01c1.2-.25,2.22-.96,2.89-1.93Zm6.76,34.91l-10.69-1.66c-.11-.99-.52-1.89-1.14-2.6l16.69-22.14-1.72,23.6c-1.43.39-2.59,1.43-3.13,2.79Zm7.13-35.49s-.02,0-.03,0l-4.24-29.39c1.83-.65,3.15-2.38,3.15-4.43,0-.89-.26-1.7-.68-2.41l8.48-7.81c.61.44,1.33.74,2.11.85l5.89,19.96c-1.44.81-2.42,2.33-2.42,4.1,0,1,.31,1.92.84,2.68l-12.02,16.6c-.35-.08-.71-.14-1.08-.14Zm-72.57-20.71c-.22,0-.42.04-.63.06l-8.26-15.98c.11-.12.22-.25.32-.38l30.69,13.8c-.06.3-.09.61-.09.93,0,.01,0,.02,0,.03l-17.81,4.19c-.77-1.56-2.36-2.65-4.22-2.65Zm-28.58-4.46c-.09,0-.17.02-.26.03l-6.9-23.97c1.45-.81,2.44-2.33,2.44-4.11,0-2.22-1.54-4.07-3.6-4.57l-1.2-11.89s.05-.03.07-.04l22,26.98c-.62.8-1.01,1.79-1.01,2.89,0,.87.25,1.68.67,2.39l-10.56,12.61c-.51-.19-1.06-.31-1.64-.31ZM18.53,57.46l9.95.92c.39,2.22,2.31,3.9,4.64,3.9.31,0,.6-.03.89-.09l6.38,12.67-21.88-17.36s.01-.04.02-.05Zm29.6,20.15l6.85-5.93c.78.57,1.74.92,2.78.92.31,0,.62-.03.92-.09l4.73,10.58c-.35.26-.65.57-.92.91l-13.84-4.41c-.03-.71-.22-1.38-.53-1.98Zm184.33,13.29c.56.24,1.18.37,1.83.37.78,0,1.51-.21,2.16-.55l12.06,11.28c-.25.58-.4,1.22-.4,1.89,0,2.05,1.31,3.78,3.14,4.43l-2.08,17.61c-1.5.16-2.78,1.01-3.53,2.25l-29.83-9.76c0-.11.03-.21.03-.32,0-1.05-.35-2.01-.93-2.79l17.55-24.41Zm-25.4,24.85l-29.79-8.53c0-.09.03-.17.03-.25,0-1.71-.92-3.2-2.29-4.02l10.52-31.84c.18.02.35.05.54.05.42,0,.82-.07,1.2-.17l21.15,43.26c-.56.39-1.02.91-1.36,1.5Zm-62.02-29.47c.23-.55.36-1.16.36-1.79,0-.26-.04-.5-.08-.75l36.73-14.85c.38.62.89,1.14,1.5,1.53l-10.53,31.87c-.15-.01-.29-.04-.44-.04-1.21,0-2.31.47-3.14,1.22l-24.39-17.19Zm-.5-4.49c-.67-.97-1.7-1.67-2.89-1.92l-.26-16.1c1.39-.27,2.54-1.17,3.2-2.37l36.58,5.58-36.63,14.81Zm-5.25-18.1l.26,16.22c-2.06.51-3.6,2.35-3.6,4.57,0,.26.04.5.08.75l-13.1,5.3c-.79-1.26-2.16-2.11-3.74-2.19l-7.5-25.11c.98-.56,1.73-1.44,2.11-2.52h22.24c.52,1.46,1.73,2.59,3.25,2.98Zm-48.38,82.8l.21-36.96c.48-.11.93-.3,1.34-.54l36.92,29.3c-.3.62-.48,1.3-.48,2.03,0,.03,0,.05,0,.08l-34.87,8.56c-.62-1.23-1.75-2.15-3.13-2.47Zm39.78-9.83l-36.67-29.1c.5-.75.8-1.65.8-2.62,0-.26-.04-.5-.08-.75l20.48-8.28c.86,1.11,2.2,1.84,3.72,1.84.29,0,.57-.04.84-.09l11.52,38.57c-.22.12-.42.26-.62.42Zm-21.32-72.8c.1,0,.2-.02.31-.03l7.43,24.86c-1.69.72-2.88,2.39-2.88,4.35,0,.33.04.66.1.97l-20.36,8.23c-.85-1.22-2.26-2.02-3.87-2.02-1.36,0-2.57.58-3.44,1.5l-16.18-12.84c.3-.62.48-1.3.48-2.03,0-1.23-.48-2.33-1.25-3.17l9.37-13.52c.54.22,1.13.35,1.76.35,2.43,0,4.41-1.84,4.67-4.2l19.9-4.62c.84,1.31,2.3,2.18,3.97,2.18Zm-32.01,5.09l-9.37,13.52c-.54-.22-1.13-.35-1.76-.35-.31,0-.62.03-.92.09l-4.73-10.58c.84-.64,1.46-1.54,1.73-2.59l14.24-1.29c.2.44.48.85.8,1.2Zm-8.19,21.56l16.43,13.04c-.13.44-.23.9-.23,1.38,0,2.24,1.56,4.1,3.64,4.59l-.21,36.96c-.37.08-.73.22-1.06.39l-22-26.98c.62-.8,1.01-1.79,1.01-2.89,0-1.82-1.04-3.38-2.55-4.17l2.97-21.36c.75-.15,1.42-.5,1.99-.96Zm55.98,75.3l-30.69-13.8c.06-.3.09-.61.09-.93,0-.03,0-.05,0-.08l34.87-8.56c.43.85,1.09,1.54,1.92,2l-3.26,19.57c-1.19.21-2.22.87-2.93,1.8Zm11.27-29.26c-.79-.58-1.75-.94-2.8-.94-.1,0-.2.02-.31.03l-11.59-38.81c1.17-.86,1.94-2.23,1.94-3.79,0-.18-.03-.34-.05-.52l13.2-5.34c.85,1.22,2.26,2.02,3.87,2.02,1.21,0,2.31-.47,3.14-1.22l24.39,17.19c-.23.55-.36,1.16-.36,1.79,0,.79.21,1.53.56,2.18l-31.99,27.4Zm40.26-27.32l29.75,8.52c0,.12-.04.23-.04.35,0,.85.24,1.64.64,2.33l-20.31,18.7c-.74-.48-1.62-.77-2.57-.77-.41,0-.8.07-1.18.17l-8.11-27.47c.76-.43,1.39-1.06,1.81-1.83Zm15.03,57.84c-.1,0-.19.02-.29.03l-5.78-19.56c1.88-.62,3.24-2.37,3.24-4.46,0-.9-.26-1.73-.7-2.44l20.26-18.66c.76.52,1.68.83,2.67.83.61,0,1.18-.12,1.71-.33l12,20.36c-.97.86-1.6,2.11-1.6,3.52,0,.9.27,1.73.7,2.45l-17.22,16.68c-.74-.48-1.62-.77-2.57-.77-2.36,0-4.3,1.74-4.65,4l-3.73.71c-.82-1.4-2.32-2.35-4.06-2.35Zm39.33-24.25c-.83-.73-1.9-1.18-3.09-1.18-.45,0-.87.08-1.28.2l-12.11-20.54c.25-.26.45-.56.63-.87l29.79,9.74c-.01.14-.04.28-.04.43,0,.66.14,1.28.38,1.85l-14.29,10.37Zm20.21-16.66l2.08-17.61c.59-.06,1.15-.23,1.65-.49l15.19,14.21c-.25.58-.4,1.22-.4,1.89,0,1.97,1.21,3.66,2.93,4.36l-3.55,21.21c-.66.04-1.28.21-1.84.49l-13.91-16.77c.61-.8.99-1.78.99-2.86,0-2.05-1.31-3.78-3.14-4.43Zm18.48,32.95c2.46-.16,4.42-2.19,4.42-4.69,0-1.97-1.21-3.66-2.93-4.36l3.55-21.21c.59-.04,1.15-.17,1.67-.4l18.38,19.1c-.33.64-.53,1.36-.53,2.13,0,.92.27,1.77.73,2.5l-27.73,27.38c-.25-.17-.52-.31-.8-.42l3.24-20.03Zm46.1,39.69c0,.12.03.23.03.34l-5.75,1.77c-.82-1.41-2.32-2.37-4.07-2.37-.9,0-1.72.26-2.44.7l-8.35-7.55c.29-.55.47-1.16.53-1.82l22.81-2.6c.28,1.23,1.05,2.28,2.09,2.93l-.79,3.95c-2.28.33-4.05,2.28-4.05,4.65Zm2.75-13.64l-23.1,2.63c-.45-1.16-1.35-2.1-2.49-2.61l6.17-30.79c.36-.01.7-.07,1.03-.15l19.39,28.94c-.48.57-.84,1.24-1.01,1.98Zm-30.02,22.14l2.62-13.1c1.01-.02,1.94-.36,2.7-.92l8.2,7.41c-.48.74-.77,1.62-.77,2.57,0,1.5.71,2.82,1.81,3.69l-10.13,21.34c-.17-.04-.35-.05-.53-.07l-3.06-12.69c1.23-.85,2.04-2.27,2.04-3.88,0-1.96-1.19-3.63-2.88-4.35Zm6.32,21.9l10.13-21.34c.33.07.67.12,1.02.12.22,0,.43-.04.64-.06l10.51,27.78c-.62.47-1.12,1.08-1.44,1.79l-19.09-5c-.11-1.33-.77-2.5-1.77-3.29Zm25.14,5.52c-.32,0-.63.03-.93.09l-10.45-27.63c.12-.08.22-.18.33-.27l16.91,15.28c-.38.68-.62,1.46-.62,2.29,0,1.1.39,2.1,1.02,2.9l-4.8,7.58c-.46-.15-.95-.26-1.46-.26Zm6.68-14.61l-16.41-14.83c.29-.61.47-1.29.47-2.02,0-.12-.03-.23-.03-.34l5.75-1.77c.82,1.41,2.32,2.37,4.07,2.37.02,0,.04,0,.06,0l6.1,16.6Zm-95.95-130.45l-17.46,24.28c-.66-.35-1.39-.56-2.19-.56-.26,0-.51.04-.76.08l-21.25-43.45c.22-.19.42-.39.6-.62l39.89,16.88c0,.09-.03.18-.03.28,0,1.2.46,2.28,1.19,3.11Zm-177.7-22c0,.07-.02.14-.02.22,0,.8.22,1.54.57,2.2l-6.84,5.92c-.79-.59-1.76-.96-2.82-.96-.37,0-.72.05-1.06.13l-6.97-13.84c.19-.14.38-.29.54-.46l16.59,6.78Zm-24.31-11.88c-.07.16-.11.34-.16.51l-9.87-.91c-.31-2.31-2.26-4.1-4.66-4.1-.31,0-.62.03-.92.09l-4.93-8.32c.33-.37.61-.78.81-1.23l6.91,1.06.17.25,12.66,12.66ZM7.37,29.42l-2,5.52-1.8-10.9,2.1.89c-.05.27-.08.54-.08.82,0,1.49.7,2.8,1.78,3.66Zm7.49,11.17l-5.44-.83c-.05-1.61-.9-3.01-2.18-3.82l2.02-5.59c.34.08.69.13,1.05.13,0,0,.02,0,.03,0l4.52,10.12ZM6.09,6.42l1.62-1.62.48,16.76c-.67.34-1.25.83-1.69,1.44l-3.16-1.34,2.76-15.24Zm57.52,135.96c.18.02.35.05.54.05.09,0,.17-.02.26-.03l6.9,23.97c-1.45.81-2.44,2.33-2.44,4.11,0,.59.12,1.14.31,1.66l-15.76,13.29c-.32-.19-.66-.33-1.02-.44l1.31-19.82c2.29-.32,4.06-2.27,4.06-4.65,0-1.32-.54-2.5-1.41-3.36l7.25-14.79Zm-1.51,83.02l-17.73,8.3c-.41-.54-.94-.98-1.54-1.3l3.42-13.94s.05,0,.08,0c1.24,0,2.37-.49,3.21-1.28l12.66,6.58c-.09.36-.15.74-.15,1.13,0,.17.03.34.05.5Zm-33.23-15.15c6.21,1.66,10.2,2.71,12.75,3.38,0,.04-.01.08-.01.13,0,1.84,1.07,3.42,2.61,4.2l-3.42,13.91c-.06,0-.11-.02-.16-.02-.25,0-.48.04-.72.07l-11.67-20.78c.24-.27.44-.57.61-.9Zm13.28,1.35c-3.39-.89-8.25-2.18-12.74-3.38,0-.06.02-.11.02-.17,0-1.56-.76-2.92-1.92-3.78l5.83-19.16c1.37-.06,2.57-.71,3.39-1.69l9.75,4.94c-.09.37-.15.74-.15,1.14,0,1.73.94,3.23,2.33,4.05l-3.03,15.56c-1.52.23-2.8,1.18-3.48,2.49Zm9.46-46.59l-1.31,19.85c-1.15.18-2.15.78-2.87,1.64l-9.75-4.94c.09-.37.15-.74.15-1.14,0-.73-.18-1.41-.47-2.03l13.61-13.64c.21.1.42.18.64.25Zm17.09,70.35l-22.3-.29,16.38-7.67c.83,1.33,2.3,2.22,3.99,2.22.02,0,.04,0,.05,0l1.88,5.74Zm33.39-55.69s.05,0,.07,0c2.61,0,4.72-2.11,4.72-4.72,0-.01,0-.02,0-.03l17.81-4.19c.2.41.46.79.77,1.13l-10.31,19.68c-.22-.03-.43-.07-.66-.07-2.35,0-4.28,1.72-4.64,3.96l-11.57.73c-.27-.9-.79-1.68-1.49-2.26l5.3-14.24Zm35.07,61.1l-10.94,5.98c-.55-.22-1.14-.35-1.77-.35-.76,0-1.47.2-2.11.52l-11.35-10.89c.29-.52.48-1.11.56-1.73l10.02-.97c.62,1.88,2.37,3.24,4.46,3.24,1.3,0,2.47-.52,3.32-1.37l7.77,3.75c-.04.25-.08.5-.08.76,0,.36.05.71.13,1.05Zm-38.75-42.51l11.57-.73c.39,1.3,1.3,2.36,2.51,2.93l-6.17,28.44-9.61-27.72c.89-.71,1.52-1.73,1.71-2.91Zm22.95,32.98l-10.04.97c-.48-1.38-1.56-2.45-2.94-2.92l6.08-28.05,8.7,26.88c-.97.75-1.63,1.85-1.8,3.13Zm7.52,18.3c-.19-.52-.46-1-.81-1.42l10.01-5.48c.86,1.08,2.18,1.78,3.67,1.78.17,0,.33-.03.49-.05l2.32,5.16h-15.69Zm9.42-108.71c.02-.16.05-.32.05-.49,0-.79-.21-1.53-.56-2.18l31.99-27.4c.79.58,1.75.94,2.8.94.1,0,.19-.02.29-.03l8.23,27.88c-1,.87-1.64,2.13-1.64,3.55,0,.81.22,1.56.58,2.22l-8.55,7.87c-.75-.49-1.64-.78-2.6-.78-1.32,0-2.52.55-3.37,1.43l-27.22-13Zm30.17,21.6l4.19,29.02c-.8.4-1.47,1.01-1.94,1.77l-9.11-3.64c.04-.24.07-.48.07-.73,0-1.45-.67-2.74-1.7-3.6l8.49-22.82Zm3.82,87.12s0-.02,0-.03l15.93-8.77c.86.97,2.11,1.59,3.51,1.59.29,0,.56-.04.84-.08l4.17,7.29h-24.44Zm39.34-58.16l26.05,28.34c-.49.74-.77,1.63-.77,2.58,0,.08.02.16.02.24l-9.55,2.35c-.8-1.48-2.34-2.49-4.14-2.49-.01,0-.02,0-.03,0l-11.58-31.02Zm34.81,53.83c-.09-.35-.23-.69-.39-1.01l11.51-9.93c.72.44,1.55.71,2.45.71.58,0,1.14-.12,1.65-.31l7.4,10.54h-22.62Zm8.89-15.35c-.01.13-.04.26-.04.4,0,.94.28,1.81.76,2.55l-11.36,9.8c-.62-.46-1.35-.76-2.15-.87l.11-14.83c.92-.2,1.74-.67,2.37-1.33l10.31,4.29Zm-2.54-53.68c.02-.17.05-.33.05-.5,0-2.61-2.11-4.72-4.72-4.72-.61,0-1.19.13-1.73.34l-14.88-21.85c.72-.83,1.18-1.9,1.18-3.09,0-.66-.14-1.28-.38-1.85l14.29-10.37c.83.73,1.9,1.18,3.09,1.18.77,0,1.48-.2,2.12-.52l13.91,16.77c-.61.8-.99,1.78-.99,2.86,0,1.98,1.22,3.67,2.95,4.37l-3.24,20.02c-1.22.08-2.31.6-3.11,1.42l-8.54-4.06Zm11.71,12.02c.08,0,.15.02.23.02.02,0,.03,0,.05,0l8.8,36.24-13.76-17.16c.45-.72.72-1.56.72-2.48,0-1.38-.61-2.61-1.55-3.48l5.52-13.15Z'
            />
            <BasePath />
        </BaseSVG>
    );
};
